/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.spring.data.jdbc.plus.sql.convert;

import com.navercorp.spring.data.jdbc.plus.sql.convert.JdbcBackReferencePropertyValueProvider;
import com.navercorp.spring.data.jdbc.plus.sql.convert.JdbcPropertyValueProvider;
import com.navercorp.spring.data.jdbc.plus.sql.convert.PropertyPathUtils;
import com.navercorp.spring.data.jdbc.plus.sql.convert.ResultMapPropertyAccessor;
import com.navercorp.spring.data.jdbc.plus.sql.convert.ResultSetAccessor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.jdbc.core.convert.BasicJdbcConverter;
import org.springframework.data.jdbc.core.convert.Identifier;
import org.springframework.data.jdbc.core.convert.JdbcTypeFactory;
import org.springframework.data.jdbc.core.convert.RelationResolver;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.DefaultSpELExpressionEvaluator;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.data.mapping.model.SpELExpressionParameterValueProvider;
import org.springframework.data.relational.core.mapping.PersistentPropertyPathExtension;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.util.Streamable;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class AggregateResultJdbcConverter
extends BasicJdbcConverter {
    private final IdentifierProcessing identifierProcessing;
    private SpELContext spElContext;

    public AggregateResultJdbcConverter(MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context, RelationResolver relationResolver) {
        super(context, relationResolver);
        this.identifierProcessing = IdentifierProcessing.ANSI;
        this.spElContext = new SpELContext(ResultMapPropertyAccessor.INSTANCE);
    }

    public AggregateResultJdbcConverter(MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context, RelationResolver relationResolver, CustomConversions conversions, JdbcTypeFactory typeFactory, IdentifierProcessing identifierProcessing) {
        super(context, relationResolver, conversions, typeFactory, identifierProcessing);
        this.identifierProcessing = identifierProcessing;
        this.spElContext = new SpELContext(ResultMapPropertyAccessor.INSTANCE);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        super.setApplicationContext(applicationContext);
        this.spElContext = new SpELContext(this.spElContext, (BeanFactory)applicationContext);
    }

    public final <T> List<T> mapAggregate(RelationalPersistentEntity<T> entity, ResultSet resultSet) {
        try {
            ResultSetHolder resultSetHolder = new ResultSetHolder(resultSet);
            EntityPathRelations entityPathRelations = this.getEntityPathRelations(entity);
            List<Map<String, Object>> aggregateMapList = this.extractData(resultSetHolder, entityPathRelations);
            ArrayList<T> result = new ArrayList<T>();
            for (Map<String, Object> aggregateMap : aggregateMapList) {
                T aggregate = this.mapAggregate(entity, aggregateMap);
                result.add(aggregate);
            }
            return result;
        }
        catch (Exception e) {
            throw new MappingException("Result aggregate failure. entity: " + entity.getType(), (Throwable)e);
        }
    }

    protected Map<String, Object> mapSingleTableRow(RelationalPersistentEntity<?> entity, ResultSet resultSet) {
        return new SingleTableMapReadingContext(new PersistentPropertyPathExtension(this.getMappingContext(), entity), new ResultSetAccessor(resultSet), Identifier.empty(), null).mapRow();
    }

    protected Map<String, Object> mapSingleTableRow(PersistentPropertyPathExtension path, ResultSet resultSet, Identifier identifier) {
        return new SingleTableMapReadingContext(path.getLeafEntity(), new ResultSetAccessor(resultSet), path.getParentPath(), path, identifier, null).mapRow();
    }

    protected Map.Entry<Object, Map<String, Object>> mapSingleTableMapRow(PersistentPropertyPathExtension path, ResultSet resultSet, Identifier identifier, Object key) {
        Map<String, Object> mapValue = new SingleTableMapReadingContext(path.getLeafEntity(), new ResultSetAccessor(resultSet), path.getParentPath(), path, identifier, key).mapRow();
        return new AbstractMap.SimpleEntry<Object, Map<String, Object>>(key, mapValue);
    }

    protected <T> T mapAggregate(RelationalPersistentEntity<T> entity, Map<String, Object> aggregateMap) {
        return new MapReadingContext(new PersistentPropertyPathExtension(this.getMappingContext(), entity), aggregateMap).mapRow();
    }

    private List<Map<String, Object>> extractData(ResultSetHolder resultSetHolder, EntityPathRelations entityPathRelations) throws SQLException {
        PersistentPropertyPathExtension rootPath = entityPathRelations.getRootPath();
        RelationalPersistentEntity persistentEntity = rootPath.getLeafEntity();
        LinkedHashMap<Object, ExtractedRow> extractedRows = new LinkedHashMap<Object, ExtractedRow>();
        while (!resultSetHolder.isDone() && resultSetHolder.next()) {
            Map<String, Object> entityMap = this.mapSingleTableRow(persistentEntity, resultSetHolder.getResultSet());
            Object rootId = this.getRootId(resultSetHolder, persistentEntity);
            ExtractedRow rootRow = (ExtractedRow)extractedRows.get(rootId);
            if (rootRow == null) {
                rootRow = new ExtractedRow(null, persistentEntity, entityMap, rootId, null, (MultiValueMap<PersistentPropertyPathExtension, ExtractedRow>)new LinkedMultiValueMap());
                extractedRows.put(rootId, rootRow);
            }
            this.appendExtractRelationRows(resultSetHolder, rootRow, entityPathRelations.getRelations());
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(extractedRows.size());
        for (Map.Entry row : extractedRows.entrySet()) {
            ExtractedRow extractedRow = (ExtractedRow)row.getValue();
            MultiValueMap<PersistentPropertyPathExtension, RelationValue> relations = this.accumulateRelations(extractedRow.getRelations());
            this.setEntityRelations(extractedRow.getRoot(), extractedRow.getRootEntity(), relations);
            result.add(extractedRow.getRoot());
        }
        return result;
    }

    private void appendExtractRelationRows(ResultSetHolder resultSetHolder, ExtractedRow rootRow, Map<PersistentPropertyPathExtension, EntityPathRelations> relationEntityPaths) throws SQLException {
        MultiValueMap<PersistentPropertyPathExtension, ExtractedRow> relationEntities = rootRow.getRelations();
        for (Map.Entry<PersistentPropertyPathExtension, EntityPathRelations> relationEntityPath : relationEntityPaths.entrySet()) {
            PersistentPropertyPathExtension relationPath = relationEntityPath.getKey();
            List relationRows = (List)relationEntities.get((Object)relationPath);
            String idColumnAlias = this.getIdColumnAlias(relationEntityPath.getKey());
            Object relationEntityId = resultSetHolder.getResultSet().getObject(idColumnAlias);
            if (relationEntityId == null) continue;
            Identifier identifier = this.getRelationEntityIdentifier(relationPath, rootRow.getRootEntity(), rootRow.getRoot());
            if (CollectionUtils.isEmpty((Collection)relationRows)) {
                ExtractedRow extractedRow = this.extractRelationRow(resultSetHolder, rootRow.getRootId(), relationPath, identifier, relationEntityId, relationEntityPath.getValue().getRelations());
                ArrayList newRelations = new ArrayList();
                newRelations.add(extractedRow);
                relationEntities.put((Object)relationPath, (Object)newRelations);
                continue;
            }
            ExtractedRow existRow = null;
            for (ExtractedRow relationRow : relationRows) {
                if (!relationRow.getRootId().equals(relationEntityId)) continue;
                existRow = relationRow;
                break;
            }
            if (existRow != null) {
                this.appendExtractRelationRows(resultSetHolder, existRow, relationEntityPath.getValue().getRelations());
                continue;
            }
            ExtractedRow relationExtractedRows = this.extractRelationRow(resultSetHolder, rootRow.getRootId(), relationPath, identifier, relationEntityId, relationEntityPath.getValue().getRelations());
            relationEntities.add((Object)relationPath, (Object)relationExtractedRows);
        }
    }

    private ExtractedRow extractRelationRow(ResultSetHolder resultSetHolder, Object rootId, PersistentPropertyPathExtension relationPath, Identifier identifier, Object relationEntityId, Map<PersistentPropertyPathExtension, EntityPathRelations> nestedRelations) throws SQLException {
        Map<String, Object> relationValue;
        Object key = null;
        if (relationPath.isMap()) {
            String keyColumn = this.getQualifierColumnAlias(relationPath);
            key = resultSetHolder.getResultSet().getObject(keyColumn);
            Map.Entry<Object, Map<String, Object>> relationMapEntry = this.mapSingleTableMapRow(relationPath, resultSetHolder.getResultSet(), identifier, key);
            relationValue = relationMapEntry.getValue();
        } else {
            relationValue = this.mapSingleTableRow(relationPath, resultSetHolder.getResultSet(), identifier);
        }
        ExtractedRow extractedRow = new ExtractedRow(rootId, relationPath.getLeafEntity(), relationValue, relationEntityId, key, (MultiValueMap<PersistentPropertyPathExtension, ExtractedRow>)new LinkedMultiValueMap());
        this.appendExtractRelationRows(resultSetHolder, extractedRow, nestedRelations);
        return extractedRow;
    }

    private EntityPathRelations getEntityPathRelations(RelationalPersistentEntity<?> entity) {
        MappingContext mappingContext = this.getMappingContext();
        PersistentPropertyPathExtension rootPath = new PersistentPropertyPathExtension(mappingContext, entity);
        return this.getEntityPathRelations(rootPath);
    }

    private EntityPathRelations getEntityPathRelations(PersistentPropertyPathExtension entityPath) {
        HashMap<PersistentPropertyPathExtension, EntityPathRelations> relations = new HashMap<PersistentPropertyPathExtension, EntityPathRelations>();
        MappingContext mappingContext = this.getMappingContext();
        for (RelationalPersistentProperty property : entityPath.getLeafEntity()) {
            if (property.isEmbedded() || !property.isEntity() && (!property.isCollectionLike() || !property.isEntity()) && !property.isMap()) continue;
            PersistentPropertyPath propertyPath = entityPath.extendBy(property).getRequiredPersistentPropertyPath();
            PersistentPropertyPathExtension relationPath = new PersistentPropertyPathExtension(mappingContext, propertyPath);
            EntityPathRelations entityPathRelations = this.getEntityPathRelations(relationPath);
            relations.put(relationPath, entityPathRelations);
        }
        return new EntityPathRelations(entityPath, relations);
    }

    private MultiValueMap<PersistentPropertyPathExtension, RelationValue> accumulateRelations(MultiValueMap<PersistentPropertyPathExtension, ExtractedRow> extractedRows) {
        LinkedMultiValueMap relations = new LinkedMultiValueMap();
        for (Map.Entry extractedRow : extractedRows.entrySet()) {
            PersistentPropertyPathExtension path = (PersistentPropertyPathExtension)extractedRow.getKey();
            List rowValues = (List)extractedRow.getValue();
            for (ExtractedRow rowValue : rowValues) {
                relations.add((Object)path, (Object)new RelationValue(rowValue.getParentId(), rowValue.getRootId(), rowValue.getKeyValue(), rowValue.getRoot()));
                relations.addAll(this.accumulateRelations(rowValue.getRelations()));
            }
        }
        return relations;
    }

    private void setEntityRelations(Map<String, Object> rootEntity, RelationalPersistentEntity<?> persistentEntity, MultiValueMap<PersistentPropertyPathExtension, RelationValue> relationValues) {
        for (Map.Entry relations : relationValues.entrySet()) {
            PersistentPropertyPathExtension propertyPath = (PersistentPropertyPathExtension)relations.getKey();
            RelationalPersistentProperty property = (RelationalPersistentProperty)propertyPath.getRequiredPersistentPropertyPath().getLeafProperty();
            if (persistentEntity.getType() == property.getOwner().getType()) {
                rootEntity.put(property.getName(), this.determineRelationValue(property, (List)relations.getValue()));
                continue;
            }
            Map<Object, RelationValue> parentValues = ((List)relationValues.getOrDefault((Object)propertyPath.getParentPath(), new ArrayList())).stream().collect(Collectors.toMap(RelationValue::getValueId, it -> it));
            LinkedMultiValueMap parentKeyChildren = new LinkedMultiValueMap();
            for (RelationValue value : (List)relations.getValue()) {
                parentKeyChildren.add(value.getParentId(), (Object)value);
            }
            for (Map.Entry parentKeyChild : parentKeyChildren.entrySet()) {
                Map<String, Object> parentValue = parentValues.get(parentKeyChild.getKey()).getValue();
                List relationValue = (List)parentKeyChild.getValue();
                parentValue.put(property.getName(), this.determineRelationValue(property, relationValue));
            }
        }
    }

    private Object getRootId(ResultSetHolder resultSet, RelationalPersistentEntity<?> entity) throws SQLException {
        return resultSet.getResultSet().getObject(entity.getIdColumn().getReference(this.identifierProcessing));
    }

    private Identifier getRelationEntityIdentifier(PersistentPropertyPathExtension relationPath, RelationalPersistentEntity<?> entity, Map<String, Object> entityMap) {
        Object id = entityMap.get(((RelationalPersistentProperty)entity.getRequiredIdProperty()).getName());
        return Identifier.of((SqlIdentifier)relationPath.getReverseColumnName(), (Object)id, Object.class);
    }

    protected String getIdColumnAlias(PersistentPropertyPathExtension relationPath) {
        return PropertyPathUtils.getColumnAlias(relationPath.extendBy((RelationalPersistentProperty)relationPath.getLeafEntity().getRequiredIdProperty())).getReference(this.identifierProcessing);
    }

    protected String getQualifierColumnAlias(PersistentPropertyPathExtension relationPath) {
        return PropertyPathUtils.getTableAlias(relationPath).getReference(this.identifierProcessing) + "_" + relationPath.getQualifierColumn().getReference(this.identifierProcessing);
    }

    private Object determineRelationValue(RelationalPersistentProperty property, List<RelationValue> relationValue) {
        if (property.isMap()) {
            return relationValue.stream().distinct().collect(Collectors.toMap(RelationValue::getKeyValue, RelationValue::getValue));
        }
        List relationMapValues = relationValue.stream().map(RelationValue::getValue).distinct().collect(Collectors.toList());
        if (!property.isCollectionLike() && (property.isEntity() || property.isEmbedded())) {
            if (relationMapValues.size() > 1) {
                throw new MappingException(String.format("Could not mapping path %s from value %s. property is entity but multiple value.", property.getOwner().getType() + "#" + property.getName(), relationMapValues));
            }
            if (relationMapValues.isEmpty()) {
                return null;
            }
            return relationMapValues.get(0);
        }
        return relationMapValues;
    }

    private boolean isSimpleProperty(RelationalPersistentProperty property) {
        return !property.isCollectionLike() && !property.isEntity() && !property.isMap() && !property.isEmbedded();
    }

    static enum NoOpParameterValueProvider implements ParameterValueProvider<RelationalPersistentProperty>
    {
        INSTANCE;


        public <T> T getParameterValue(PreferredConstructor.Parameter<T, RelationalPersistentProperty> parameter) {
            return null;
        }
    }

    private class MapReadingContext<T> {
        private final RelationalPersistentEntity<T> entity;
        private final Map<String, Object> entityMap;
        private final PersistentPropertyPathExtension path;

        private MapReadingContext(@Nullable PersistentPropertyPathExtension rootPath, Map<String, Object> entityMap) {
            RelationalPersistentEntity entity = rootPath.getLeafEntity();
            Assert.notNull((Object)entity, (String)"The rootPath must point to an entity.");
            this.entity = entity;
            this.entityMap = entityMap;
            this.path = new PersistentPropertyPathExtension(AggregateResultJdbcConverter.this.getMappingContext(), this.entity);
        }

        private MapReadingContext(@Nullable RelationalPersistentEntity<T> entity, Map<String, Object> entityMap, PersistentPropertyPathExtension path) {
            this.entity = entity;
            this.entityMap = entityMap;
            this.path = path;
        }

        private <S> MapReadingContext<S> extendEntityBy(RelationalPersistentProperty property, @Nullable Map<String, Object> entityMap) {
            return new MapReadingContext<T>((RelationalPersistentEntity)AggregateResultJdbcConverter.this.getMappingContext().getRequiredPersistentEntity(property.getActualType()), entityMap, this.path.extendBy(property));
        }

        T mapRow() {
            RelationalPersistentProperty idProperty = (RelationalPersistentProperty)this.entity.getIdProperty();
            Object idValue = idProperty == null ? null : this.readFrom(idProperty);
            return this.createInstanceInternal(idValue);
        }

        private T populateProperties(T instance, @Nullable Object idValue) {
            PersistentPropertyAccessor propertyAccessor = AggregateResultJdbcConverter.this.getPropertyAccessor((PersistentEntity)this.entity, instance);
            PreferredConstructor persistenceConstructor = this.entity.getPersistenceConstructor();
            this.entity.doWithAll(property -> {
                if (persistenceConstructor != null && persistenceConstructor.isConstructorParameter(property)) {
                    return;
                }
                if (AggregateResultJdbcConverter.this.isSimpleProperty(property) && this.entityMap == null | !this.entityMap.containsKey(property.getName())) {
                    return;
                }
                Object value = this.readOrLoadProperty(idValue, (RelationalPersistentProperty)property);
                propertyAccessor.setProperty(property, value);
            });
            return (T)propertyAccessor.getBean();
        }

        @Nullable
        private Object readOrLoadProperty(@Nullable Object id, RelationalPersistentProperty property) {
            if (property.isMap()) {
                return this.readMapFrom(property);
            }
            if (property.isCollectionLike() && property.isEntity()) {
                return this.readCollectionFrom(property);
            }
            if (property.isEmbedded()) {
                return this.readEmbeddedEntityFrom(id, property);
            }
            return this.readFrom(property);
        }

        @Nullable
        private Object readFrom(RelationalPersistentProperty property) {
            if (property.isEntity()) {
                return this.readEntityFrom(property);
            }
            Object value = this.getObjectFromResultSet(property.getName());
            return value != null ? AggregateResultJdbcConverter.this.readValue(value, property.getTypeInformation()) : null;
        }

        @Nullable
        private Object readEmbeddedEntityFrom(@Nullable Object idValue, RelationalPersistentProperty property) {
            Object value = this.entityMap.get(property.getName());
            MapReadingContext newContext = this.extendEntityBy(property, (Map)value);
            if (this.shouldCreateEmptyEmbeddedInstance(property) || super.hasInstanceValues(idValue)) {
                return super.createInstanceInternal(idValue);
            }
            return null;
        }

        private boolean shouldCreateEmptyEmbeddedInstance(RelationalPersistentProperty property) {
            return property.shouldCreateEmptyEmbedded();
        }

        private boolean hasInstanceValues(@Nullable Object idValue) {
            RelationalPersistentEntity persistentEntity = this.path.getLeafEntity();
            Assert.state((persistentEntity != null ? 1 : 0) != 0, (String)"Entity must not be null");
            for (RelationalPersistentProperty embeddedProperty : persistentEntity) {
                if (embeddedProperty.isQualified() || embeddedProperty.isAssociation()) {
                    return true;
                }
                Object value = this.readOrLoadProperty(idValue, embeddedProperty);
                if (value == null) continue;
                return true;
            }
            return false;
        }

        @Nullable
        private Object readEntityFrom(RelationalPersistentProperty property) {
            if (this.entityMap == null) {
                return null;
            }
            Map value = (Map)this.entityMap.get(property.getName());
            return this.readEntityFrom(property, value);
        }

        @Nullable
        private Object readEntityFrom(RelationalPersistentProperty property, @Nullable Map<String, Object> value) {
            if (value == null) {
                return null;
            }
            MapReadingContext newContext = this.extendEntityBy(property, value);
            RelationalPersistentEntity entity = (RelationalPersistentEntity)AggregateResultJdbcConverter.this.getMappingContext().getRequiredPersistentEntity(property.getActualType());
            RelationalPersistentProperty idProperty = (RelationalPersistentProperty)entity.getIdProperty();
            Object idValue = idProperty != null ? super.readFrom(idProperty) : super.getObjectFromResultSet(property.getName());
            if (idValue == null) {
                return null;
            }
            return super.createInstanceInternal(idValue);
        }

        private Map<Object, Object> readMapFrom(RelationalPersistentProperty property) {
            if (this.entityMap == null) {
                return new HashMap<Object, Object>();
            }
            Map mapValues = (Map)this.entityMap.get(property.getName());
            if (mapValues == null) {
                return new HashMap<Object, Object>();
            }
            return mapValues.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry(entry.getKey(), this.readEntityFrom(property, (Map)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        private List<Object> readCollectionFrom(RelationalPersistentProperty property) {
            if (this.entityMap == null) {
                return new ArrayList<Object>();
            }
            Iterable collectionValues = (Iterable)this.entityMap.get(property.getName());
            if (collectionValues == null) {
                return new ArrayList<Object>();
            }
            return Streamable.of((Iterable)collectionValues).stream().map(value -> this.readEntityFrom(property, (Map<String, Object>)value)).collect(Collectors.toList());
        }

        @Nullable
        private Object getObjectFromResultSet(String propertyName) {
            if (this.entityMap == null) {
                return null;
            }
            return this.entityMap.get(propertyName);
        }

        private T createInstanceInternal(@Nullable Object idValue) {
            NoOpParameterValueProvider provider;
            PreferredConstructor persistenceConstructor = this.entity.getPersistenceConstructor();
            if (persistenceConstructor != null && persistenceConstructor.hasParameters()) {
                DefaultSpELExpressionEvaluator expressionEvaluator = new DefaultSpELExpressionEvaluator(this.entityMap, AggregateResultJdbcConverter.this.spElContext);
                provider = new SpELExpressionParameterValueProvider((SpELExpressionEvaluator)expressionEvaluator, AggregateResultJdbcConverter.this.getConversionService(), (ParameterValueProvider)new ResultSetParameterValueProvider(idValue, this.entity));
            } else {
                provider = NoOpParameterValueProvider.INSTANCE;
            }
            Object instance = AggregateResultJdbcConverter.this.createInstance((PersistentEntity)this.entity, arg_0 -> ((ParameterValueProvider)provider).getParameterValue(arg_0));
            return (T)(this.entity.requiresPropertyPopulation() ? this.populateProperties(instance, idValue) : instance);
        }

        private class ResultSetParameterValueProvider
        implements ParameterValueProvider<RelationalPersistentProperty> {
            @Nullable
            private final Object idValue;
            private final RelationalPersistentEntity<?> entity;

            public ResultSetParameterValueProvider(Object idValue, RelationalPersistentEntity<?> entity) {
                this.idValue = idValue;
                this.entity = entity;
            }

            @Nullable
            public <T> T getParameterValue(PreferredConstructor.Parameter<T, RelationalPersistentProperty> parameter) {
                String parameterName = parameter.getName();
                Assert.notNull((Object)parameterName, (String)"A constructor parameter name must not be null to be used with Spring Data JDBC");
                RelationalPersistentProperty property = (RelationalPersistentProperty)this.entity.getRequiredPersistentProperty(parameterName);
                return (T)MapReadingContext.this.readOrLoadProperty(this.idValue, property);
            }
        }
    }

    private class SingleTableMapReadingContext {
        private final RelationalPersistentEntity<?> entity;
        private final PersistentPropertyPathExtension rootPath;
        private final PersistentPropertyPathExtension path;
        private final Identifier identifier;
        private final Object key;
        private final JdbcPropertyValueProvider propertyValueProvider;
        private final JdbcBackReferencePropertyValueProvider backReferencePropertyValueProvider;
        private final ResultSetAccessor accessor;

        private SingleTableMapReadingContext(PersistentPropertyPathExtension rootPath, ResultSetAccessor accessor, Identifier identifier, Object key) {
            RelationalPersistentEntity entity = rootPath.getLeafEntity();
            Assert.notNull((Object)entity, (String)"The rootPath must point to an entity.");
            this.entity = entity;
            this.rootPath = rootPath;
            this.path = new PersistentPropertyPathExtension(AggregateResultJdbcConverter.this.getMappingContext(), this.entity);
            this.identifier = identifier;
            this.key = key;
            this.propertyValueProvider = new JdbcPropertyValueProvider(AggregateResultJdbcConverter.this.identifierProcessing, this.path, accessor);
            this.backReferencePropertyValueProvider = new JdbcBackReferencePropertyValueProvider(AggregateResultJdbcConverter.this.identifierProcessing, this.path, accessor);
            this.accessor = accessor;
        }

        private SingleTableMapReadingContext(RelationalPersistentEntity<?> entity, ResultSetAccessor accessor, PersistentPropertyPathExtension rootPath, PersistentPropertyPathExtension path, Identifier identifier, Object key) {
            this.entity = entity;
            this.rootPath = rootPath;
            this.path = path;
            this.identifier = identifier;
            this.key = key;
            this.propertyValueProvider = new JdbcPropertyValueProvider(AggregateResultJdbcConverter.this.identifierProcessing, path, accessor);
            this.backReferencePropertyValueProvider = new JdbcBackReferencePropertyValueProvider(AggregateResultJdbcConverter.this.identifierProcessing, path, accessor);
            this.accessor = accessor;
        }

        private SingleTableMapReadingContext(RelationalPersistentEntity<?> entity, PersistentPropertyPathExtension rootPath, PersistentPropertyPathExtension path, Identifier identifier, Object key, JdbcPropertyValueProvider propertyValueProvider, JdbcBackReferencePropertyValueProvider backReferencePropertyValueProvider, ResultSetAccessor accessor) {
            this.entity = entity;
            this.rootPath = rootPath;
            this.path = path;
            this.identifier = identifier;
            this.key = key;
            this.propertyValueProvider = propertyValueProvider;
            this.backReferencePropertyValueProvider = backReferencePropertyValueProvider;
            this.accessor = accessor;
        }

        private SingleTableMapReadingContext extendBy(RelationalPersistentProperty property) {
            return new SingleTableMapReadingContext((RelationalPersistentEntity)AggregateResultJdbcConverter.this.getMappingContext().getRequiredPersistentEntity(property.getActualType()), this.rootPath, this.path.extendBy(property), this.identifier, this.key, this.propertyValueProvider.extendBy(property), this.backReferencePropertyValueProvider.extendBy(property), this.accessor);
        }

        Map<String, Object> mapRow() {
            RelationalPersistentProperty idProperty = (RelationalPersistentProperty)this.entity.getIdProperty();
            Object idValue = idProperty == null ? null : this.readFrom(idProperty);
            return this.createInstanceInternal(idValue);
        }

        private void populateProperties(Map<String, Object> map, @Nullable Object idValue) {
            this.entity.doWithAll(property -> {
                if (AggregateResultJdbcConverter.this.isSimpleProperty(property) && !this.propertyValueProvider.hasProperty((RelationalPersistentProperty)property)) {
                    return;
                }
                Object value = this.readOrLoadProperty(idValue, (RelationalPersistentProperty)property);
                map.put(property.getName(), value);
            });
        }

        @Nullable
        private Object readOrLoadProperty(@Nullable Object id, RelationalPersistentProperty property) {
            if (property.isCollectionLike() && property.isEntity()) {
                return new ArrayList();
            }
            if (property.isMap()) {
                return new HashMap();
            }
            if (property.isEmbedded()) {
                return this.readEmbeddedEntityFrom(id, property);
            }
            return this.readFrom(property);
        }

        @Nullable
        private Object readFrom(RelationalPersistentProperty property) {
            if (property.isEntity()) {
                return this.readEntityFrom(property);
            }
            Object value = this.propertyValueProvider.getPropertyValue(property);
            return value != null ? AggregateResultJdbcConverter.this.readValue(value, property.getTypeInformation()) : null;
        }

        @Nullable
        private Object readEmbeddedEntityFrom(@Nullable Object idValue, RelationalPersistentProperty property) {
            SingleTableMapReadingContext newContext = this.extendBy(property);
            if (this.shouldCreateEmptyEmbeddedInstance(property) || newContext.hasInstanceValues(idValue)) {
                return newContext.createInstanceInternal(idValue);
            }
            return null;
        }

        private boolean shouldCreateEmptyEmbeddedInstance(RelationalPersistentProperty property) {
            return property.shouldCreateEmptyEmbedded();
        }

        private boolean hasInstanceValues(@Nullable Object idValue) {
            RelationalPersistentEntity persistentEntity = this.path.getLeafEntity();
            Assert.state((persistentEntity != null ? 1 : 0) != 0, (String)"Entity must not be null");
            for (RelationalPersistentProperty embeddedProperty : persistentEntity) {
                if (embeddedProperty.isQualified() || embeddedProperty.isAssociation()) {
                    return true;
                }
                Object value = this.readOrLoadProperty(idValue, embeddedProperty);
                if (value == null) continue;
                return true;
            }
            return false;
        }

        @Nullable
        private Object readEntityFrom(RelationalPersistentProperty property) {
            SingleTableMapReadingContext newContext = this.extendBy(property);
            RelationalPersistentEntity entity = (RelationalPersistentEntity)AggregateResultJdbcConverter.this.getMappingContext().getRequiredPersistentEntity(property.getActualType());
            RelationalPersistentProperty idProperty = (RelationalPersistentProperty)entity.getIdProperty();
            Object idValue = idProperty != null ? newContext.readFrom(idProperty) : this.backReferencePropertyValueProvider.getPropertyValue(property);
            if (idValue == null) {
                return null;
            }
            return newContext.createInstanceInternal(idValue);
        }

        private Map<String, Object> createInstanceInternal(@Nullable Object idValue) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            this.populateProperties(map, idValue);
            return map;
        }
    }

    private static class RelationValue {
        private final Object parentId;
        private final Object valueId;
        private final Object keyValue;
        private final Map<String, Object> value;

        public RelationValue(Object parentId, Object valueId, Object keyValue, Map<String, Object> value) {
            this.parentId = parentId;
            this.valueId = valueId;
            this.keyValue = keyValue;
            this.value = value;
        }

        public Object getParentId() {
            return this.parentId;
        }

        public Object getValueId() {
            return this.valueId;
        }

        public Object getKeyValue() {
            return this.keyValue;
        }

        public Map<String, Object> getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            RelationValue that = (RelationValue)obj;
            return Objects.equals(this.parentId, that.parentId) && Objects.equals(this.valueId, that.valueId) && Objects.equals(this.keyValue, that.keyValue) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.parentId, this.valueId, this.keyValue, this.value);
        }
    }

    private static class ExtractedRow {
        private final Object parentId;
        private final RelationalPersistentEntity<?> rootEntity;
        private final Map<String, Object> root;
        private final Object rootId;
        private final Object keyValue;
        private final MultiValueMap<PersistentPropertyPathExtension, ExtractedRow> relations;

        ExtractedRow(Object parentId, RelationalPersistentEntity<?> rootEntity, Map<String, Object> root, Object rootId, Object keyValue, MultiValueMap<PersistentPropertyPathExtension, ExtractedRow> relations) {
            this.parentId = parentId;
            this.rootEntity = rootEntity;
            this.root = root;
            this.rootId = rootId;
            this.keyValue = keyValue;
            this.relations = relations;
        }

        public Object getParentId() {
            return this.parentId;
        }

        public RelationalPersistentEntity<?> getRootEntity() {
            return this.rootEntity;
        }

        public Map<String, Object> getRoot() {
            return this.root;
        }

        public Object getRootId() {
            return this.rootId;
        }

        public MultiValueMap<PersistentPropertyPathExtension, ExtractedRow> getRelations() {
            return this.relations;
        }

        public Object getKeyValue() {
            return this.keyValue;
        }
    }

    private static class EntityPathRelations {
        private final PersistentPropertyPathExtension rootPath;
        private final Map<PersistentPropertyPathExtension, EntityPathRelations> relations;

        EntityPathRelations(PersistentPropertyPathExtension rootPath, Map<PersistentPropertyPathExtension, EntityPathRelations> relations) {
            this.rootPath = rootPath;
            this.relations = relations;
        }

        public PersistentPropertyPathExtension getRootPath() {
            return this.rootPath;
        }

        public Map<PersistentPropertyPathExtension, EntityPathRelations> getRelations() {
            return this.relations;
        }
    }

    private static class ResultSetHolder {
        private ResultSet resultSet;
        private int currentRowNum;
        private boolean done;

        public ResultSetHolder(ResultSet resultSet) {
            this.resultSet = resultSet;
            this.currentRowNum = -1;
            this.done = false;
        }

        public boolean next() throws SQLException {
            boolean next = this.resultSet.next();
            ++this.currentRowNum;
            if (!next) {
                this.done = true;
            }
            return next;
        }

        public boolean isDone() {
            return this.done;
        }

        public ResultSet getResultSet() {
            return this.resultSet;
        }

        public int getCurrentRowNum() {
            return this.currentRowNum;
        }
    }

    protected static interface MapParameterValueProvider<P extends PersistentProperty<P>> {
        @Nullable
        public Object getParameterValue(PreferredConstructor.Parameter<?, P> var1);
    }
}

