/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.spring.data.jdbc.plus.sql.convert;

import com.navercorp.spring.data.jdbc.plus.sql.convert.AggregateResultJdbcConverter;
import java.sql.ResultSet;
import java.util.List;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.jdbc.core.ResultSetExtractor;

public class AggregateResultSetExtractor<T>
implements ResultSetExtractor<List<T>> {
    private final RelationalPersistentEntity<T> entity;
    private final AggregateResultJdbcConverter jdbcConverter;

    public AggregateResultSetExtractor(Class<T> type, AggregateResultJdbcConverter jdbcConverter) {
        this.entity = (RelationalPersistentEntity)jdbcConverter.getMappingContext().getRequiredPersistentEntity(type);
        this.jdbcConverter = jdbcConverter;
    }

    public AggregateResultSetExtractor(RelationalPersistentEntity<T> entity, AggregateResultJdbcConverter jdbcConverter) {
        this.entity = entity;
        this.jdbcConverter = jdbcConverter;
    }

    public List<T> extractData(ResultSet resultSet) {
        return this.jdbcConverter.mapAggregate(this.entity, resultSet);
    }
}

