/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.spring.data.jdbc.plus.sql.convert;

import com.navercorp.spring.data.jdbc.plus.sql.convert.PropertyPathUtils;
import com.navercorp.spring.data.jdbc.plus.sql.convert.ResultSetAccessor;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.relational.core.mapping.PersistentPropertyPathExtension;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.IdentifierProcessing;

class JdbcBackReferencePropertyValueProvider
implements PropertyValueProvider<RelationalPersistentProperty> {
    private final IdentifierProcessing identifierProcessing;
    private final PersistentPropertyPathExtension basePath;
    private final ResultSetAccessor resultSet;

    JdbcBackReferencePropertyValueProvider(IdentifierProcessing identifierProcessing, PersistentPropertyPathExtension basePath, ResultSetAccessor resultSet) {
        this.resultSet = resultSet;
        this.basePath = basePath;
        this.identifierProcessing = identifierProcessing;
    }

    public <T> T getPropertyValue(RelationalPersistentProperty property) {
        PersistentPropertyPathExtension path = this.basePath.extendBy(property);
        return (T)this.resultSet.getObject(PropertyPathUtils.getReverseColumnAlias(path).getReference(this.identifierProcessing));
    }

    public JdbcBackReferencePropertyValueProvider extendBy(RelationalPersistentProperty property) {
        return new JdbcBackReferencePropertyValueProvider(this.identifierProcessing, this.basePath.extendBy(property), this.resultSet);
    }
}

