/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.spring.data.jdbc.plus.sql.convert;

import com.navercorp.spring.data.jdbc.plus.sql.convert.TableAliasUtils;
import javax.annotation.Nullable;
import org.springframework.data.relational.core.mapping.PersistentPropertyPathExtension;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.util.Assert;

public class PropertyPathUtils {
    static SqlIdentifier getColumnAlias(PersistentPropertyPathExtension path) {
        return PropertyPathUtils.getColumnAlias(path, path.getColumnName());
    }

    static SqlIdentifier getColumnAlias(PersistentPropertyPathExtension path, SqlIdentifier columnName) {
        PersistentPropertyPathExtension tableOwner = PropertyPathUtils.getTableOwningAncestor(path);
        if (tableOwner.getLength() == 0) {
            return columnName;
        }
        SqlIdentifier tableAlias = PropertyPathUtils.getTableAliasFromTableOwner(tableOwner);
        return tableAlias == null ? columnName : columnName.transform(name -> tableAlias.getReference(IdentifierProcessing.NONE) + "_" + name);
    }

    static SqlIdentifier getReverseColumnAlias(PersistentPropertyPathExtension path) {
        return PropertyPathUtils.getReverseColumnAlias(path, path.getReverseColumnName());
    }

    static SqlIdentifier getReverseColumnAlias(PersistentPropertyPathExtension path, SqlIdentifier reverseColumnName) {
        SqlIdentifier tableAlias = PropertyPathUtils.getTableAlias(path);
        return tableAlias == null ? reverseColumnName : reverseColumnName.transform(name -> tableAlias.getReference(IdentifierProcessing.NONE) + "_" + name);
    }

    @Nullable
    static SqlIdentifier getTableAlias(PersistentPropertyPathExtension path) {
        PersistentPropertyPathExtension tableOwner = PropertyPathUtils.getTableOwningAncestor(path);
        return PropertyPathUtils.getTableAliasFromTableOwner(tableOwner);
    }

    @Nullable
    private static SqlIdentifier getTableAliasFromTableOwner(PersistentPropertyPathExtension tableOwner) {
        if (tableOwner.getLength() > 0) {
            return PropertyPathUtils.assembleTableAlias(tableOwner);
        }
        return TableAliasUtils.getTableAlias(tableOwner.getLeafEntity());
    }

    private static PersistentPropertyPathExtension getTableOwningAncestor(PersistentPropertyPathExtension path) {
        return path.isEntity() && !path.isEmbedded() ? path : PropertyPathUtils.getTableOwningAncestor(path.getParentPath());
    }

    private static SqlIdentifier assembleTableAlias(PersistentPropertyPathExtension path) {
        Assert.state((path != null ? 1 : 0) != 0, (String)"Path is null");
        String prefix = TableAliasUtils.getTableAliasPropertyPathPrefix(path);
        if (path.getLength() == 1) {
            Assert.notNull((Object)prefix, (String)"Prefix must not be null.");
            return SqlIdentifier.quoted((String)prefix);
        }
        PersistentPropertyPathExtension parentPath = path.getParentPath();
        SqlIdentifier sqlIdentifier = PropertyPathUtils.assembleTableAlias(parentPath);
        return parentPath.isEmbedded() ? sqlIdentifier.transform(name -> name.concat(prefix)) : sqlIdentifier.transform(name -> name + "_" + prefix);
    }
}

