/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.spring.data.jdbc.plus.sql.convert;

import com.navercorp.spring.data.jdbc.plus.sql.convert.PropertyPathUtils;
import com.navercorp.spring.data.jdbc.plus.sql.convert.SqlContexts;
import com.navercorp.spring.data.jdbc.plus.sql.convert.TableAliasUtils;
import org.springframework.data.relational.core.mapping.PersistentPropertyPathExtension;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.Table;

class SqlContext
implements SqlContexts {
    private final RelationalPersistentEntity<?> entity;
    private final Table table;

    SqlContext(RelationalPersistentEntity<?> entity) {
        this.entity = entity;
        this.table = SqlContext.getEntityTable(entity);
    }

    private static Table getEntityTable(RelationalPersistentEntity<?> entity) {
        Table table = Table.create((SqlIdentifier)entity.getTableName());
        SqlIdentifier tableAlias = TableAliasUtils.getTableAlias(entity);
        if (tableAlias != null) {
            table = table.as(tableAlias);
        }
        return table;
    }

    @Override
    public Column getIdColumn() {
        return this.table.column(this.entity.getIdColumn());
    }

    @Override
    public Column getVersionColumn() {
        return this.table.column(((RelationalPersistentProperty)this.entity.getRequiredVersionProperty()).getColumnName());
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public Table getTable(PersistentPropertyPathExtension path) {
        SqlIdentifier tableAlias = PropertyPathUtils.getTableAlias(path);
        Table table = Table.create((SqlIdentifier)path.getTableName());
        return tableAlias == null ? table : table.as(tableAlias);
    }

    @Override
    public Column getColumn(PersistentPropertyPathExtension path) {
        SqlIdentifier columnName = path.getColumnName();
        SqlIdentifier columnAlias = PropertyPathUtils.getColumnAlias(path, columnName);
        return this.getTable(path).column(columnName).as(columnAlias);
    }

    @Override
    public Column getReverseColumn(PersistentPropertyPathExtension path) {
        SqlIdentifier reverseColumnName = path.getReverseColumnName();
        SqlIdentifier reverseColumnAlias = PropertyPathUtils.getReverseColumnAlias(path, reverseColumnName);
        return this.getTable(path).column(reverseColumnName).as(reverseColumnAlias);
    }
}

