/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.spring.data.jdbc.plus.sql.convert;

import com.navercorp.spring.data.jdbc.plus.sql.convert.SqlContexts;
import com.navercorp.spring.data.jdbc.plus.sql.convert.SqlGenerator;
import java.util.Map;
import java.util.function.Function;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.util.ConcurrentReferenceHashMap;

public class SqlGeneratorSource {
    private final Map<Class<?>, SqlGenerator> cache = new ConcurrentReferenceHashMap();
    private final RelationalMappingContext context;
    private final JdbcConverter converter;
    private final Dialect dialect;
    Function<RelationalPersistentEntity<?>, SqlContexts> sqlContextsGenerator;

    public SqlGeneratorSource(RelationalMappingContext context, JdbcConverter converter, Dialect dialect) {
        this.context = context;
        this.converter = converter;
        this.dialect = dialect;
        this.sqlContextsGenerator = null;
    }

    SqlGenerator getSqlGenerator(Class<?> domainType) {
        return this.cache.computeIfAbsent(domainType, t -> {
            RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(domainType);
            if (this.sqlContextsGenerator != null) {
                return new SqlGenerator(this.context, this.converter, persistentEntity, this.dialect, this.sqlContextsGenerator.apply(persistentEntity));
            }
            return new SqlGenerator(this.context, this.converter, persistentEntity, this.dialect);
        });
    }

    public Dialect getDialect() {
        return this.dialect;
    }
}

