/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.spring.data.jdbc.plus.sql.convert;

import com.navercorp.spring.data.jdbc.plus.sql.annotation.SqlTableAlias;
import javax.annotation.Nullable;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.mapping.PersistentPropertyPathExtension;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.SqlIdentifier;

class TableAliasUtils {
    TableAliasUtils() {
    }

    @Nullable
    static SqlIdentifier getTableAlias(RelationalPersistentEntity<?> entity) {
        SqlTableAlias sqlTableAlias = (SqlTableAlias)entity.findAnnotation(SqlTableAlias.class);
        if (sqlTableAlias != null) {
            return SqlIdentifier.quoted((String)sqlTableAlias.value());
        }
        return null;
    }

    @Nullable
    static String getTableAliasPropertyPathPrefix(PersistentPropertyPathExtension path) {
        SqlTableAlias sqlTableAlias;
        PersistentPropertyPath propertyPath = path.getRequiredPersistentPropertyPath();
        RelationalPersistentProperty leafProperty = (RelationalPersistentProperty)propertyPath.getRequiredLeafProperty();
        String prefix = path.isEmbedded() ? leafProperty.getEmbeddedPrefix() : ((sqlTableAlias = (SqlTableAlias)leafProperty.findAnnotation(SqlTableAlias.class)) != null ? sqlTableAlias.value() : leafProperty.getName());
        return prefix;
    }
}

