/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.spring.data.jdbc.plus.sql.provider;

import com.navercorp.spring.data.jdbc.plus.sql.convert.AggregateResultSetExtractor;
import com.navercorp.spring.data.jdbc.plus.sql.convert.SqlProvider;
import com.navercorp.spring.data.jdbc.plus.sql.parametersource.EntityConvertibleSqlParameterSourceFactory;
import com.navercorp.spring.data.jdbc.plus.sql.parametersource.SqlParameterSourceFactory;
import com.navercorp.spring.data.jdbc.plus.sql.provider.EntityQueryMappingConfiguration;
import com.navercorp.spring.data.jdbc.plus.sql.provider.IllegalReturnTypeException;
import com.navercorp.spring.jdbc.plus.support.parametersource.CompositeSqlParameterSource;
import java.util.Map;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.jdbc.repository.QueryMappingConfiguration;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class EntityJdbcProvider {
    private final NamedParameterJdbcOperations jdbcOperations;
    private final SqlProvider sqlProvider;
    private final SqlParameterSourceFactory sqlParameterSourceFactory;
    private final QueryMappingConfiguration queryMappingConfiguration;
    private final ApplicationEventPublisher publisher;
    private final EntityCallbacks entityCallbacks;

    public EntityJdbcProvider(NamedParameterJdbcOperations jdbcOperations, SqlProvider sqlProvider, SqlParameterSourceFactory sqlParameterSourceFactory, QueryMappingConfiguration queryMappingConfiguration, ApplicationEventPublisher publisher, EntityCallbacks entityCallbacks) {
        this.jdbcOperations = jdbcOperations;
        this.sqlProvider = sqlProvider;
        this.sqlParameterSourceFactory = sqlParameterSourceFactory;
        this.queryMappingConfiguration = queryMappingConfiguration;
        this.publisher = publisher;
        this.entityCallbacks = entityCallbacks;
    }

    public NamedParameterJdbcOperations getJdbcOperations() {
        return this.jdbcOperations;
    }

    public SqlProvider getSqlProvider() {
        return this.sqlProvider;
    }

    public SqlParameterSourceFactory getSqlParameterSourceFactory() {
        return this.sqlParameterSourceFactory;
    }

    public QueryMappingConfiguration getQueryMappingConfiguration() {
        return this.queryMappingConfiguration;
    }

    public <T> RowMapper<T> getRowMapper(Class<T> entityType) {
        try {
            return this.queryMappingConfiguration.getRowMapper(entityType);
        }
        catch (MappingException e) {
            throw new IllegalReturnTypeException("EntityRowMapper returnType must be entity type. returnType: " + entityType, (Exception)((Object)e));
        }
    }

    public <T> AggregateResultSetExtractor<T> getAggregateResultSetExtractor(Class<T> entityType) {
        if (!EntityQueryMappingConfiguration.class.isAssignableFrom(this.queryMappingConfiguration.getClass())) {
            throw new IllegalStateException("AggregateResultSetExtractor supports with EntityQueryMappingConfiguration. queryMappingConfiguration: " + this.queryMappingConfiguration.getClass());
        }
        return ((EntityQueryMappingConfiguration)this.queryMappingConfiguration).getAggregateResultSetExtractor(entityType);
    }

    public String columns(Class<?> entityType) {
        return this.sqlProvider.columns(entityType);
    }

    public String aggregateColumns(Class<?> entityType) {
        return this.sqlProvider.aggregateColumns(entityType);
    }

    public String tables(Class<?> entityType) {
        return this.sqlProvider.tables(entityType);
    }

    public String aggregateTables(Class<?> entityType) {
        return this.sqlProvider.aggregateTables(entityType);
    }

    public BeanPropertySqlParameterSource beanParameterSource(Object bean) {
        return this.sqlParameterSourceFactory.beanParameterSource(bean);
    }

    public BeanPropertySqlParameterSource beanParameterSource(String prefix, Object bean) {
        if (this.sqlParameterSourceFactory instanceof EntityConvertibleSqlParameterSourceFactory) {
            return ((EntityConvertibleSqlParameterSourceFactory)this.sqlParameterSourceFactory).beanParameterSource(prefix, bean);
        }
        throw new UnsupportedOperationException("Prefix saving is not supported as default.");
    }

    public MapSqlParameterSource mapParameterSource(Map<String, ?> map) {
        return this.sqlParameterSourceFactory.mapParameterSource(map);
    }

    public SqlParameterSource entityParameterSource(Object entity) {
        return this.sqlParameterSourceFactory.entityParameterSource(entity);
    }

    public CompositeSqlParameterSource compositeSqlParameterSource(SqlParameterSource ... sqlParameterSources) {
        return new CompositeSqlParameterSource(sqlParameterSources);
    }

    public ApplicationEventPublisher getApplicationEventPublisher() {
        return this.publisher;
    }

    public EntityCallbacks getEntityCallbacks() {
        return this.entityCallbacks;
    }
}

