/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.spring.data.jdbc.plus.sql.support;

import com.navercorp.spring.data.jdbc.plus.sql.provider.EntityJdbcProvider;
import com.navercorp.spring.data.jdbc.plus.sql.support.JdbcDaoSupport;
import com.navercorp.spring.data.jdbc.plus.sql.support.template.JdbcReactiveTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;

public abstract class JdbcReactiveDaoSupport
extends JdbcDaoSupport {
    private final JdbcReactiveTemplate jdbcReactiveTemplate;

    protected JdbcReactiveDaoSupport(EntityJdbcProvider entityJdbcProvider, JdbcReactiveTemplate jdbcReactiveTemplate) {
        super(entityJdbcProvider);
        this.jdbcReactiveTemplate = jdbcReactiveTemplate;
    }

    protected JdbcReactiveTemplate getJdbcReactiveTemplate() {
        return this.jdbcReactiveTemplate;
    }

    protected <R> Flux<R> selectFlux(String sql, SqlParameterSource params, Class<R> returnType) {
        RowMapper<R> rowMapper = this.getRowMapper(returnType);
        return this.jdbcReactiveTemplate.queryFlux(sql, this.getEntityJdbcProvider().getJdbcOperations(), params, rowMapper);
    }

    protected <R> Flux<R> selectFlux(String sql, SqlParameterSource params, RowMapper<R> rowMapper) {
        return this.jdbcReactiveTemplate.queryFlux(sql, this.getEntityJdbcProvider().getJdbcOperations(), params, rowMapper);
    }

    protected <R> Flux<R> selectFlux(String sql, NamedParameterJdbcOperations jdbcOperations, SqlParameterSource params, RowMapper<R> rowMapper) {
        return this.jdbcReactiveTemplate.queryFlux(sql, jdbcOperations, params, rowMapper);
    }

    protected <R> Flux<R> selectFlux(String sql, NamedParameterJdbcOperations jdbcOperations, SqlParameterSource params, RowMapper<R> rowMapper, Scheduler scheduler) {
        return this.jdbcReactiveTemplate.queryFlux(sql, jdbcOperations, params, rowMapper, scheduler);
    }

    protected <R> Flux<R> selectFlux(String sql, NamedParameterJdbcOperations jdbcOperations, SqlParameterSource params, RowMapper<R> rowMapper, int queueSize, long bufferTimeout) {
        return this.jdbcReactiveTemplate.queryFlux(sql, jdbcOperations, params, rowMapper, queueSize, bufferTimeout);
    }

    protected <R> Flux<R> selectFlux(String sql, NamedParameterJdbcOperations jdbcOperations, SqlParameterSource params, RowMapper<R> rowMapper, Scheduler scheduler, int queueSize, long bufferTimeout) {
        return this.jdbcReactiveTemplate.queryFlux(sql, jdbcOperations, params, rowMapper, scheduler, queueSize, bufferTimeout);
    }
}

