/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.svngit;

import com.navercorp.svngit.GitFSRevisionNode;
import com.navercorp.svngit.GitFSRevisionRoot;
import com.navercorp.svngit.SVNGitUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.io.NullOutputStream;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.io.fs.FSEntry;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSID;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.io.fs.FSRepresentation;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionInfo;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.server.dav.DAVPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class GitFS
extends FSFS {
    private Repository myGitRepository;
    private static Map<String, FSTransactionInfo> transactions = new HashMap<String, FSTransactionInfo>();
    private static Map<ObjectId, Map<String, ObjectId>> lastModifiedCommits = new HashMap<ObjectId, Map<String, ObjectId>>();

    public GitFS(File repositoryRoot) {
        super(repositoryRoot);
    }

    public static String findRepositoryRoot(String host, String path) {
        if (path == null) {
            path = "";
        }
        String testPath = host != null ? SVNPathUtil.append((String)("\\\\" + host), (String)path) : path;
        testPath = testPath.replaceFirst("\\|", "\\:");
        File rootPath = new File(testPath).getAbsoluteFile();
        while (!GitFS.isRepositoryRoot(rootPath)) {
            if (rootPath.getParentFile() == null) {
                return null;
            }
            path = SVNPathUtil.removeTail((String)path);
            rootPath = rootPath.getParentFile();
        }
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        while (path.endsWith("\\")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private static boolean isRepositoryRoot(File rootPath) {
        return true;
    }

    public long getYoungestRevision() throws SVNException {
        try {
            Ref latest;
            String prefix = "refs/svn/";
            try {
                this.updateSvnRefs();
                latest = this.myGitRepository.getRef(prefix + "latest");
            }
            catch (GitAPIException e) {
                throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.FS_GENERAL, (String)"Failed to get youngest revision"), (Throwable)e);
            }
            if (latest == null) {
                throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.FS_GENERAL, (String)"Failed to get youngest revision"));
            }
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "repo " + this.myGitRepository.getDirectory().getAbsolutePath());
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "ref " + latest);
            Ref target = latest.getTarget();
            long youngestRevision = Long.valueOf(target.getName().replaceFirst(prefix, ""));
            this.setYoungestRevisionCache(youngestRevision);
            return youngestRevision;
        }
        catch (IOException e) {
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.FS_GENERAL, (String)"Failed to get youngest revision"), (Throwable)e);
        }
    }

    private void checkRefUpdateResult(RefUpdate.Result rc) throws SVNException {
        switch (rc) {
            case REJECTED: 
            case NOT_ATTEMPTED: 
            case IO_FAILURE: 
            case LOCK_FAILURE: 
            case REJECTED_CURRENT_BRANCH: {
                throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.FS_GENERAL, (String)("Failed to update refs for SVN revisions: " + rc)));
            }
        }
    }

    public void updateSvnRefs() throws GitAPIException, IOException, SVNException {
        Git git = new Git(this.myGitRepository);
        Ref latest = this.myGitRepository.getRef("refs/svn/latest");
        if (latest != null && latest.getObjectId().equals((AnyObjectId)this.myGitRepository.getRef("HEAD").getObjectId())) {
            return;
        }
        LinkedList<RevCommit> commits = new LinkedList<RevCommit>();
        for (RevCommit commit : git.log().call()) {
            commits.addFirst(commit);
        }
        for (int rev = commits.size(); rev > 0; --rev) {
            RefUpdate refUpdate = this.myGitRepository.updateRef("refs/svn/" + rev);
            refUpdate.setNewObjectId((AnyObjectId)((RevCommit)commits.get(rev - 1)).getId());
            refUpdate.setForceUpdate(true);
            RefUpdate.Result rc = refUpdate.update();
            this.checkRefUpdateResult(rc);
            if (rc == RefUpdate.Result.NO_CHANGE) break;
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "Update ref: " + refUpdate.getRef());
            refUpdate = this.myGitRepository.updateRef("refs/svn/id/" + ((RevCommit)commits.get(rev - 1)).getId().getName());
            this.checkRefUpdateResult(refUpdate.link("refs/svn/" + rev));
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "Update ref: " + refUpdate.getRef());
        }
        RefUpdate refUpdate = this.myGitRepository.updateRef("refs/svn/latest");
        this.checkRefUpdateResult(refUpdate.link("refs/svn/" + commits.size()));
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "Update ref: " + refUpdate.getRef());
    }

    public void open() throws SVNException {
        try {
            this.myGitRepository = ((RepositoryBuilder)new RepositoryBuilder().setGitDir(this.getRepositoryRoot())).build();
        }
        catch (IOException e) {
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.FS_GENERAL, (String)"Failed to open a repository"), (Throwable)e);
        }
    }

    public void close() {
        this.myGitRepository.close();
    }

    public FSRevisionRoot createRevisionRoot(long revision) throws SVNException {
        this.ensureRevisionsExists(revision);
        return new GitFSRevisionRoot(this, revision);
    }

    private void ensureRevisionsExists(long revision) throws SVNException {
        SVNErrorMessage err;
        if (FSRepository.isInvalidRevision((long)revision)) {
            err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.FS_NO_SUCH_REVISION, (String)"Invalid revision number ''{0}''", (Object)new Long(revision));
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.FSFS);
        }
        if (revision <= this.getYoungestRevision()) {
            return;
        }
        err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.FS_NO_SUCH_REVISION, (String)"No such revision {0}", (Object)String.valueOf(revision));
        SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.FSFS);
    }

    public Repository getGitRepository() {
        return this.myGitRepository;
    }

    public Map getDirContents(FSRevisionNode revNode) throws SVNException {
        String path = DAVPathUtil.dropLeadingSlash((String)revNode.getCreatedPath());
        SVNHashMap map = new SVNHashMap();
        try {
            TreeWalk treeWalk;
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "getDirContents - path: " + path);
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "getDirContents - rev: " + revNode.getCreatedRevision());
            ObjectId commitId = SVNGitUtil.getCommitIdFromRevision(this.myGitRepository, revNode.getCreatedRevision());
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "getDirContents - commitId: " + commitId);
            RevTree rootTree = new RevWalk(this.myGitRepository).parseTree((AnyObjectId)commitId);
            if (path == null || path.isEmpty()) {
                treeWalk = new TreeWalk(this.myGitRepository);
                treeWalk.addTree((AnyObjectId)rootTree);
            } else {
                treeWalk = TreeWalk.forPath((Repository)this.myGitRepository, (String)path, (RevTree)rootTree);
                treeWalk.enterSubtree();
            }
            while (treeWalk.next()) {
                String name = treeWalk.getNameString();
                FSEntry entry = new FSEntry();
                entry.setName(name);
                entry.setType(treeWalk.isSubtree() ? SVNNodeKind.DIR : SVNNodeKind.FILE);
                FSID id = FSID.createRevId((String)treeWalk.getObjectId(0).getName(), null, (long)revNode.getCreatedRevision(), (long)-1L);
                entry.setId(id);
                map.put((Object)name, (Object)entry);
            }
        }
        catch (IOException e) {
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.FS_GENERAL, (String)"Failed to get dir contents"), (Throwable)e);
        }
        return map;
    }

    public SVNProperties getRevisionProperties(long revision) throws SVNException {
        SVNProperties properties = new SVNProperties();
        try {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "getRevisionProperties - revision: " + revision);
            if (revision == 0L) {
                properties.put("svn:date", SVNDate.formatDate((Date)new Date(0L)));
            } else {
                RevCommit commit = SVNGitUtil.getCommitFromRevision(this.myGitRepository, revision);
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "getRevisionProperties - commit: " + commit);
                properties.put("svn:log", commit.getFullMessage());
                properties.put("svn:author", commit.getAuthorIdent().getName());
                properties.put("svn:date", SVNDate.formatDate((Date)commit.getAuthorIdent().getWhen()));
            }
        }
        catch (IOException e) {
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.FS_GENERAL, (String)"Failed to get properties from a commit"), (Throwable)e);
        }
        return properties;
    }

    public String getUUID() throws SVNException {
        return "fake-uuid";
    }

    public FSRevisionNode getRevisionNode(FSID id) throws SVNException {
        GitFSRevisionNode node = new GitFSRevisionNode(this);
        node.setId(id);
        FSRepresentation rep = new FSRepresentation();
        rep.setRevision(id.getRevision());
        node.setTextRepresentation(rep);
        try {
            ObjectId objectId = this.myGitRepository.resolve(id.getNodeID());
            ObjectLoader objectLoader = this.myGitRepository.getObjectDatabase().open((AnyObjectId)objectId);
            switch (objectLoader.getType()) {
                case 3: {
                    node.setType(SVNNodeKind.FILE);
                    break;
                }
                case 2: {
                    node.setType(SVNNodeKind.DIR);
                    break;
                }
                default: {
                    throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.FS_GENERAL, (String)"Unexpected type"));
                }
            }
        }
        catch (IOException e) {
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.FS_GENERAL, (String)"Failed to get properties from a commit"), (Throwable)e);
        }
        return node;
    }

    private void fillLastModifiedCommits(ObjectId start, String basePath) throws IOException, GitAPIException {
        Map<String, ObjectId> objects = lastModifiedCommits.get(start);
        if (objects == null) {
            objects = new TreeMap<String, ObjectId>();
        }
        DiffFormatter diffFmt = new DiffFormatter((OutputStream)NullOutputStream.INSTANCE);
        diffFmt.setRepository(this.getGitRepository());
        LogCommand log = new Git(this.getGitRepository()).log();
        if (!basePath.isEmpty()) {
            log.addPath(basePath);
        }
        for (RevCommit c : log.call()) {
            RevTree a = c.getParentCount() > 0 ? c.getParent(0).getTree() : null;
            RevTree b = c.getTree();
            for (DiffEntry diff : diffFmt.scan(a, b)) {
                objects.put(diff.getNewPath(), c.getId());
            }
        }
        lastModifiedCommits.put(start, objects);
    }

    private ObjectId getCachedLastModifiedCommit(String path, ObjectId start) throws IOException {
        Map<String, ObjectId> commits = lastModifiedCommits.get(start);
        if (commits == null) {
            return null;
        }
        return commits.get(path);
    }

    private void setCachedLastModifiedCommit(String path, ObjectId lastModified, ObjectId start) throws IOException {
        Map<String, ObjectId> commits = lastModifiedCommits.get(start);
        if (commits == null) {
            commits = new HashMap<String, ObjectId>();
            lastModifiedCommits.put(start, commits);
        }
        commits.put(path, lastModified);
    }

    public long getCreatedRevision(String path, long revision) {
        if ((path = DAVPathUtil.dropLeadingSlash((String)path)).isEmpty()) {
            return revision;
        }
        try {
            ObjectId start = SVNGitUtil.getCommitIdFromRevision(this.myGitRepository, revision);
            ObjectId lastModified = this.getCachedLastModifiedCommit(path, start);
            int sep = path.lastIndexOf(47);
            if (sep < 0) {
                sep = 0;
            }
            if (lastModified == null) {
                this.fillLastModifiedCommits(start, path.substring(0, sep));
                lastModified = this.getCachedLastModifiedCommit(path, start);
            }
            if (lastModified == null) {
                LogCommand logCommand = new Git(this.myGitRepository).log().add((AnyObjectId)start);
                if (path != null && !path.isEmpty()) {
                    logCommand.addPath(path);
                }
                Iterable log = logCommand.call();
                RevCommit commit = (RevCommit)log.iterator().next();
                lastModified = commit.getId();
                this.setCachedLastModifiedCommit(path, lastModified, start);
            }
            return SVNGitUtil.getRevisionFromCommitId(this.myGitRepository, lastModified);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get the created revision", e);
        }
    }

    public FSTransactionInfo openTxn(String txnName) throws SVNException {
        return transactions.get(this.getUUID() + ":" + txnName);
    }

    public void storeActivity(FSTransactionInfo txnInfo) throws SVNException {
        transactions.put(this.getUUID() + ":" + txnInfo.getTxnId(), txnInfo);
    }

    public FSTransactionRoot createTransactionRoot(FSTransactionInfo txn) throws SVNException {
        SVNProperties txnProps = this.getTransactionProperties(txn.getTxnId());
        int flags = 0;
        if (txnProps.getStringValue("svn:check-ood") != null) {
            flags |= 1;
        }
        if (txnProps.getStringValue("svn:check-locks") != null) {
            flags |= 2;
        }
        return new FSTransactionRoot(this, txn.getTxnId(), txn.getBaseRevision(), flags){

            public FSTransactionInfo getTxn() throws SVNException {
                return (FSTransactionInfo)transactions.get(GitFS.this.getUUID() + ":" + this.getTxnID());
            }
        };
    }
}

