/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.svngit;

import com.navercorp.svngit.GitFS;
import java.io.IOException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class GitFSRevisionNode
extends FSRevisionNode {
    private final GitFS myGitFS;
    private long myCreatedRevision = -1L;

    public GitFSRevisionNode(GitFS gitFS) {
        this.myGitFS = gitFS;
    }

    public long getCreatedRevision() {
        if (this.myCreatedRevision == -1L) {
            this.myCreatedRevision = this.myGitFS.getCreatedRevision(this.getCreatedPath(), this.getTextRepresentation().getRevision());
        }
        return this.myCreatedRevision;
    }

    public String getFileSHA1Checksum() throws SVNException {
        String path = this.getCreatedPath();
        long revision = this.getTextRepresentation().getRevision();
        Repository gitRepository = this.myGitFS.getGitRepository();
        try {
            RevTree tree = new RevWalk(gitRepository).parseTree((AnyObjectId)gitRepository.resolve("refs/svn/" + revision));
            TreeWalk treeWalk = TreeWalk.forPath((Repository)gitRepository, (String)path, (RevTree)tree);
            if (treeWalk.isSubtree()) {
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.FS_NOT_FILE, (String)"Attempted to get checksum of a *non*-file node");
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.FSFS);
            }
            return treeWalk.getObjectId(0).getName();
        }
        catch (IOException e) {
            SVNDebugLog.getDefaultLog().logError(SVNLogType.DEFAULT, e.getMessage());
            return "";
        }
    }
}

