/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.svngit;

import com.navercorp.svngit.GitFS;
import com.navercorp.svngit.GitFSRevisionNode;
import com.navercorp.svngit.SVNGitUtil;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaCombiner;
import org.tmatesoft.svn.core.internal.io.fs.FSCopyInheritance;
import org.tmatesoft.svn.core.internal.io.fs.FSErrors;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSID;
import org.tmatesoft.svn.core.internal.io.fs.FSParentPath;
import org.tmatesoft.svn.core.internal.io.fs.FSRepresentation;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.server.dav.DAVPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class GitFSRevisionRoot
extends FSRevisionRoot {
    public GitFSRevisionRoot(FSFS owner, long revision) {
        super(owner, revision);
    }

    public FSRevisionNode getRevisionNode(String path) throws SVNException {
        path = SVNPathUtil.canonicalizeAbsolutePath((String)path);
        Repository repository = ((GitFS)this.getOwner()).getGitRepository();
        GitFSRevisionNode node = new GitFSRevisionNode((GitFS)this.getOwner());
        if ((path = DAVPathUtil.dropLeadingSlash((String)path)).isEmpty()) {
            node.setCreatedPath(path);
            node.setType(SVNNodeKind.DIR);
            FSRepresentation rep = new FSRepresentation();
            rep.setRevision(this.getRevision());
            node.setTextRepresentation(rep);
            FSID id = FSID.createRevId(null, null, (long)node.getCreatedRevision(), (long)-1L);
            node.setId(id);
            return node;
        }
        try {
            RevTree tree = new RevWalk(repository).parseTree((AnyObjectId)repository.resolve("refs/svn/" + this.getRevision()));
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "path: " + path);
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "tree: " + tree);
            TreeWalk treeWalk = TreeWalk.forPath((Repository)repository, (String)path, (RevTree)tree);
            node.setCreatedPath(path);
            if (treeWalk == null) {
                throw new SVNException(FSErrors.errorNotFound((FSRoot)this, (String)path));
            }
            if (treeWalk.isSubtree()) {
                node.setType(SVNNodeKind.DIR);
                treeWalk.release();
            } else {
                node.setType(SVNNodeKind.FILE);
                treeWalk.release();
            }
            FSRepresentation rep = new FSRepresentation();
            rep.setRevision(this.getRevision());
            node.setTextRepresentation(rep);
            FSID id = FSID.createRevId((String)treeWalk.getObjectId(0).getName(), null, (long)node.getCreatedRevision(), (long)-1L);
            node.setId(id);
            return node;
        }
        catch (IOException e) {
            node.setType(SVNNodeKind.NONE);
            return node;
        }
    }

    public InputStream getFileStreamForPath(SVNDeltaCombiner combiner, String path) throws SVNException {
        Repository repository = ((GitFS)this.getOwner()).getGitRepository();
        try {
            path = DAVPathUtil.dropLeadingSlash((String)path);
            RevCommit commit = SVNGitUtil.getCommitFromRevision(repository, this.getRevision());
            TreeWalk treeWalk = TreeWalk.forPath((Repository)repository, (String)path, (RevTree)commit.getTree());
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "stream path: " + path);
            return repository.open((AnyObjectId)treeWalk.getObjectId(0)).openStream();
        }
        catch (IOException e) {
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.FS_GENERAL, (String)"Failed to stream a file"), (Throwable)e);
        }
    }

    public FSRevisionNode getRootRevisionNode() throws SVNException {
        return this.getRevisionNode("");
    }

    public FSParentPath openPath(String path, boolean lastEntryMustExist, boolean storeParents) throws SVNException {
        if (path == null) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.FS_NOT_FOUND, (String)"null path is not supported");
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.FSFS);
        }
        String canonPath = SVNPathUtil.canonicalizeAbsolutePath((String)path);
        FSRevisionNode here = this.getRootRevisionNode();
        String pathSoFar = "/";
        FSParentPath parentPath = new FSParentPath(here, null, null);
        parentPath.setCopyStyle(1);
        String rest = canonPath.substring(1);
        while (true) {
            String entry = SVNPathUtil.head((String)rest);
            String next = SVNPathUtil.removeHead((String)rest);
            pathSoFar = SVNPathUtil.getAbsolutePath((String)SVNPathUtil.append((String)pathSoFar, (String)entry));
            FSRevisionNode child = null;
            if (entry == null || "".equals(entry)) {
                child = here;
            } else {
                FSCopyInheritance copyInheritance;
                FSRevisionNode cachedRevNode = this.fetchRevNodeFromCache(pathSoFar);
                if (cachedRevNode != null) {
                    child = cachedRevNode;
                } else {
                    try {
                        child = here.getChildDirNode(entry, this.getOwner());
                        child.setCreatedPath(here.getCreatedPath() + "/" + entry);
                    }
                    catch (SVNException svne) {
                        if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_FOUND) {
                            if (!lastEntryMustExist && (next == null || "".equals(next))) {
                                return new FSParentPath(null, entry, parentPath);
                            }
                            SVNErrorManager.error((SVNErrorMessage)FSErrors.errorNotFound((FSRoot)this, (String)path), (Throwable)svne, (SVNLogType)SVNLogType.FSFS);
                        }
                        throw svne;
                    }
                }
                parentPath.setParentPath(child, entry, storeParents ? new FSParentPath(parentPath) : null);
                if (storeParents && (copyInheritance = this.getCopyInheritance(parentPath)) != null) {
                    parentPath.setCopyStyle(copyInheritance.getStyle());
                    parentPath.setCopySourcePath(copyInheritance.getCopySourcePath());
                }
                if (cachedRevNode == null) {
                    this.putRevNodeToCache(pathSoFar, child);
                }
            }
            if (next == null || "".equals(next)) break;
            if (child.getType() != SVNNodeKind.DIR) {
                SVNErrorMessage err = FSErrors.errorNotDirectory((String)pathSoFar, (FSFS)this.getOwner());
                SVNErrorManager.error((SVNErrorMessage)err.wrap("Failure opening ''{0}''", (Object)path), (SVNLogType)SVNLogType.FSFS);
            }
            rest = next;
            here = child;
        }
        return parentPath;
    }
}

