/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.svngit;

import java.io.File;
import java.security.Principal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.io.fs.SVNGitRepositoryFactory;
import org.tmatesoft.svn.core.internal.server.dav.DAVConfig;
import org.tmatesoft.svn.core.internal.server.dav.DAVPathUtil;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceURI;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNGitRepositoryManager
extends DAVRepositoryManager {
    private static final String FILE_PROTOCOL_LINE = "file://";
    private static final String DESTINATION_HEADER = "Destination";
    private static final String DEFAULT_ACTIVITY_DB = "dav/activities.d";
    private String myResourceRepositoryRoot;
    private String myResourceContext;
    private String myResourcePathInfo;
    private Principal myUserPrincipal;
    private File myRepositoryRootDir;

    public SVNGitRepositoryManager(DAVConfig config, HttpServletRequest request) throws SVNException {
        super(config, request);
        if (config == null) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_INVALID_CONFIG_VALUE), (SVNLogType)SVNLogType.NETWORK);
        }
        this.myResourceRepositoryRoot = this.getRepositoryRoot(request.getPathInfo());
        this.myResourceContext = this.getResourceContext(request);
        this.myUserPrincipal = request.getUserPrincipal();
        this.myRepositoryRootDir = this.getRepositoryRootDir(request.getPathInfo());
        this.myResourcePathInfo = this.getResourcePathInfo(request);
        if (config.isUsingPBA()) {
            String path = null;
            if (!"MERGE".equals(request.getMethod())) {
                DAVResourceURI tmp = new DAVResourceURI(null, this.myResourcePathInfo, null, false);
                path = DAVPathUtil.standardize((String)tmp.getPath());
            }
            boolean checkDestinationPath = false;
            String destinationPath = null;
            if ("MOVE".equals(request.getMethod()) || "COPY".equals(request.getMethod())) {
                String destinationURL = request.getHeader(DESTINATION_HEADER);
                if (destinationURL == null) {
                    SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (String)"Destination path missing"), (SVNLogType)SVNLogType.NETWORK);
                }
                destinationPath = DAVPathUtil.standardize((String)this.getRepositoryRelativePath(SVNURL.parseURIEncoded((String)destinationURL)));
                checkDestinationPath = true;
            }
            String repository = this.getResourceRepositoryName(request.getPathInfo());
            String user = request.getRemoteUser();
            int access = this.getRequestedAccess(request.getMethod());
            this.checkAccess(repository, path, checkDestinationPath, destinationPath, user, access);
        }
    }

    private int getRequestedAccess(String method) {
        int access = 0;
        access = "COPY".equals(method) || "MOVE".equals(method) || "DELETE".equals(method) ? (access |= 4) : ("OPTIONS".equals(method) || "PROPFIND".equals(method) || "GET".equals(method) || "REPORT".equals(method) ? (access |= 1) : ("MKCOL".equals(method) || "PUT".equals(method) || "PROPPATCH".equals(method) || "CHECKOUT".equals(method) || "MERGE".equals(method) || "MKACTIVITY".equals(method) || "LOCK".equals(method) || "UNLOCK".equals(method) ? (access |= 2) : (access |= 6)));
        return access;
    }

    private void checkAccess(String repository, String path, boolean checkDestinationPath, String destinationPath, String user, int access) throws SVNException {
        if (this.getDAVConfig().getSVNAccess() == null) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_INVALID_CONFIG_VALUE, (String)"An error occured while loading configuration file."), (SVNLogType)SVNLogType.NETWORK);
        }
        if (!this.getDAVConfig().isAnonymousAllowed() && user == null) {
            SVNErrorManager.authenticationFailed((String)"Anonymous user is not allowed on resource", null);
        }
        if ((path != null || path == null && (access & 2) != 0) && !this.getDAVConfig().getSVNAccess().checkAccess(repository, path, user, access)) {
            if (user == null) {
                SVNErrorManager.authenticationFailed((String)"Forbidden for anonymous", null);
            } else {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.NO_AUTH_FILE_PATH), (SVNLogType)SVNLogType.NETWORK);
            }
        }
        if (checkDestinationPath && path != null && !this.getDAVConfig().getSVNAccess().checkAccess(repository, destinationPath, user, access)) {
            if (user == null) {
                SVNErrorManager.authenticationFailed((String)"Forbidden for anonymous", null);
            } else {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.NO_AUTH_FILE_PATH), (SVNLogType)SVNLogType.NETWORK);
            }
        }
    }

    public String getResourceRepositoryRoot() {
        return this.myResourceRepositoryRoot;
    }

    public String getResourceContext() {
        return this.myResourceContext;
    }

    public String getResourcePathInfo() {
        return this.myResourcePathInfo;
    }

    public SVNURL convertHttpToFile(SVNURL url) throws SVNException {
        String uri = DAVPathUtil.addLeadingSlash((String)url.getURIEncodedPath());
        if (!uri.startsWith(this.getResourceContext())) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (String)"Invalid URL ''{0}'' requested", (Object)url.toString()), (SVNLogType)SVNLogType.NETWORK);
        }
        return SVNURL.parseURIEncoded((String)(this.getResourceRepositoryRoot() + this.getRepositoryRelativePath(url)));
    }

    public String getRepositoryRelativePath(SVNURL url) throws SVNException {
        String uri = this.getURI(url);
        DAVResourceURI resourceURI = new DAVResourceURI(null, uri, null, false);
        return resourceURI.getPath();
    }

    public String getURI(SVNURL url) throws SVNException {
        String uri = DAVPathUtil.addLeadingSlash((String)url.getURIEncodedPath());
        if (uri.startsWith(this.getResourceContext())) {
            uri = uri.substring(this.getResourceContext().length());
            uri = DAVPathUtil.addLeadingSlash((String)uri);
        } else {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (String)"Invalid URL ''{0}'' requested", (Object)url.toString()), (SVNLogType)SVNLogType.NETWORK);
        }
        return uri;
    }

    public DAVResource getRequestedDAVResource(boolean isSVNClient, String deltaBase, String pathInfo, long version, String clientOptions, String baseChecksum, String resultChecksum, String label, boolean useCheckedIn, List lockTokens, Map capabilities) throws SVNException {
        pathInfo = pathInfo == null ? this.getResourcePathInfo() : pathInfo;
        SVNRepository resourceRepository = SVNGitRepositoryFactory.create(SVNURL.parseURIEncoded((String)this.getResourceRepositoryRoot()));
        if (version == -1L) {
            version = resourceRepository.getLatestRevision();
        }
        DAVResourceURI resourceURI = new DAVResourceURI(this.getResourceContext(), pathInfo, label, useCheckedIn, version);
        DAVConfig config = this.getDAVConfig();
        String fsParentPath = config.getRepositoryParentPath();
        String xsltURI = config.getXSLTIndex();
        String reposName = config.getRepositoryName();
        String uri = resourceURI.getURI();
        if (fsParentPath != null && this.getDAVConfig().isListParentPath() && uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "uri type - " + resourceURI.getType() + ", uri kind - " + resourceURI.getKind());
        String activitiesDB = config.getActivitiesDBPath();
        File activitiesDBDir = null;
        activitiesDBDir = activitiesDB == null ? new File(this.myRepositoryRootDir, DEFAULT_ACTIVITY_DB) : new File(activitiesDB);
        String userName = this.myUserPrincipal != null ? this.myUserPrincipal.getName() : null;
        SVNUserNameAuthentication auth = new SVNUserNameAuthentication(userName, false, null, false);
        BasicAuthenticationManager authManager = new BasicAuthenticationManager(new SVNAuthentication[]{auth});
        resourceRepository.setAuthenticationManager((ISVNAuthenticationManager)authManager);
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.DEFAULT, "revision: " + resourceURI.getRevision());
        DAVResource resource = new DAVResource(resourceRepository, (DAVRepositoryManager)this, resourceURI, isSVNClient, deltaBase, version, clientOptions, baseChecksum, resultChecksum, userName, activitiesDBDir, (Collection)lockTokens, capabilities);
        return resource;
    }

    private String getRepositoryRoot(String requestURI) {
        StringBuffer repositoryURL = new StringBuffer();
        repositoryURL.append(FILE_PROTOCOL_LINE);
        if (this.getDAVConfig().isUsingRepositoryPathDirective()) {
            repositoryURL.append(this.getDAVConfig().getRepositoryPath().startsWith("/") ? "" : "/");
            repositoryURL.append(this.getDAVConfig().getRepositoryPath());
        } else {
            String reposParentPath = this.getDAVConfig().getRepositoryParentPath();
            if (!reposParentPath.startsWith("/")) {
                reposParentPath = "/" + reposParentPath;
            }
            repositoryURL.append(DAVPathUtil.addTrailingSlash((String)reposParentPath));
            repositoryURL.append(DAVPathUtil.head((String)requestURI));
        }
        return repositoryURL.toString();
    }

    private File getRepositoryRootDir(String requestURI) {
        File reposRootDir = null;
        reposRootDir = this.getDAVConfig().isUsingRepositoryPathDirective() ? new File(this.getDAVConfig().getRepositoryPath()) : new File(this.getDAVConfig().getRepositoryParentPath(), DAVPathUtil.head((String)requestURI) + ".git");
        return reposRootDir;
    }

    private String getResourcePathInfo(HttpServletRequest request) throws SVNException {
        String pathInfo = request.getPathInfo();
        pathInfo = pathInfo == null || "".equals(pathInfo) ? "/" : SVNEncodingUtil.uriDecode((String)pathInfo);
        if (this.getDAVConfig().isUsingRepositoryPathDirective()) {
            return pathInfo;
        }
        if (pathInfo == null || pathInfo.length() == 0 || "/".equals(pathInfo)) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED), (SVNLogType)SVNLogType.NETWORK);
        }
        return DAVPathUtil.removeHead((String)pathInfo, (boolean)true);
    }

    private String getResourceRepositoryName(String requestURI) {
        if (this.getDAVConfig().isUsingRepositoryPathDirective()) {
            return "";
        }
        return DAVPathUtil.head((String)requestURI);
    }

    private String getResourceContext(HttpServletRequest request) {
        String requestContext = request.getContextPath();
        String pathInfo = request.getPathInfo();
        String servletPath = request.getServletPath();
        if (this.getDAVConfig().isUsingRepositoryPathDirective()) {
            if (servletPath != null && !"".equals(servletPath)) {
                if (servletPath.startsWith("/")) {
                    servletPath = servletPath.substring(1);
                }
                requestContext = SVNPathUtil.append((String)requestContext, (String)servletPath);
            }
            return this.encodeRequestContext(requestContext);
        }
        String reposName = DAVPathUtil.head((String)pathInfo);
        if (servletPath != null && !"".equals(servletPath)) {
            if (servletPath.startsWith("/")) {
                servletPath = servletPath.substring(1);
            }
            String pathToRepos = SVNPathUtil.append((String)requestContext, (String)servletPath);
            requestContext = SVNPathUtil.append((String)pathToRepos, (String)reposName);
            return this.encodeRequestContext(requestContext);
        }
        requestContext = DAVPathUtil.append((String)requestContext, (String)reposName);
        return this.encodeRequestContext(requestContext);
    }

    private String encodeRequestContext(String requestContext) {
        return SVNEncodingUtil.uriEncode((String)DAVPathUtil.addLeadingSlash((String)requestContext));
    }
}

