/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.svngit;

import com.navercorp.svngit.SVNGitRepositoryManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVServlet;
import org.tmatesoft.svn.core.internal.server.dav.handlers.SVNGitDAVHandlerFactory;
import org.tmatesoft.svn.core.internal.server.dav.handlers.ServletDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNGitServlet
extends DAVServlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletDAVHandler handler = null;
        this.logRequest(request);
        try {
            SVNGitRepositoryManager repositoryManager = new SVNGitRepositoryManager(this.getDAVConfig(), request);
            handler = SVNGitDAVHandlerFactory.createHandler(repositoryManager, request, response);
            handler.execute();
        }
        catch (DAVException de) {
            response.setContentType("text/xml; charset=\"utf-8\"");
            SVNGitServlet.handleError((DAVException)de, (HttpServletResponse)response);
        }
        catch (SVNException svne) {
            SVNErrorCode errorCode;
            StringWriter sw = new StringWriter();
            svne.printStackTrace(new PrintWriter(sw));
            String msg = sw.getBuffer().toString();
            if (msg.length() > 128) {
                msg = msg.substring(0, 128);
            }
            if ((errorCode = svne.getErrorMessage().getErrorCode()) == SVNErrorCode.FS_NOT_DIRECTORY || errorCode == SVNErrorCode.FS_NOT_FOUND || errorCode == SVNErrorCode.RA_DAV_PATH_NOT_FOUND) {
                response.sendError(404, msg);
            } else if (errorCode == SVNErrorCode.NO_AUTH_FILE_PATH) {
                response.sendError(403, msg);
            } else if (errorCode == SVNErrorCode.RA_NOT_AUTHORIZED) {
                response.sendError(401, msg);
            } else {
                String errorBody = this.generateStandardizedErrorBody(errorCode.getCode(), null, null, svne.getMessage());
                response.setStatus(500);
                response.setContentType("text/xml; charset=\"utf-8\"");
                response.getWriter().print(errorBody);
            }
        }
        catch (Throwable th) {
            StringWriter sw = new StringWriter();
            th.printStackTrace(new PrintWriter(sw));
            String msg = sw.getBuffer().toString();
            response.sendError(500, msg);
        }
        finally {
            response.flushBuffer();
        }
    }

    private String generateStandardizedErrorBody(int errorID, String namespace, String tagName, String description) {
        StringBuffer xmlBuffer = new StringBuffer();
        SVNXMLUtil.addXMLHeader((StringBuffer)xmlBuffer);
        ArrayList<String> namespaces = new ArrayList<String>();
        namespaces.add("DAV:");
        namespaces.add("http://apache.org/dav/xmlns");
        if (namespace != null) {
            namespaces.add(namespace);
        }
        SVNXMLUtil.openNamespaceDeclarationTag((String)"D", (String)"error", namespaces, (Map)SVNXMLUtil.PREFIX_MAP, (StringBuffer)xmlBuffer);
        String prefix = (String)SVNXMLUtil.PREFIX_MAP.get(namespace);
        if (prefix != null) {
            prefix = "D";
        }
        if (tagName != null && tagName.length() > 0) {
            SVNXMLUtil.openXMLTag((String)prefix, (String)tagName, (int)4, null, (StringBuffer)xmlBuffer);
        }
        SVNXMLUtil.openXMLTag((String)"SA", (String)"human-readable", (int)1, (String)"errcode", (String)String.valueOf(errorID), (StringBuffer)xmlBuffer);
        xmlBuffer.append(SVNEncodingUtil.xmlEncodeCDATA((String)description));
        SVNXMLUtil.closeXMLTag((String)"SA", (String)"human-readable", (StringBuffer)xmlBuffer);
        SVNXMLUtil.closeXMLTag((String)"D", (String)"error", (StringBuffer)xmlBuffer);
        return xmlBuffer.toString();
    }

    private void logRequest(HttpServletRequest request) {
        StringBuffer logBuffer = new StringBuffer();
        logBuffer.append('\n');
        logBuffer.append("request.getAuthType(): " + request.getAuthType());
        logBuffer.append('\n');
        logBuffer.append("request.getCharacterEncoding(): " + request.getCharacterEncoding());
        logBuffer.append('\n');
        logBuffer.append("request.getContentType(): " + request.getContentType());
        logBuffer.append('\n');
        logBuffer.append("request.getContextPath(): " + request.getContextPath());
        logBuffer.append('\n');
        logBuffer.append("request.getContentLength(): " + request.getContentLength());
        logBuffer.append('\n');
        logBuffer.append("request.getMethod(): " + request.getMethod());
        logBuffer.append('\n');
        logBuffer.append("request.getPathInfo(): " + request.getPathInfo());
        logBuffer.append('\n');
        logBuffer.append("request.getPathTranslated(): " + request.getPathTranslated());
        logBuffer.append('\n');
        logBuffer.append("request.getQueryString(): " + request.getQueryString());
        logBuffer.append('\n');
        logBuffer.append("request.getRemoteAddr(): " + request.getRemoteAddr());
        logBuffer.append('\n');
        logBuffer.append("request.getRemoteHost(): " + request.getRemoteHost());
        logBuffer.append('\n');
        logBuffer.append("request.getRemoteUser(): " + request.getRemoteUser());
        logBuffer.append('\n');
        logBuffer.append("request.getRequestURI(): " + request.getRequestURI());
        logBuffer.append('\n');
        logBuffer.append("request.getServerName(): " + request.getServerName());
        logBuffer.append('\n');
        logBuffer.append("request.getServerPort(): " + request.getServerPort());
        logBuffer.append('\n');
        logBuffer.append("request.getServletPath(): " + request.getServletPath());
        logBuffer.append('\n');
        logBuffer.append("request.getRequestURL(): " + request.getRequestURL());
        SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, logBuffer.toString());
    }
}

