/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.svngit;

import java.io.IOException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class SVNGitUtil {
    public static long getRevisionFromRefName(String refName) {
        int index = refName.lastIndexOf(47);
        return Long.valueOf(refName.substring(index + 1));
    }

    public static ObjectId getCommitIdFromRevision(Repository myGitRepository, long createdRevision) throws IOException {
        Ref ref = myGitRepository.getRef("refs/svn/" + createdRevision);
        if (ref == null) {
            return null;
        }
        return ref.getLeaf().getObjectId();
    }

    public static RevCommit getCommitFromRevision(Repository myGitRepository, long createdRevision) throws IOException {
        ObjectId commitId = SVNGitUtil.getCommitIdFromRevision(myGitRepository, createdRevision);
        if (commitId == null) {
            return null;
        }
        return new RevWalk(myGitRepository).parseCommit((AnyObjectId)commitId);
    }

    public static long getRevisionFromCommitId(Repository repo, ObjectId lastModified) throws IOException {
        String name = lastModified.getName();
        Ref ref = repo.getRef("refs/svn/id/" + name);
        Ref target = ref.getTarget();
        return SVNGitUtil.getRevisionFromRefName(target.getName());
    }
}

