/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.svngit;

import com.navercorp.svngit.InMemoryDirCache;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;

public class TreeBuilder {
    private final Repository repo;
    SortedMap<String, ObjectId> addings = new TreeMap<String, ObjectId>();
    DirCache dc = new InMemoryDirCache();
    private ObjectId baseTreeId;
    private Set<String> removings = new HashSet<String>();
    private Map<String, String> movings = new HashMap<String, String>();
    private Map<String, String> copyings = new HashMap<String, String>();

    public TreeBuilder(Repository repository) {
        this.repo = repository;
    }

    public TreeBuilder setBaseTreeId(ObjectId baseTreeId) throws IOException {
        this.baseTreeId = baseTreeId;
        return this;
    }

    public Map<String, ObjectId> getAddings() {
        return this.addings;
    }

    public boolean hasBlob(String path) {
        return this.addings.containsKey(path);
    }

    public TreeBuilder add(String path, ObjectId blobId) {
        this.addings.put(path, blobId);
        return this;
    }

    public TreeBuilder remove(String path) {
        this.removings.add(path);
        return this;
    }

    public TreeBuilder move(String sourcePath, String destinationPath) {
        this.movings.put(sourcePath, destinationPath);
        return this;
    }

    public TreeBuilder copy(String sourcePath, String destinationPath) {
        this.copyings.put(sourcePath, destinationPath);
        return this;
    }

    public Result build() throws IOException {
        HashMap<String, DiffEntry.ChangeType> updates = new HashMap<String, DiffEntry.ChangeType>();
        DirCacheBuilder builder = this.dc.builder();
        Set<String> updatePaths = this.readAndUpdateIndex(builder);
        for (String path : updatePaths) {
            updates.put(path, DiffEntry.ChangeType.MODIFY);
        }
        for (String path : this.addings.keySet()) {
            ObjectId blobId = (ObjectId)this.addings.get(path);
            DirCacheEntry entry = new DirCacheEntry(path);
            entry.setFileMode(FileMode.REGULAR_FILE);
            entry.setObjectId((AnyObjectId)blobId);
            builder.add(entry);
            updates.put(path, DiffEntry.ChangeType.ADD);
        }
        builder.commit();
        return new Result(updates, this.dc.writeTree(this.repo.getObjectDatabase().newInserter()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> readAndUpdateIndex(DirCacheBuilder builder) throws IOException {
        TreeWalk walk = null;
        HashSet<String> updatedPaths = new HashSet<String>();
        try {
            walk = new TreeWalk(this.repo);
            if (this.baseTreeId != null) {
                walk.addTree((AnyObjectId)this.baseTreeId);
            } else {
                walk.addTree((AbstractTreeIterator)new EmptyTreeIterator());
            }
            walk.addTree((AbstractTreeIterator)new DirCacheIterator(this.dc));
            walk.setRecursive(true);
            while (walk.next()) {
                final AbstractTreeIterator cIter = walk.getTree(0, AbstractTreeIterator.class);
                if (cIter == null) continue;
                final String path = new String(walk.getRawPath());
                final DirCacheIterator dcIter = (DirCacheIterator)walk.getTree(1, DirCacheIterator.class);
                abstract class LazySourceEntry {
                    LazySourceEntry() {
                    }

                    abstract DirCacheEntry get();
                }
                LazySourceEntry sourceEntry = new LazySourceEntry(){
                    private DirCacheEntry entry;
                    {
                        this.entry = null;
                    }

                    @Override
                    public DirCacheEntry get() {
                        if (this.entry != null) {
                            return this.entry;
                        }
                        this.entry = new DirCacheEntry(path);
                        this.entry.setFileMode(cIter.getEntryFileMode());
                        if (dcIter != null && dcIter.idEqual(cIter)) {
                            DirCacheEntry indexEntry = dcIter.getDirCacheEntry();
                            this.entry.setLastModified(indexEntry.getLastModified());
                            this.entry.setLength(indexEntry.getLength());
                        }
                        this.entry.setObjectIdFromRaw(cIter.idBuffer(), cIter.idOffset());
                        return this.entry;
                    }
                };
                if (this.addings.containsKey(path)) {
                    DirCacheEntry newEntry = new DirCacheEntry(path);
                    newEntry.copyMetaData(sourceEntry.get());
                    newEntry.setObjectId((AnyObjectId)this.addings.get(path));
                    builder.add(newEntry);
                    this.addings.remove(path);
                    updatedPaths.add(path);
                }
                if (this.movings.containsKey(path) || this.copyings.containsKey(path)) {
                    String newPath = this.movings.get(path);
                    if (newPath == null) {
                        newPath = this.copyings.get(path);
                    }
                    DirCacheEntry newEntry = new DirCacheEntry(newPath);
                    newEntry.copyMetaData(sourceEntry.get());
                    builder.add(newEntry);
                }
                if (this.removings.contains(path) || this.movings.containsKey(path) || updatedPaths.contains(path)) continue;
                builder.add(sourceEntry.get());
            }
            builder.commit();
        }
        finally {
            this.dc.unlock();
            if (walk != null) {
                walk.release();
            }
        }
        return updatedPaths;
    }

    public class Result {
        private Map<String, DiffEntry.ChangeType> updates;
        private ObjectId treeId;

        public Map<String, DiffEntry.ChangeType> getUpdates() {
            return this.updates;
        }

        public ObjectId getTreeId() {
            return this.treeId;
        }

        public Result(Map<String, DiffEntry.ChangeType> updates, ObjectId treeId) {
            this.updates = updates;
            this.treeId = treeId;
        }
    }
}

