/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVPathUtil;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceType;
import org.tmatesoft.svn.core.internal.server.dav.DAVServlet;
import org.tmatesoft.svn.core.internal.server.dav.DAVURIInfo;
import org.tmatesoft.svn.core.internal.server.dav.DAVWorkingResourceHelper;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVCheckOutRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVElementProperty;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.ServletDAVHandler;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNGitCheckoutHandler
extends ServletDAVHandler {
    private DAVCheckOutRequest myDAVRequest;

    public SVNGitCheckoutHandler(DAVRepositoryManager repositoryManager, HttpServletRequest request, HttpServletResponse response) {
        super(repositoryManager, request, response);
    }

    public void execute() throws SVNException {
        DAVResource resource;
        long readLength = this.readInput(false);
        boolean applyToVSN = false;
        boolean isUnreserved = false;
        boolean createActivity = false;
        LinkedList<String> activities = null;
        if (readLength > 0L) {
            DAVCheckOutRequest davRequest = this.getCheckOutRequest();
            if (davRequest.isApplyToVersion()) {
                if (this.getRequestHeader("Label") != null) {
                    this.response("DAV:apply-to-version cannot be used in conjunction with a Label header.", DAVServlet.getStatusLine((int)409), 409);
                }
                applyToVSN = true;
            }
            isUnreserved = davRequest.isUnreserved();
            DAVElementProperty rootElement = davRequest.getRoot();
            DAVElementProperty activitySetElement = rootElement.getChild(DAVCheckOutRequest.ACTIVITY_SET);
            if (activitySetElement != null) {
                if (activitySetElement.hasChild(DAVCheckOutRequest.NEW)) {
                    createActivity = true;
                } else {
                    activities = new LinkedList<String>();
                    List activitySetChildren = activitySetElement.getChildren();
                    for (DAVElementProperty activitySetChild : activitySetChildren) {
                        if (activitySetChild.getName() != DAVElement.HREF) continue;
                        activities.add(activitySetChild.getFirstValue(true));
                    }
                    if (activities.isEmpty()) {
                        throw new DAVException("Within the DAV:activity-set element, the DAV:new element must be used, or at least one DAV:href must be specified.", null, 400, null, SVNLogType.NETWORK, Level.FINE, null, null, null, 0, null);
                    }
                }
            }
        }
        if (!(resource = this.getRequestedDAVResource(true, applyToVSN)).exists()) {
            throw new DAVException(DAVServlet.getStatusLine((int)404), null, 404, null, SVNLogType.NETWORK, Level.FINE, null, null, null, 0, null);
        }
        if (resource.getResourceURI().getType() != DAVResourceType.REGULAR && resource.getResourceURI().getType() != DAVResourceType.VERSION) {
            this.response("Cannot checkout this type of resource.", DAVServlet.getStatusLine((int)409), 409);
        }
        if (!resource.isVersioned()) {
            this.response("Cannot checkout unversioned resource.", DAVServlet.getStatusLine((int)409), 409);
        }
        if (resource.isWorking()) {
            this.response("The resource is already checked out to the workspace.", DAVServlet.getStatusLine((int)409), 409);
        }
        DAVURIInfo parse = DAVPathUtil.simpleParseURI((String)((String)activities.get(0)), (DAVResource)resource);
        DAVResource workingResource = DAVWorkingResourceHelper.createWorkingResource((DAVResource)resource, (String)parse.getActivityID(), (String)"checked-out resource", (boolean)false);
        this.setResponseHeader("Cache-Control", "no-cache");
        this.handleDAVCreated(workingResource.getResourceURI().getRequestURI(), "Checked-out resource", false);
    }

    protected DAVRequest getDAVRequest() {
        return this.getCheckOutRequest();
    }

    private DAVCheckOutRequest getCheckOutRequest() {
        if (this.myDAVRequest == null) {
            this.myDAVRequest = new DAVCheckOutRequest();
        }
        return this.myDAVRequest;
    }
}

