/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import com.navercorp.svngit.TreeBuilder;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.fs.SVNGitRepositoryFactory;
import org.tmatesoft.svn.core.internal.server.dav.DAVPathUtil;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceURI;
import org.tmatesoft.svn.core.internal.server.dav.DAVServletUtil;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVCopyMoveHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.SVNGitPropPatchHandler;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNGitCopyMoveHandler
extends DAVCopyMoveHandler {
    private final boolean myIsMove;

    protected SVNGitCopyMoveHandler(DAVRepositoryManager connector, HttpServletRequest request, HttpServletResponse response, boolean isMove) {
        super(connector, request, response, isMove);
        this.myIsMove = isMove;
    }

    public void execute() throws SVNException {
        String path;
        String versionName = this.getRequestHeader("X-SVN-Version-Name");
        long version = -1L;
        try {
            version = Long.parseLong(versionName);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        DAVRepositoryManager manager = this.getRepositoryManager();
        SVNRepository resourceRepository = SVNGitRepositoryFactory.create(SVNURL.parseURIEncoded((String)manager.getResourceRepositoryRoot()));
        if (version == -1L) {
            version = resourceRepository.getLatestRevision();
        }
        resourceRepository.testConnection();
        DAVResourceURI sourceURI = new DAVResourceURI(manager.getResourceContext(), manager.getResourcePathInfo(), null, false, version);
        String sourcePath = sourceURI.getPath();
        sourcePath = DAVPathUtil.dropLeadingSlash((String)sourcePath);
        String destination = this.getRequestHeader("Destination");
        if (destination == null) {
            String netScapeHost = this.getRequestHeader("Host");
            String netScapeNewURI = this.getRequestHeader("New-uri");
            if (netScapeHost != null && netScapeNewURI != null) {
                path = SVNPathUtil.append((String)netScapeHost, (String)netScapeNewURI);
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                destination = "http://" + path;
            }
        }
        if (destination == null) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, "The request is missing a Destination header.");
            this.sendError(400, null);
            return;
        }
        URI uri = DAVServletUtil.lookUpURI((String)destination, (HttpServletRequest)this.getRequest(), (boolean)true);
        String resourceContext = manager.getResourceContext();
        path = uri.getPath().substring(resourceContext.length());
        DAVResourceURI destinationURI = new DAVResourceURI(manager.getResourceContext(), path, null, false, version);
        String destinationPath = destinationURI.getPath();
        destinationPath = DAVPathUtil.dropLeadingSlash((String)destinationPath);
        TreeBuilder treeBuilder = SVNGitPropPatchHandler.treeBuilders.get(destinationURI.getActivityID());
        if (treeBuilder == null) {
            this.sendError(400, null);
            return;
        }
        if (this.myIsMove) {
            treeBuilder.move(sourcePath, destinationPath);
        } else {
            treeBuilder.copy(sourcePath, destinationPath);
        }
        this.handleDAVCreated(destination.toString(), "Destination", false);
    }
}

