/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVHandlerFactory;
import org.tmatesoft.svn.core.internal.server.dav.handlers.SVNGitCheckoutHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.SVNGitCopyMoveHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.SVNGitDAVReportHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.SVNGitDeleteHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.SVNGitMakeActivityHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.SVNGitMakeCollectionHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.SVNGitMergeHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.SVNGitPropPatchHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.SVNGitPutHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.ServletDAVHandler;

public class SVNGitDAVHandlerFactory
extends DAVHandlerFactory {
    public static ServletDAVHandler createHandler(DAVRepositoryManager manager, HttpServletRequest request, HttpServletResponse response) throws SVNException {
        String methodName = request.getMethod();
        if ("REPORT".equals(methodName)) {
            return new SVNGitDAVReportHandler(manager, request, response);
        }
        if ("MKACTIVITY".equals(methodName)) {
            return new SVNGitMakeActivityHandler(manager, request, response);
        }
        if ("DELETE".equals(methodName)) {
            return new SVNGitDeleteHandler(manager, request, response);
        }
        if ("CHECKOUT".equals(methodName)) {
            return new SVNGitCheckoutHandler(manager, request, response);
        }
        if ("PROPPATCH".equals(methodName)) {
            return new SVNGitPropPatchHandler(manager, request, response);
        }
        if ("PUT".equals(methodName)) {
            return new SVNGitPutHandler(manager, request, response);
        }
        if ("MERGE".equals(methodName)) {
            return new SVNGitMergeHandler(manager, request, response);
        }
        if ("MKCOL".equals(methodName)) {
            return new SVNGitMakeCollectionHandler(manager, request, response);
        }
        if ("COPY".equals(methodName)) {
            return new SVNGitCopyMoveHandler(manager, request, response, false);
        }
        if ("MOVE".equals(methodName)) {
            return new SVNGitCopyMoveHandler(manager, request, response, true);
        }
        return DAVHandlerFactory.createHandler((DAVRepositoryManager)manager, (HttpServletRequest)request, (HttpServletResponse)response);
    }
}

