/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVDatedRevisionHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVFileRevisionsHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVGetDeletedRevisionHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVGetLocationSegmentsHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVGetLocationsHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVGetLocksHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVLogHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVMergeInfoHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVReplayHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVReportHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.SVNGitDAVUpdateHandler;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.Attributes;

public class SVNGitDAVReportHandler
extends DAVReportHandler {
    private HttpServletRequest myRequest;
    private HttpServletResponse myResponse;
    private DAVRepositoryManager myRepositoryManager;
    private boolean myIsUnknownReport;
    private DAVReportHandler myReportHandler;

    public SVNGitDAVReportHandler(DAVRepositoryManager connector, HttpServletRequest request, HttpServletResponse response) {
        super(connector, request, response);
        this.myRepositoryManager = connector;
        this.myRequest = request;
        this.myResponse = response;
    }

    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) throws SVNException {
        if (parent == null) {
            this.initReportHandler(element);
        }
        this.getReportHandler().handleAttributes(parent, element, attrs);
    }

    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
        this.getReportHandler().handleCData(parent, element, cdata);
    }

    public void execute() throws SVNException {
        long read = this.readInput(false);
        if (this.myIsUnknownReport) {
            throw new DAVException("The requested report is unknown.", null, 501, null, SVNLogType.DEFAULT, Level.FINE, null, "error", "svn:", SVNErrorCode.UNSUPPORTED_FEATURE.getCode(), null);
        }
        if (read == 0L) {
            throw new DAVException("The request body must specify a report.", 400, SVNLogType.NETWORK);
        }
        this.setDefaultResponseHeaders();
        this.setResponseContentType("text/xml; charset=\"utf-8\"");
        this.setResponseStatus(200);
        this.getReportHandler().execute();
    }

    private void initReportHandler(DAVElement rootElement) {
        this.myIsUnknownReport = false;
        if (rootElement == DATED_REVISIONS_REPORT) {
            this.setReportHandler((DAVReportHandler)new DAVDatedRevisionHandler(this.myRepositoryManager, this.myRequest, this.myResponse));
        } else if (rootElement == FILE_REVISIONS_REPORT) {
            this.setReportHandler((DAVReportHandler)new DAVFileRevisionsHandler(this.myRepositoryManager, this.myRequest, this.myResponse, (DAVReportHandler)this));
        } else if (rootElement == GET_LOCATIONS) {
            this.setReportHandler((DAVReportHandler)new DAVGetLocationsHandler(this.myRepositoryManager, this.myRequest, this.myResponse, (DAVReportHandler)this));
        } else if (rootElement == LOG_REPORT) {
            this.setReportHandler((DAVReportHandler)new DAVLogHandler(this.myRepositoryManager, this.myRequest, this.myResponse, (DAVReportHandler)this));
        } else if (rootElement == MERGEINFO_REPORT) {
            this.setReportHandler((DAVReportHandler)new DAVMergeInfoHandler(this.myRepositoryManager, this.myRequest, this.myResponse, (DAVReportHandler)this));
        } else if (rootElement == GET_LOCKS_REPORT) {
            this.setReportHandler((DAVReportHandler)new DAVGetLocksHandler(this.myRepositoryManager, this.myRequest, this.myResponse));
        } else if (rootElement == REPLAY_REPORT) {
            this.setReportHandler((DAVReportHandler)new DAVReplayHandler(this.myRepositoryManager, this.myRequest, this.myResponse, (DAVReportHandler)this));
        } else if (rootElement == UPDATE_REPORT) {
            this.setReportHandler((DAVReportHandler)new SVNGitDAVUpdateHandler(this.myRepositoryManager, this.myRequest, this.myResponse, this));
        } else if (rootElement == GET_LOCATION_SEGMENTS) {
            this.setReportHandler((DAVReportHandler)new DAVGetLocationSegmentsHandler(this.myRepositoryManager, this.myRequest, this.myResponse, (DAVReportHandler)this));
        } else if (rootElement == GET_DELETED_REVISION_REPORT) {
            this.setReportHandler((DAVReportHandler)new DAVGetDeletedRevisionHandler(this.myRepositoryManager, this.myRequest, this.myResponse, (DAVReportHandler)this));
        } else {
            this.myIsUnknownReport = true;
            this.setReportHandler(new DumpReportHandler(this.myRepositoryManager, this.myRequest, this.myResponse));
        }
    }

    protected DAVRequest getDAVRequest() {
        return this.getReportHandler().getDAVRequest();
    }

    private DAVReportHandler getReportHandler() {
        return this.myReportHandler;
    }

    private void setReportHandler(DAVReportHandler reportHandler) {
        this.myReportHandler = reportHandler;
    }

    private static class DumpReportHandler
    extends DAVReportHandler {
        private DAVRequest myDAVRequest;

        protected DumpReportHandler(DAVRepositoryManager connector, HttpServletRequest request, HttpServletResponse response) {
            super(connector, request, response);
        }

        protected DAVRequest getDAVRequest() {
            if (this.myDAVRequest == null) {
                this.myDAVRequest = new DAVRequest(){

                    protected void init() throws SVNException {
                    }
                };
            }
            return this.myDAVRequest;
        }
    }
}

