/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSNodeHistory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTranslateReporter;
import org.tmatesoft.svn.core.internal.io.fs.SVNGitRepositoryFactory;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVPathUtil;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceKind;
import org.tmatesoft.svn.core.internal.server.dav.DAVServletUtil;
import org.tmatesoft.svn.core.internal.server.dav.DAVXMLUtil;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVElementProperty;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVReportHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVUpdateHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVUpdateRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.ServletDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNAdminDeltifier;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.Attributes;

public class SVNGitDAVUpdateHandler
extends DAVUpdateHandler {
    private static Set UPDATE_REPORT_NAMESPACES = new SVNHashSet();
    private static final DAVElement ENTRY = DAVElement.getElement((String)"svn:", (String)"entry");
    private static final DAVElement MISSING = DAVElement.getElement((String)"svn:", (String)"missing");
    private DAVUpdateRequest myDAVRequest;
    private FSTranslateReporter myReporter;
    private boolean myInitialized = false;
    private boolean myResourceWalk = false;
    private FSRepository mySourceRepository;
    private FSRevisionRoot myRevisionRoot;
    private long myRevision = -1L;
    private SVNURL myDstURL = null;
    private String myDstPath = null;
    private String myAnchor = null;
    private SVNDepth myDepth = SVNDepth.UNKNOWN;
    private SVNDepth myRequestedDepth = SVNDepth.UNKNOWN;
    private Map myPathMap = null;
    private long myEntryRevision = -1L;
    private String myEntryLinkPath = null;
    private boolean myEntryStartEmpty = false;
    private String myEntryLockToken = null;
    private String myFileBaseChecksum = null;
    private boolean myFileTextChanged = false;
    private EditorEntry myFileEditorEntry;
    private DAVReportHandler myCommonReportHandler;
    Stack myEditorEntries;

    public SVNGitDAVUpdateHandler(DAVRepositoryManager repositoryManager, HttpServletRequest request, HttpServletResponse response, DAVReportHandler commonReportHandler) {
        super(repositoryManager, request, response, commonReportHandler);
        this.setSVNDiffVersion(this.getSVNDiffVersion());
        this.myCommonReportHandler = commonReportHandler;
    }

    public DAVRequest getDAVRequest() {
        return this.getUpdateRequest();
    }

    private DAVUpdateRequest getUpdateRequest() {
        if (this.myDAVRequest == null) {
            this.myDAVRequest = new DAVUpdateRequest();
        }
        return this.myDAVRequest;
    }

    private FSTranslateReporter getReporter() {
        return this.myReporter;
    }

    private void setReporter(FSTranslateReporter reporter) {
        this.myReporter = reporter;
    }

    private long getRevision() {
        return this.myRevision;
    }

    private void setRevision(long revision) {
        this.myRevision = revision;
    }

    private SVNURL getDstURL() {
        return this.myDstURL;
    }

    private void setDstURL(SVNURL dstURL) {
        this.myDstURL = dstURL;
    }

    private String getDstPath() {
        return this.myDstPath;
    }

    private void setDstPath(String dstPath) {
        this.myDstPath = dstPath;
    }

    private String getAnchor() {
        return this.myAnchor;
    }

    private void setAnchor(String anchor) {
        this.myAnchor = anchor;
    }

    private SVNDepth getDepth() {
        return this.myDepth;
    }

    private void setDepth(SVNDepth depth) {
        this.myDepth = depth;
    }

    private Map getPathMap() {
        if (this.myPathMap == null) {
            this.myPathMap = new SVNHashMap();
        }
        return this.myPathMap;
    }

    private void addToPathMap(String path, String linkPath) {
        String normalizedPath = DAVPathUtil.normalize((String)path);
        String repositoryPath = linkPath == null ? normalizedPath : linkPath;
        this.getPathMap().put(SVNPathUtil.getAbsolutePath((String)path), repositoryPath);
    }

    private boolean isInitialized() {
        return this.myInitialized;
    }

    private void setInitialized(boolean initialized) {
        this.myInitialized = initialized;
    }

    private boolean isResourceWalk() {
        return this.myResourceWalk;
    }

    private void setResourceWalk(boolean resourceWalk) {
        this.myResourceWalk = resourceWalk;
    }

    private FSRepository getSourceRepository() {
        return this.mySourceRepository;
    }

    private void setSourceRepository(FSRepository sourceRepository) {
        this.mySourceRepository = sourceRepository;
    }

    private long getEntryRevision() {
        return this.myEntryRevision;
    }

    private void setEntryRevision(long entryRevision) {
        this.myEntryRevision = entryRevision;
    }

    private String getEntryLinkPath() {
        return this.myEntryLinkPath;
    }

    private void setEntryLinkPath(String entryLinkPath) {
        this.myEntryLinkPath = entryLinkPath;
    }

    private boolean isEntryStartEmpty() {
        return this.myEntryStartEmpty;
    }

    private void setEntryStartEmpty(boolean entryStartEmpty) {
        this.myEntryStartEmpty = entryStartEmpty;
    }

    private String getEntryLockToken() {
        return this.myEntryLockToken;
    }

    private void setEntryLockToken(String entryLockToken) {
        this.myEntryLockToken = entryLockToken;
    }

    private String getFileBaseChecksum() {
        return this.myFileBaseChecksum;
    }

    private void setFileBaseChecksum(String fileBaseChecksum) {
        this.myFileBaseChecksum = fileBaseChecksum;
    }

    private boolean isFileTextChanged() {
        return this.myFileTextChanged;
    }

    private void setFileTextChanged(boolean fileTextChanged) {
        this.myFileTextChanged = fileTextChanged;
    }

    private void setFileIsAdded(boolean isAdded) {
        if (this.myFileEditorEntry == null) {
            this.myFileEditorEntry = new EditorEntry(isAdded);
        } else {
            this.myFileEditorEntry.setAdded(isAdded);
        }
    }

    private EditorEntry getFileEditorEntry() {
        return this.myFileEditorEntry;
    }

    private Stack getEditorEntries() {
        if (this.myEditorEntries == null) {
            this.myEditorEntries = new Stack();
        }
        return this.myEditorEntries;
    }

    private void initialize() throws SVNException {
        if (!this.isInitialized()) {
            this.getUpdateRequest().init();
            this.setDAVResource(this.getRequestedDAVResource(false, false));
            long targetRevision = this.getUpdateRequest().getRevision();
            if (!SVNRevision.isValidRevisionNumber((long)targetRevision)) {
                try {
                    targetRevision = this.getDAVResource().getLatestRevision();
                }
                catch (SVNException svne) {
                    throw DAVException.convertError((SVNErrorMessage)svne.getErrorMessage(), (int)500, (String)"Could not determine the youngest revision for the update process.", null);
                }
            }
            this.setRevision(targetRevision);
            this.myRequestedDepth = this.getUpdateRequest().getDepth();
            if (!this.getUpdateRequest().isDepthRequested() && !this.getUpdateRequest().isRecursiveRequested() && this.myRequestedDepth == SVNDepth.UNKNOWN) {
                this.myRequestedDepth = SVNDepth.INFINITY;
            }
            SVNURL srcURL = DAVServletUtil.createAbsoluteURL((HttpServletRequest)this.getRequest(), (String)this.getUpdateRequest().getSrcURL());
            String srcPath = this.getRepositoryManager().getRepositoryRelativePath(srcURL);
            this.setAnchor(srcPath);
            String dstRelativeUrl = this.getUpdateRequest().getDstURL();
            if (dstRelativeUrl != null) {
                SVNURL dstURL = DAVServletUtil.createAbsoluteURL((HttpServletRequest)this.getRequest(), (String)dstRelativeUrl);
                String dstPath = this.getRepositoryManager().getRepositoryRelativePath(dstURL);
                this.setDstPath(dstPath);
                this.setDstURL(this.getRepositoryManager().convertHttpToFile(dstURL));
                this.addToPathMap(SVNPathUtil.getAbsolutePath((String)SVNPathUtil.append((String)srcPath, (String)this.getUpdateRequest().getTarget())), dstPath);
            }
            FSFS fsfs = this.getDAVResource().getFSFS();
            this.myRevisionRoot = fsfs.createRevisionRoot(targetRevision);
            SVNURL repositoryURL = this.getRepositoryManager().convertHttpToFile(srcURL);
            FSRepository repository = (FSRepository)SVNGitRepositoryFactory.create(repositoryURL);
            FSTranslateReporter reporter = repository.beginReport(this.getRevision(), this.getDstURL(), this.getUpdateRequest().getTarget(), this.getUpdateRequest().isIgnoreAncestry(), this.getUpdateRequest().isTextDeltas(), this.getUpdateRequest().isSendCopyFromArgs(), this.myRequestedDepth, (ISVNEditor)this);
            this.setReporter(reporter);
            this.setSourceRepository(repository);
            this.setInitialized(true);
        }
    }

    protected void handleAttributes(DAVElement parent, DAVElement element, Attributes attrs) throws SVNException {
        if (element == ENTRY && parent == ServletDAVHandler.UPDATE_REPORT) {
            this.setEntryLinkPath(attrs.getValue("linkpath"));
            this.setEntryLockToken(attrs.getValue("lock-token"));
            String revisionString = attrs.getValue("rev");
            if (revisionString == null) {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (String)"Missing XML attribute: rev"), (SVNLogType)SVNLogType.NETWORK);
            }
            try {
                this.setEntryRevision(Long.parseLong(revisionString));
            }
            catch (NumberFormatException nfe) {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (Throwable)nfe), (SVNLogType)SVNLogType.NETWORK);
            }
            this.setDepth(SVNDepth.fromString((String)attrs.getValue("depth")));
            if (attrs.getValue("start-empty") != null) {
                this.setEntryStartEmpty(true);
            }
        } else if (element != MISSING || parent != ServletDAVHandler.UPDATE_REPORT) {
            if (this.isInitialized()) {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (String)"Invalid XML elements order: entry elements should follow any other."), (SVNLogType)SVNLogType.NETWORK);
            }
            this.getDAVRequest().startElement(parent, element, attrs);
        }
    }

    protected void handleCData(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
        if (element == ENTRY && parent == ServletDAVHandler.UPDATE_REPORT) {
            this.handleEntry(cdata.toString(), false);
        } else if (element == MISSING && parent == ServletDAVHandler.UPDATE_REPORT) {
            this.handleEntry(cdata.toString(), true);
        } else {
            this.getDAVRequest().endElement(parent, element, cdata);
        }
    }

    private void handleEntry(String entryPath, boolean deletePath) throws SVNException {
        this.initialize();
        try {
            if (deletePath) {
                this.getReporter().deletePath(entryPath);
            } else {
                if (this.getEntryLinkPath() == null) {
                    SVNDepth depth = this.getDepth();
                    if (depth == null || depth == SVNDepth.UNKNOWN) {
                        depth = SVNDepth.INFINITY;
                    }
                    this.getReporter().setPath(entryPath, this.getEntryLockToken(), this.getEntryRevision(), depth, this.isEntryStartEmpty());
                } else {
                    SVNURL linkURL = this.getDAVResource().getRepository().getLocation().appendPath(this.getEntryLinkPath(), true);
                    this.getReporter().linkPath(linkURL, entryPath, this.getEntryLockToken(), this.getEntryRevision(), this.getDepth(), this.isEntryStartEmpty());
                }
                if (this.getEntryLinkPath() != null && this.getDstPath() == null) {
                    String path = SVNPathUtil.append((String)this.getAnchor(), (String)SVNPathUtil.append((String)this.getUpdateRequest().getTarget(), (String)entryPath));
                    this.addToPathMap(path, this.getEntryLinkPath());
                }
                this.refreshEntry();
            }
        }
        catch (SVNException e) {
            this.getReporter().abortReport();
            this.getReporter().closeRepository();
            throw e;
        }
    }

    private void refreshEntry() {
        this.setEntryLinkPath(null);
        this.setEntryLockToken(null);
        this.setEntryRevision(-1L);
        this.setEntryStartEmpty(false);
    }

    private String getRealPath(String path) {
        path = SVNPathUtil.getAbsolutePath((String)SVNPathUtil.append((String)this.getAnchor(), (String)path));
        if (this.getPathMap().isEmpty()) {
            return path;
        }
        String repositoryPath = (String)this.getPathMap().get(path);
        if (repositoryPath != null) {
            return repositoryPath;
        }
        String tmpPath = path;
        do {
            tmpPath = SVNPathUtil.removeTail((String)tmpPath);
            repositoryPath = (String)this.getPathMap().get(tmpPath);
            if (repositoryPath == null) continue;
            return SVNPathUtil.append((String)repositoryPath, (String)path.substring(tmpPath.length()));
        } while (SVNPathUtil.getSegmentsCount((String)tmpPath) > 0);
        return path;
    }

    public void execute() throws SVNException {
        this.myCommonReportHandler.checkSVNNamespace("The request does not contain the 'svn:' namespace, so it is not going to have an svn:target-revision element. That element is required.");
        this.writeXMLHeader(null);
        try {
            this.getReporter().finishReport();
        }
        catch (SVNException e) {
            this.getReporter().abortReport();
            throw e;
        }
        finally {
            this.getReporter().closeRepository();
        }
        if (this.getDstPath() != null && this.getUpdateRequest().isResourceWalk() && SVNNodeKind.DIR == this.getDAVResource().getRepository().checkPath(this.getDstPath(), this.getRevision())) {
            this.setResourceWalk(true);
        }
        if (this.isResourceWalk()) {
            StringBuffer xmlBuffer = SVNXMLUtil.openXMLTag((String)"S", (String)"resource-walk", (int)1, null, null);
            this.write(xmlBuffer);
            FSFS fsfs = this.getSourceRepository().getFSFS();
            SVNAdminDeltifier deltifier = new SVNAdminDeltifier(fsfs, this.myRequestedDepth, true, false, false, (ISVNEditor)this);
            FSRevisionRoot zeroRoot = fsfs.createRevisionRoot(0L);
            FSRevisionRoot requestedRoot = fsfs.createRevisionRoot(this.getRevision());
            deltifier.deltifyDir(zeroRoot, "", this.getUpdateRequest().getTarget(), requestedRoot, this.getDstPath());
            xmlBuffer = SVNXMLUtil.closeXMLTag((String)"S", (String)"resource-walk", null);
            this.write(xmlBuffer);
        }
        this.writeXMLFooter(null);
    }

    protected void addXMLHeader(StringBuffer xmlBuffer, String tagName) {
        SVNHashMap attrs = new SVNHashMap();
        if (this.getUpdateRequest().isSendAll()) {
            attrs.put("send-all", Boolean.TRUE.toString());
        }
        DAVElementProperty rootElement = this.getDAVRequest().getRootElement();
        SVNXMLUtil.addXMLHeader((StringBuffer)xmlBuffer);
        tagName = tagName == null ? rootElement.getName().getName() : tagName;
        DAVXMLUtil.openNamespaceDeclarationTag((String)"S", (String)tagName, (Collection)UPDATE_REPORT_NAMESPACES, (Map)attrs, (StringBuffer)xmlBuffer, (boolean)true, (boolean)false);
    }

    public void targetRevision(long revision) throws SVNException {
        if (!this.isResourceWalk()) {
            StringBuffer xmlBuffer = SVNXMLUtil.openXMLTag((String)"S", (String)"target-revision", (int)4, (String)"rev", (String)String.valueOf(revision), null);
            this.write(xmlBuffer);
        }
    }

    public void openRoot(long revision) throws SVNException {
        EditorEntry entry = new EditorEntry(false);
        this.getEditorEntries().push(entry);
        StringBuffer xmlBuffer = null;
        xmlBuffer = this.isResourceWalk() ? this.openResourceTag("", xmlBuffer) : SVNXMLUtil.openXMLTag((String)"S", (String)"open-directory", (int)1, (String)"rev", (String)String.valueOf(revision), null);
        if (this.getUpdateRequest().getTarget().length() == 0) {
            this.addVersionURL(this.getRealPath(""), xmlBuffer);
        }
        if (this.isResourceWalk()) {
            this.closeResourceTag(xmlBuffer);
        }
        this.write(xmlBuffer);
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        this.writeEntryTag("delete-entry", path);
    }

    public void absentDir(String path) throws SVNException {
        if (!this.isResourceWalk()) {
            this.writeEntryTag("absent-directory", path);
        }
    }

    public void absentFile(String path) throws SVNException {
        if (!this.isResourceWalk()) {
            this.writeEntryTag("absent-file", path);
        }
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        EditorEntry directoryEntry = new EditorEntry(true);
        this.getEditorEntries().push(directoryEntry);
        this.writeAddEntryTag(true, path, copyFromPath, copyFromRevision);
    }

    public void openDir(String path, long revision) throws SVNException {
        EditorEntry directoryEntry = new EditorEntry(false);
        this.getEditorEntries().push(directoryEntry);
        this.writeEntryTag("open-directory", path, revision);
    }

    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        if (!this.isResourceWalk()) {
            EditorEntry entry = (EditorEntry)this.getEditorEntries().peek();
            this.changeProperties(entry, name, value);
        }
    }

    public void closeDir() throws SVNException {
        EditorEntry entry = (EditorEntry)this.getEditorEntries().pop();
        this.closeEntry(entry, true, null);
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.setFileIsAdded(true);
        this.writeAddEntryTag(false, path, copyFromPath, copyFromRevision);
    }

    public void openFile(String path, long revision) throws SVNException {
        this.setFileIsAdded(false);
        this.writeEntryTag("open-file", path, revision);
    }

    public void changeFileProperty(String path, String name, SVNPropertyValue value) throws SVNException {
        if (!this.isResourceWalk()) {
            this.changeProperties(this.getFileEditorEntry(), name, value);
        }
    }

    public void closeFile(String path, String textChecksum) throws SVNException {
        if (!this.getUpdateRequest().isSendAll() && !this.getFileEditorEntry().isAdded() && this.isFileTextChanged()) {
            StringBuffer xmlBuffer = SVNXMLUtil.openXMLTag((String)"S", (String)"fetch-file", (int)4, (String)"base-checksum", (String)this.getFileBaseChecksum(), null);
            this.write(xmlBuffer);
        }
        this.closeEntry(this.getFileEditorEntry(), false, textChecksum);
        this.getFileEditorEntry().refresh();
        this.setFileTextChanged(false);
        this.setFileBaseChecksum(null);
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        return null;
    }

    public void abortEdit() throws SVNException {
    }

    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        this.setFileTextChanged(true);
        this.setFileBaseChecksum(baseChecksum);
        if (this.isResourceWalk()) {
            return;
        }
        StringBuffer xmlBuffer = SVNXMLUtil.openXMLTag((String)"S", (String)"txdelta", (int)1, null, null);
        this.write(xmlBuffer);
    }

    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        if (!this.isResourceWalk()) {
            this.writeTextDeltaChunk(diffWindow);
        }
        return null;
    }

    public void textDeltaEnd(String path) throws SVNException {
        if (!this.isResourceWalk()) {
            this.textDeltaChunkEnd();
            this.setWriteTextDeltaHeader(true);
            StringBuffer xmlBuffer = SVNXMLUtil.closeXMLTag((String)"S", (String)"txdelta", null);
            this.write(xmlBuffer);
        }
    }

    private StringBuffer openResourceTag(String path, StringBuffer xmlBuffer) {
        return SVNXMLUtil.openXMLTag((String)"S", (String)"resource", (int)1, (String)"path", (String)path, (StringBuffer)xmlBuffer);
    }

    private StringBuffer closeResourceTag(StringBuffer xmlBuffer) {
        return SVNXMLUtil.closeXMLTag((String)"S", (String)"resource", (StringBuffer)xmlBuffer);
    }

    private void writeEntryTag(String tagName, String path) throws SVNException {
        String directoryName = SVNPathUtil.tail((String)path);
        StringBuffer xmlBuffer = SVNXMLUtil.openXMLTag((String)"S", (String)tagName, (int)4, (String)"name", (String)directoryName, null);
        this.write(xmlBuffer);
    }

    private void writeEntryTag(String tagName, String path, long revision) throws SVNException {
        SVNHashMap attrs = new SVNHashMap();
        attrs.put("name", SVNPathUtil.tail((String)path));
        attrs.put("rev", String.valueOf(revision));
        StringBuffer xmlBuffer = SVNXMLUtil.openXMLTag((String)"S", (String)tagName, (int)1, (Map)attrs, null);
        this.addVersionURL(this.getRealPath(path), xmlBuffer);
        this.write(xmlBuffer);
    }

    private void writeAddEntryTag(boolean isDirectory, String path, String copyFromPath, long copyFromRevision) throws SVNException {
        StringBuffer xmlBuffer = null;
        String realPath = this.getRealPath(path);
        if (this.isResourceWalk()) {
            String resourcePath = this.getUpdateRequest().getTarget() == null || this.getUpdateRequest().getTarget().length() == 0 ? path : SVNPathUtil.append((String)this.getUpdateRequest().getTarget(), (String)SVNPathUtil.removeHead((String)path));
            xmlBuffer = this.openResourceTag(resourcePath, xmlBuffer);
        } else {
            SVNHashMap attrs = new SVNHashMap();
            attrs.put("name", SVNPathUtil.tail((String)path));
            if (isDirectory) {
                long createdRevision = DAVServletUtil.getSafeCreatedRevision((FSRevisionRoot)this.myRevisionRoot, (String)realPath);
                String bcURL = DAVPathUtil.buildURI((String)this.getDAVResource().getResourceURI().getContext(), (DAVResourceKind)DAVResourceKind.BASELINE_COLL, (long)createdRevision, (String)realPath, (boolean)false);
                attrs.put("bc-url", bcURL);
            }
            if (copyFromPath != null) {
                attrs.put("copyfrom-path", copyFromPath);
                attrs.put("copyfrom-rev", String.valueOf(copyFromRevision));
            }
            String tagName = isDirectory ? "add-directory" : "add-file";
            xmlBuffer = SVNXMLUtil.openXMLTag((String)"S", (String)tagName, (int)1, (Map)attrs, null);
        }
        this.addVersionURL(realPath, xmlBuffer);
        if (this.isResourceWalk()) {
            this.closeResourceTag(xmlBuffer);
        }
        this.write(xmlBuffer);
    }

    private void changeProperties(EditorEntry entry, String name, SVNPropertyValue value) throws SVNException {
        if (this.getUpdateRequest().isSendAll()) {
            if (value != null) {
                this.writePropertyTag("set-prop", name, value);
            } else {
                this.writeEntryTag("remove-prop", name);
            }
        } else if (value != null) {
            if (SVNProperty.isEntryProperty((String)name)) {
                if ("svn:entry:committed-rev".equals(name)) {
                    entry.setCommitedRevision(value.getString());
                } else if ("svn:entry:committed-date".equals(name)) {
                    entry.setCommitedDate(value.getString());
                } else if ("svn:entry:last-author".equals(name)) {
                    entry.setLastAuthor(value.getString());
                } else if ("svn:entry:lock-token".equals(name) && value == null) {
                    entry.addRemovedProperty(name);
                }
                return;
            }
            if (value == null) {
                entry.addRemovedProperty(name);
            } else {
                entry.setHasChangedProperty(true);
            }
        }
    }

    private void closeEntry(EditorEntry entry, boolean isDirectory, String textCheckSum) throws SVNException {
        if (this.isResourceWalk()) {
            return;
        }
        StringBuffer xmlBuffer = new StringBuffer();
        if (!entry.removedPropertiesCollectionIsEmpty() && !entry.isAdded()) {
            Iterator iterator = entry.getRemovedProperies();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                SVNXMLUtil.openXMLTag((String)"S", (String)"remove-prop", (int)4, (String)"name", (String)name, (StringBuffer)xmlBuffer);
            }
        }
        if (!this.getUpdateRequest().isSendAll() && entry.hasChangedProperties() && !entry.isAdded()) {
            SVNXMLUtil.openXMLTag((String)"S", (String)"fetch-props", (int)4, null, (StringBuffer)xmlBuffer);
        }
        SVNXMLUtil.openXMLTag((String)"S", (String)"prop", (int)1, null, (StringBuffer)xmlBuffer);
        if (textCheckSum != null) {
            SVNXMLUtil.openCDataTag((String)"SD", (String)"md5-checksum", (String)textCheckSum, (StringBuffer)xmlBuffer);
        }
        if (entry.getCommitedRevision() != null) {
            SVNXMLUtil.openCDataTag((String)"D", (String)DAVElement.VERSION_NAME.getName(), (String)entry.getCommitedRevision(), (StringBuffer)xmlBuffer);
        }
        if (entry.getCommitedDate() != null) {
            SVNXMLUtil.openCDataTag((String)"D", (String)DAVElement.CREATION_DATE.getName(), (String)entry.getCommitedDate(), (StringBuffer)xmlBuffer);
        }
        if (entry.getLastAuthor() != null) {
            SVNXMLUtil.openCDataTag((String)"D", (String)DAVElement.CREATOR_DISPLAY_NAME.getName(), (String)entry.getLastAuthor(), (StringBuffer)xmlBuffer);
        }
        SVNXMLUtil.closeXMLTag((String)"S", (String)"prop", (StringBuffer)xmlBuffer);
        String tagName = entry.isAdded() ? "add-" : "open-";
        tagName = tagName + (isDirectory ? "directory" : "file");
        SVNXMLUtil.closeXMLTag((String)"S", (String)tagName, (StringBuffer)xmlBuffer);
        this.write(xmlBuffer);
    }

    private StringBuffer addVersionURL(String path, StringBuffer xmlBuffer) {
        long revision = this.myRevisionRoot.getRevision();
        try {
            FSNodeHistory history = this.myRevisionRoot.getNodeHistory(path);
            history = history.getPreviousHistory(false);
            revision = history.getHistoryEntry().getRevision();
        }
        catch (SVNException svne) {
            SVNDebugLog.getDefaultLog().logError(SVNLogType.DEFAULT, svne.getMessage());
        }
        String url = DAVPathUtil.buildURI((String)this.getDAVResource().getResourceURI().getContext(), (DAVResourceKind)DAVResourceKind.VERSION, (long)revision, (String)path, (boolean)false, (boolean)false);
        xmlBuffer = SVNXMLUtil.openXMLTag((String)"D", (String)"checked-in", (int)1, null, (StringBuffer)xmlBuffer);
        SVNXMLUtil.openCDataTag((String)"D", (String)"href", (String)url, (StringBuffer)xmlBuffer);
        SVNXMLUtil.closeXMLTag((String)"D", (String)"checked-in", (StringBuffer)xmlBuffer);
        return xmlBuffer;
    }

    static {
        UPDATE_REPORT_NAMESPACES.add("svn:");
        UPDATE_REPORT_NAMESPACES.add("http://subversion.tigris.org/xmlns/dav/");
    }

    private class EditorEntry {
        boolean myAdded = false;
        private String myCommitedRevision = null;
        private String myCommitedDate = null;
        private String myLastAuthor = null;
        private Collection myRemovedProperties;
        boolean myHasChangedProperties = false;

        public EditorEntry(boolean isAdded) {
            this.myAdded = isAdded;
        }

        private void setAdded(boolean isAdded) {
            this.myAdded = isAdded;
        }

        private boolean isAdded() {
            return this.myAdded;
        }

        private void setHasChangedProperty(boolean hasChangedProperties) {
            this.myHasChangedProperties = hasChangedProperties;
        }

        private boolean hasChangedProperties() {
            return this.myHasChangedProperties;
        }

        private void addRemovedProperty(String name) {
            if (this.myRemovedProperties == null) {
                this.myRemovedProperties = new ArrayList();
            }
            this.myRemovedProperties.add(name);
        }

        private boolean removedPropertiesCollectionIsEmpty() {
            return this.myRemovedProperties == null || this.myRemovedProperties.isEmpty();
        }

        private Iterator getRemovedProperies() {
            if (!this.removedPropertiesCollectionIsEmpty()) {
                return this.myRemovedProperties.iterator();
            }
            return null;
        }

        private String getCommitedRevision() {
            return this.myCommitedRevision;
        }

        private void setCommitedRevision(String commitedRevision) {
            this.myCommitedRevision = commitedRevision;
        }

        private String getCommitedDate() {
            return this.myCommitedDate;
        }

        private void setCommitedDate(String commitedDate) {
            this.myCommitedDate = commitedDate;
        }

        private String getLastAuthor() {
            return this.myLastAuthor;
        }

        private void setLastAuthor(String lastAuthor) {
            this.myLastAuthor = lastAuthor;
        }

        private void refresh() {
            this.myCommitedRevision = null;
            this.myCommitedDate = null;
            this.myLastAuthor = null;
            this.myHasChangedProperties = false;
            if (this.myRemovedProperties != null) {
                this.myRemovedProperties.clear();
            }
        }
    }
}

