/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import com.navercorp.svngit.TreeBuilder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.fs.SVNGitRepositoryFactory;
import org.tmatesoft.svn.core.internal.server.dav.DAVPathUtil;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceURI;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVDeleteHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.SVNGitPropPatchHandler;
import org.tmatesoft.svn.core.io.SVNRepository;

public class SVNGitDeleteHandler
extends DAVDeleteHandler {
    public SVNGitDeleteHandler(DAVRepositoryManager repositoryManager, HttpServletRequest request, HttpServletResponse response) {
        super(repositoryManager, request, response);
    }

    public void execute() throws SVNException {
        DAVResourceURI resourceURI;
        TreeBuilder treeBuilder;
        String versionName = this.getRequestHeader("X-SVN-Version-Name");
        long version = -1L;
        try {
            version = Long.parseLong(versionName);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        DAVRepositoryManager manager = this.getRepositoryManager();
        SVNRepository resourceRepository = SVNGitRepositoryFactory.create(SVNURL.parseURIEncoded((String)manager.getResourceRepositoryRoot()));
        if (version == -1L) {
            version = resourceRepository.getLatestRevision();
        }
        if ((treeBuilder = SVNGitPropPatchHandler.treeBuilders.get((resourceURI = new DAVResourceURI(manager.getResourceContext(), manager.getResourcePathInfo(), null, false, version)).getActivityID())) == null) {
            this.sendError(404, null);
            return;
        }
        String path = resourceURI.getPath();
        if (path == null || path.isEmpty()) {
            SVNGitPropPatchHandler.treeBuilders.remove(resourceURI.getActivityID());
            this.setResponseStatus(204);
            return;
        }
        path = DAVPathUtil.dropLeadingSlash((String)path);
        treeBuilder.remove(path);
        this.setResponseStatus(204);
    }
}

