/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import com.navercorp.svngit.GitFS;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.lib.CommitBuilder;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVMakeActivityHandler;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNGitMakeActivityHandler
extends DAVMakeActivityHandler {
    private GitFS myGitFS;
    public static Map<String, CommitBuilder> commitBuilders = new HashMap<String, CommitBuilder>();

    public SVNGitMakeActivityHandler(DAVRepositoryManager repositoryManager, HttpServletRequest request, HttpServletResponse response) {
        super(repositoryManager, request, response);
    }

    public void execute() throws SVNException {
        DAVResource resource = this.getRequestedDAVResource(false, false);
        FSRepository repos = (FSRepository)resource.getRepository();
        this.myGitFS = (GitFS)repos.getFSFS();
        this.readInput(true);
        if (commitBuilders.containsKey(resource.getActivityID())) {
            throw new DAVException("<DAV:resource-must-be-null/>", 409, SVNLogType.NETWORK);
        }
        if (!resource.canBeActivity()) {
            throw new DAVException("<DAV:activity-location-ok/>", 403, SVNLogType.NETWORK);
        }
        CommitBuilder builder = new CommitBuilder();
        commitBuilders.put(resource.getActivityID(), builder);
        this.setResponseHeader("Cache-Control", "no-cache");
        this.handleDAVCreated(resource.getResourceURI().getURI(), "Activity", false);
    }
}

