/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.fs.SVNGitRepositoryFactory;
import org.tmatesoft.svn.core.internal.server.dav.DAVPathUtil;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceURI;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVMakeCollectionHandler;
import org.tmatesoft.svn.core.io.SVNRepository;

public class SVNGitMakeCollectionHandler
extends DAVMakeCollectionHandler {
    protected static Map<String, Set<String>> emptyDirss = new HashMap<String, Set<String>>();

    public SVNGitMakeCollectionHandler(DAVRepositoryManager manager, HttpServletRequest request, HttpServletResponse response) {
        super(manager, request, response);
    }

    public void execute() throws SVNException {
        String versionName = this.getRequestHeader("X-SVN-Version-Name");
        long version = -1L;
        try {
            version = Long.parseLong(versionName);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        DAVRepositoryManager manager = this.getRepositoryManager();
        SVNRepository resourceRepository = SVNGitRepositoryFactory.create(SVNURL.parseURIEncoded((String)manager.getResourceRepositoryRoot()));
        if (version == -1L) {
            version = resourceRepository.getLatestRevision();
        }
        resourceRepository.testConnection();
        DAVResourceURI resourceURI = new DAVResourceURI(manager.getResourceContext(), manager.getResourcePathInfo(), null, false, version);
        String activityId = resourceURI.getActivityID();
        if (!emptyDirss.containsKey(activityId)) {
            emptyDirss.put(activityId, new HashSet());
        }
        Set<String> emptyDirs = emptyDirss.get(activityId);
        String path = resourceURI.getPath();
        path = DAVPathUtil.dropLeadingSlash((String)path);
        emptyDirs.add(path);
        this.handleDAVCreated(null, "Collection", false);
    }
}

