/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import com.navercorp.svngit.GitFS;
import com.navercorp.svngit.SVNGitUtil;
import com.navercorp.svngit.TreeBuilder;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.fs.SVNGitRepository;
import org.tmatesoft.svn.core.internal.io.fs.SVNGitRepositoryFactory;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceURI;
import org.tmatesoft.svn.core.internal.server.dav.DAVXMLUtil;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVElementProperty;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVPropPatchRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVPropertiesProvider;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVPropsResult;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVResponse;
import org.tmatesoft.svn.core.internal.server.dav.handlers.LivePropertySpecification;
import org.tmatesoft.svn.core.internal.server.dav.handlers.SVNGitMakeActivityHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.ServletDAVHandler;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNGitPropPatchHandler
extends ServletDAVHandler {
    protected static Map<String, TreeBuilder> treeBuilders = new HashMap<String, TreeBuilder>();
    private DAVPropPatchRequest myDAVRequest;

    public SVNGitPropPatchHandler(DAVRepositoryManager connector, HttpServletRequest request, HttpServletResponse response) {
        super(connector, request, response);
    }

    public void execute() throws SVNException {
        DAVResourceURI resourceURI;
        CommitBuilder commitBuilder;
        long readLength = this.readInput(false);
        if (readLength <= 0L) {
            this.getPropPatchRequest().invalidXMLRoot();
        }
        String versionName = this.getRequestHeader("X-SVN-Version-Name");
        long version = -1L;
        try {
            version = Long.parseLong(versionName);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        DAVRepositoryManager manager = this.getRepositoryManager();
        SVNRepository resourceRepository = SVNGitRepositoryFactory.create(SVNURL.parseURIEncoded((String)manager.getResourceRepositoryRoot()));
        if (version == -1L) {
            version = resourceRepository.getLatestRevision();
        }
        if ((commitBuilder = SVNGitMakeActivityHandler.commitBuilders.get((resourceURI = new DAVResourceURI(manager.getResourceContext(), manager.getResourcePathInfo(), null, false, version)).getActivityID())) == null) {
            this.sendError(400, null);
            return;
        }
        try {
            Repository repo = ((GitFS)((SVNGitRepository)resourceRepository).getFSFS()).getGitRepository();
            RevCommit parentId = SVNGitUtil.getCommitFromRevision(repo, version);
            RevTree tree = new RevWalk(repo).parseTree((AnyObjectId)parentId);
            commitBuilder.setParentId((AnyObjectId)parentId);
            if (!treeBuilders.containsKey(resourceURI.getActivityID())) {
                treeBuilders.put(resourceURI.getActivityID(), new TreeBuilder(repo));
            }
            TreeBuilder treeBuilder = treeBuilders.get(resourceURI.getActivityID());
            treeBuilder.setBaseTreeId(tree.getId());
        }
        catch (IOException e) {
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.FS_GENERAL, (String)"Failed to ready commit"), (Throwable)e);
        }
        DAVPropPatchRequest requestXMLObject = this.getPropPatchRequest();
        DAVElementProperty rootElement = requestXMLObject.getRoot();
        List childrenElements = rootElement.getChildren();
        for (DAVElementProperty childElement : childrenElements) {
            DAVElementProperty propChildrenElement = childElement.getChild(DAVElement.PROP);
            if (propChildrenElement == null) {
                SVNDebugLog.getDefaultLog().logError(SVNLogType.NETWORK, "A \"prop\" element is missing inside the propertyupdate command.");
                this.setResponseStatus(400);
                return;
            }
            for (Object child : propChildrenElement.getChildren()) {
                DAVElementProperty element = (DAVElementProperty)child;
                if (!element.getName().equals((Object)DAVElement.LOG)) continue;
                commitBuilder.setMessage(element.getFirstValue(true));
            }
        }
        String propStatText = "<D:propstat><D:prop><ns3:log/></D:prop><D:status>HTTP/1.1 200 OK</D:status></D:propstat>";
        DAVPropsResult propResult = new DAVPropsResult();
        propResult.addPropStatsText(propStatText);
        DAVResponse response = new DAVResponse(null, this.getRequest().getRequestURI(), null, propResult, 0);
        try {
            DAVXMLUtil.sendMultiStatus((DAVResponse)response, (HttpServletResponse)this.getHttpServletResponse(), (int)207, (Collection)this.getNamespaces());
        }
        catch (IOException ioe) {
            throw new DAVException(ioe.getMessage(), 500, SVNErrorCode.IO_ERROR.getCode());
        }
    }

    protected DAVRequest getDAVRequest() {
        return this.getPropPatchRequest();
    }

    private boolean isPropertyWritable(DAVElement property, LivePropertySpecification livePropSpec) {
        if (livePropSpec != null) {
            return livePropSpec.isWritable();
        }
        return property != DAVElement.LOCK_DISCOVERY && property != DAVElement.SUPPORTED_LOCK;
    }

    private DAVPropPatchRequest getPropPatchRequest() {
        if (this.myDAVRequest == null) {
            this.myDAVRequest = new DAVPropPatchRequest();
        }
        return this.myDAVRequest;
    }

    private class DAVPropertyRollBackHandler
    implements IDAVPropertyContextHandler {
        private DAVPropertiesProvider myPropsProvider;

        public DAVPropertyRollBackHandler(DAVPropertiesProvider propsProvider) {
            this.myPropsProvider = propsProvider;
        }

        @Override
        public void handleContext(PropertyChangeContext propContext) {
            if (propContext.myRollBackProperty == null) {
                return;
            }
            if (propContext.myLivePropertySpec == null) {
                try {
                    this.myPropsProvider.applyRollBack(propContext.myRollBackProperty.myPropertyName, propContext.myRollBackProperty.myRollBackPropertyValue);
                }
                catch (DAVException dave) {
                    if (propContext.myError == null) {
                        propContext.myError = dave;
                    }
                    DAVException err = dave;
                    while (err.getPreviousException() != null) {
                        err = err.getPreviousException();
                    }
                    err.setPreviousException(propContext.myError);
                    propContext.myError = dave;
                }
            }
        }
    }

    private class DAVPropertyExecuteHandler
    implements IDAVPropertyContextHandler {
        private DAVPropertiesProvider myPropsProvider;

        public DAVPropertyExecuteHandler(DAVPropertiesProvider propsProvider) {
            this.myPropsProvider = propsProvider;
        }

        @Override
        public void handleContext(PropertyChangeContext propContext) {
            if (propContext.myLivePropertySpec == null) {
                try {
                    SVNPropertyValue rollBackPropValue = this.myPropsProvider.getPropertyValue(propContext.myProperty.getName());
                    propContext.myRollBackProperty = new RollBackProperty(propContext.myProperty.getName(), rollBackPropValue);
                }
                catch (DAVException dave) {
                    this.handleError(dave, propContext);
                    return;
                }
                if (propContext.myIsSet) {
                    try {
                        this.myPropsProvider.storeProperty(propContext.myProperty);
                    }
                    catch (DAVException dave) {
                        this.handleError(dave, propContext);
                        return;
                    }
                }
                try {
                    this.myPropsProvider.removeProperty(propContext.myProperty.getName());
                }
                catch (DAVException dAVException) {
                    // empty catch block
                }
            }
        }

        private void handleError(DAVException dave, PropertyChangeContext propContext) {
            DAVException exc = new DAVException("Could not execute PROPPATCH.", 500, dave, 206);
            propContext.myError = exc;
        }
    }

    private static interface IDAVPropertyContextHandler {
        public void handleContext(PropertyChangeContext var1);
    }

    private static class RollBackProperty {
        private DAVElement myPropertyName;
        private SVNPropertyValue myRollBackPropertyValue;

        public RollBackProperty(DAVElement propertyName, SVNPropertyValue rollBackPropertyValue) {
            this.myPropertyName = propertyName;
            this.myRollBackPropertyValue = rollBackPropertyValue;
        }
    }

    private static class PropertyChangeContext {
        private boolean myIsSet;
        private DAVElementProperty myProperty;
        private LivePropertySpecification myLivePropertySpec;
        private DAVException myError;
        private RollBackProperty myRollBackProperty;

        private PropertyChangeContext() {
        }
    }
}

