/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import com.navercorp.svngit.GitFS;
import com.navercorp.svngit.SVNGitUtil;
import com.navercorp.svngit.TreeBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaReader;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.io.fs.SVNGitRepositoryFactory;
import org.tmatesoft.svn.core.internal.server.dav.DAVPathUtil;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceURI;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVPutHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.SVNGitPropPatchHandler;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;

public class SVNGitPutHandler
extends DAVPutHandler {
    public SVNGitPutHandler(DAVRepositoryManager repositoryManager, HttpServletRequest request, HttpServletResponse response) {
        super(repositoryManager, request, response);
    }

    public void execute() throws SVNException {
        ObjectId blobId;
        String versionName = this.getRequestHeader("X-SVN-Version-Name");
        long version = -1L;
        try {
            version = Long.parseLong(versionName);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        DAVRepositoryManager manager = this.getRepositoryManager();
        SVNRepository resourceRepository = SVNGitRepositoryFactory.create(SVNURL.parseURIEncoded((String)manager.getResourceRepositoryRoot()));
        if (version == -1L) {
            version = resourceRepository.getLatestRevision();
        }
        resourceRepository.testConnection();
        GitFS gitFS = (GitFS)((FSRepository)resourceRepository).getFSFS();
        DAVResourceURI resourceURI = new DAVResourceURI(manager.getResourceContext(), manager.getResourcePathInfo(), null, false, version);
        TreeBuilder treeBuilder = SVNGitPropPatchHandler.treeBuilders.get(resourceURI.getActivityID());
        if (treeBuilder == null) {
            this.sendError(400, null);
            return;
        }
        final Repository repo = gitFS.getGitRepository();
        String path = resourceURI.getPath();
        path = DAVPathUtil.dropLeadingSlash((String)path);
        final ByteArrayOutputStream targetStream = new ByteArrayOutputStream();
        try {
            ObjectId sourceBlobId;
            RevCommit commitId = SVNGitUtil.getCommitFromRevision(repo, version);
            RevTree tree = new RevWalk(repo).parseTree((AnyObjectId)commitId);
            TreeWalk treeWalk = TreeWalk.forPath((Repository)repo, (String)path, (RevTree)tree);
            if (treeWalk == null) {
                sourceBlobId = null;
            } else {
                if (treeWalk.isSubtree()) {
                    this.sendError(400, null);
                }
                sourceBlobId = treeWalk.getObjectId(0);
            }
            ISVNDeltaConsumer deltaConsumer = new ISVNDeltaConsumer(){
                public SVNDeltaProcessor myDeltaProcessor;
                private InputStream sourceStream;

                public void applyTextDelta(String path, String baseChecksum) throws SVNException {
                    try {
                        this.sourceStream = sourceBlobId != null ? new ByteArrayInputStream(repo.open((AnyObjectId)sourceBlobId).getBytes()) : SVNFileUtil.DUMMY_IN;
                        this.myDeltaProcessor = new SVNDeltaProcessor();
                        this.myDeltaProcessor.applyTextDelta(this.sourceStream, (OutputStream)targetStream, false);
                    }
                    catch (IOException e) {
                        throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.FS_GENERAL, (String)("Failed to read a blob: " + sourceBlobId)), (Throwable)e);
                    }
                }

                public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
                    return this.myDeltaProcessor.textDeltaChunk(diffWindow);
                }

                public void textDeltaEnd(String path) throws SVNException {
                    try {
                        this.sourceStream.close();
                    }
                    catch (IOException e) {
                        throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.FS_GENERAL, (String)"Failed to close a input stream"), (Throwable)e);
                    }
                }
            };
            deltaConsumer.applyTextDelta(null, null);
            InputStream inputStream = this.getRequestInputStream();
            byte[] buffer = new byte[2048];
            int readCount = -1;
            while ((readCount = inputStream.read(buffer)) != -1) {
                if (readCount == 0) continue;
                SVNDeltaReader deltaReader = new SVNDeltaReader();
                SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
                if (deltaReader != null) {
                    deltaReader.nextWindow(buffer, 0, readCount, path, deltaConsumer);
                    continue;
                }
                deltaGenerator.sendDelta(path, buffer, readCount, deltaConsumer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ObjectInserter objectInserter = repo.getObjectDatabase().newInserter();
        byte[] bytes = targetStream.toByteArray();
        try {
            blobId = objectInserter.insert(3, bytes, 0, bytes.length);
        }
        catch (IOException e) {
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.FS_GENERAL, (String)"Failed to insert a blob"), (Throwable)e);
        }
        treeBuilder.add(path, blobId);
        boolean isReplaced = treeBuilder.hasBlob(path);
        this.handleDAVCreated(null, "Resource", isReplaced);
    }
}

