/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.adl14;

import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.base.MultiplicityInterval;
import com.nedap.archie.rminfo.MetaModels;

public class ADL14DefaultMultiplicitiesSetter {
    private final MetaModels metaModels;

    public ADL14DefaultMultiplicitiesSetter(MetaModels metaModels) {
        this.metaModels = metaModels;
    }

    public void setDefaults(Archetype archetype) {
        this.metaModels.selectModel(archetype);
        this.correctItemsMultiplicities(archetype.getDefinition());
    }

    private void correctItemsMultiplicities(CObject cObject) {
        for (CAttribute attribute : cObject.getAttributes()) {
            for (CObject child : attribute.getChildren()) {
                if (child.getOccurrences() == null && this.metaModels.isMultiple(cObject.getRmTypeName(), attribute.getRmAttributeName())) {
                    child.setOccurrences(new MultiplicityInterval(1, 1));
                }
                this.correctItemsMultiplicities(child);
            }
        }
    }
}

