/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.adlparser;

import com.nedap.archie.adlparser.ADLParseException;
import com.nedap.archie.adlparser.antlr.AdlLexer;
import com.nedap.archie.adlparser.antlr.AdlParser;
import com.nedap.archie.adlparser.modelconstraints.BMMConstraintImposer;
import com.nedap.archie.adlparser.modelconstraints.ModelConstraintImposer;
import com.nedap.archie.adlparser.modelconstraints.ReflectionConstraintImposer;
import com.nedap.archie.adlparser.treewalkers.ADLListener;
import com.nedap.archie.antlr.errors.ANTLRParserErrors;
import com.nedap.archie.antlr.errors.ArchieErrorListener;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.utils.ArchetypeParsePostProcesser;
import com.nedap.archie.rminfo.MetaModels;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.commons.io.input.BOMInputStream;

public class ADLParser {
    private final MetaModels metaModels;
    private final ModelConstraintImposer modelConstraintImposer;
    private ANTLRParserErrors errors;
    private Lexer lexer;
    private AdlParser parser;
    private ADLListener listener;
    private ParseTreeWalker walker;
    private AdlParser.AdlContext tree;
    public ArchieErrorListener errorListener;
    private boolean logEnabled = true;

    public ADLParser() {
        this.metaModels = null;
        this.modelConstraintImposer = null;
    }

    @Deprecated
    public ADLParser(ModelConstraintImposer modelConstraintImposer) {
        this.modelConstraintImposer = modelConstraintImposer;
        this.metaModels = null;
    }

    public ADLParser(MetaModels models) {
        this.metaModels = models;
        this.modelConstraintImposer = null;
    }

    public Archetype parse(String adl) throws ADLParseException {
        return this.parse((CharStream)CharStreams.fromString((String)adl));
    }

    public Archetype parse(InputStream stream) throws ADLParseException, IOException {
        return this.parse(CharStreams.fromStream((InputStream)new BOMInputStream(stream), (Charset)((Charset)Charset.availableCharsets().get("UTF-8"))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Archetype parse(CharStream stream) throws ADLParseException {
        Archetype archetype;
        this.errors = new ANTLRParserErrors();
        this.errorListener = new ArchieErrorListener(this.errors);
        this.errorListener.setLogEnabled(this.logEnabled);
        Archetype result = null;
        this.lexer = new AdlLexer(stream);
        this.lexer.addErrorListener((ANTLRErrorListener)this.errorListener);
        this.parser = new AdlParser((TokenStream)new CommonTokenStream((TokenSource)this.lexer));
        this.parser.addErrorListener((ANTLRErrorListener)this.errorListener);
        this.tree = this.parser.adl();
        try {
            ADLListener listener = new ADLListener(this.errors, this.metaModels);
            this.walker = new ParseTreeWalker();
            this.walker.walk((ParseTreeListener)listener, (ParseTree)this.tree);
            result = listener.getArchetype();
            ArchetypeParsePostProcesser.fixArchetype(result);
            if (this.modelConstraintImposer != null && result.getDefinition() != null) {
                this.modelConstraintImposer.imposeConstraints(result.getDefinition());
            } else if (this.metaModels != null) {
                ModelConstraintImposer imposer;
                this.metaModels.selectModel(result);
                if (this.metaModels.getSelectedBmmModel() != null) {
                    imposer = new BMMConstraintImposer(this.metaModels.getSelectedBmmModel());
                    imposer.setSingleOrMultiple(result.getDefinition());
                } else if (this.metaModels.getSelectedModelInfoLookup() != null) {
                    imposer = new ReflectionConstraintImposer(this.metaModels.getSelectedModelInfoLookup());
                    imposer.setSingleOrMultiple(result.getDefinition());
                }
            }
            archetype = result;
        }
        catch (Throwable throwable) {
            if (this.errors.hasErrors()) {
                throw new ADLParseException(this.errors, result);
            }
            throw throwable;
        }
        if (this.errors.hasErrors()) {
            throw new ADLParseException(this.errors, result);
        }
        return archetype;
    }

    public ANTLRParserErrors getErrors() {
        return this.errors;
    }

    public Lexer getLexer() {
        return this.lexer;
    }

    public void setLexer(Lexer lexer) {
        this.lexer = lexer;
    }

    public AdlParser getParser() {
        return this.parser;
    }

    public void setParser(AdlParser parser) {
        this.parser = parser;
    }

    public ADLListener getListener() {
        return this.listener;
    }

    public void setListener(ADLListener listener) {
        this.listener = listener;
    }

    public ParseTreeWalker getWalker() {
        return this.walker;
    }

    public void setWalker(ParseTreeWalker walker) {
        this.walker = walker;
    }

    public AdlParser.AdlContext getTree() {
        return this.tree;
    }

    public void setTree(AdlParser.AdlContext tree) {
        this.tree = tree;
    }

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    public void setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
    }
}

