/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.adlparser.modelconstraints;

import com.nedap.archie.adlparser.modelconstraints.ModelConstraintImposer;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.base.Cardinality;
import com.nedap.archie.base.MultiplicityInterval;
import com.nedap.archie.rminfo.MetaModel;
import com.nedap.archie.rminfo.MetaModelInterface;
import com.nedap.archie.rminfo.ModelInfoLookup;
import java.util.Stack;

public class ReflectionConstraintImposer
implements ModelConstraintImposer {
    private MetaModelInterface lookup;

    public ReflectionConstraintImposer(ModelInfoLookup classLookup) {
        this.lookup = new MetaModel(classLookup, null);
    }

    public ReflectionConstraintImposer(MetaModelInterface metaModel) {
        this.lookup = metaModel;
    }

    private CAttribute createCAttribute(String typeId, String attributeName) {
        CAttribute attribute = new CAttribute();
        attribute.setMultiple(false);
        attribute.setRmAttributeName(attributeName);
        boolean nullable = this.lookup.isNullable(typeId, attributeName);
        if (nullable) {
            attribute.setExistence(new MultiplicityInterval(0, 1));
        } else {
            attribute.setExistence(new MultiplicityInterval(1, 1));
        }
        if (this.lookup.isMultiple(typeId, attributeName)) {
            if (nullable) {
                attribute.setCardinality(Cardinality.unbounded());
            } else {
                attribute.setCardinality(Cardinality.mandatoryAndUnbounded());
            }
            attribute.setMultiple(true);
        } else {
            attribute.setCardinality(null);
            attribute.setMultiple(false);
        }
        return attribute;
    }

    @Override
    public void setSingleOrMultiple(CComplexObject rootNode) {
        if (rootNode == null) {
            return;
        }
        Stack<CObject> workList = new Stack<CObject>();
        workList.add(rootNode);
        while (!workList.isEmpty()) {
            CObject object = (CObject)workList.pop();
            for (CAttribute attribute : object.getAttributes()) {
                if (attribute.getDifferentialPath() == null) {
                    attribute.setMultiple(this.lookup.isMultiple(object.getRmTypeName(), attribute.getRmAttributeName()));
                } else {
                    attribute.setMultiple(this.lookup.isMultiple(object.getRmTypeName(), attribute.getDifferentialPath()));
                }
                for (CObject child : attribute.getChildren()) {
                    workList.push(child);
                }
            }
        }
    }

    @Override
    public CAttribute getDefaultAttribute(String typeId, String attribute) {
        if (!this.lookup.attributeExists(typeId, attribute)) {
            return null;
        }
        return this.createCAttribute(typeId, attribute);
    }
}

