/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.adlparser.treewalkers;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.nedap.archie.adlparser.antlr.AdlBaseListener;
import com.nedap.archie.adlparser.antlr.AdlParser;
import com.nedap.archie.adlparser.treewalkers.CComplexObjectParser;
import com.nedap.archie.adlparser.treewalkers.ComponentTerminologiesHelper;
import com.nedap.archie.adlparser.treewalkers.TerminologyParser;
import com.nedap.archie.antlr.errors.ANTLRParserErrors;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.ArchetypeHRID;
import com.nedap.archie.aom.AuthoredArchetype;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.LanguageSection;
import com.nedap.archie.aom.OperationalTemplate;
import com.nedap.archie.aom.ResourceAnnotations;
import com.nedap.archie.aom.ResourceDescription;
import com.nedap.archie.aom.Template;
import com.nedap.archie.aom.TemplateOverlay;
import com.nedap.archie.aom.rmoverlay.RmOverlay;
import com.nedap.archie.aom.terminology.ArchetypeTerminology;
import com.nedap.archie.rminfo.MetaModels;
import com.nedap.archie.serializer.odin.AdlOdinToJsonConverter;
import com.nedap.archie.serializer.odin.OdinObjectParser;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.TerminalNode;

public class ADLListener
extends AdlBaseListener {
    private static final Pattern VERSION_ID_REGEX = Pattern.compile("[0-9]+.[0-9]+.[0-9]+((-rc|-alpha)(.[0-9]+)?)?");
    private static final Pattern GUID_REGEX = Pattern.compile("[0-9a-fA-F]+-[0-9a-fA-F]+-[0-9a-fA-F]+-[0-9a-fA-F]+-[0-9a-fA-F]+");
    private ANTLRParserErrors errors;
    private Archetype rootArchetype;
    Set<String> seenMetaDataIdentifiers = new HashSet<String>();
    private Archetype archetype;
    private CComplexObjectParser cComplexObjectParser;
    private TerminologyParser terminologyParser;
    private MetaModels metaModels;

    public ADLListener(ANTLRParserErrors errors, MetaModels metaModels) {
        this.errors = errors;
        this.cComplexObjectParser = new CComplexObjectParser(errors, metaModels);
        this.terminologyParser = new TerminologyParser(errors);
        this.metaModels = metaModels;
    }

    public void enterArchetype(AdlParser.ArchetypeContext ctx) {
        this.rootArchetype = new AuthoredArchetype();
        this.setArchetype(this.rootArchetype);
        this.parseArchetypeHRID(ctx.ARCHETYPE_HRID());
    }

    private void setArchetype(Archetype archetype) {
        this.archetype = archetype;
    }

    public void exitArchetype(AdlParser.ArchetypeContext ctx) {
        this.rootArchetype.setDifferential(true);
    }

    public void enterTemplate(AdlParser.TemplateContext ctx) {
        this.rootArchetype = new Template();
        this.setArchetype(this.rootArchetype);
        this.parseArchetypeHRID(ctx.ARCHETYPE_HRID());
    }

    public void exitTemplate(AdlParser.TemplateContext ctx) {
        this.rootArchetype.setDifferential(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void enterTemplateOverlay(AdlParser.TemplateOverlayContext ctx) {
        TemplateOverlay overlay = new TemplateOverlay();
        overlay.setDifferential(true);
        if (this.rootArchetype != null) {
            if (!(this.rootArchetype instanceof Template)) throw new IllegalArgumentException("Template overlay in a non-template archetype is not allowed. This sounds like a grammar problem.");
            Template owningTemplate = (Template)this.rootArchetype;
            owningTemplate.addTemplateOverlay(overlay);
            overlay.setOwningTemplate(owningTemplate);
        } else {
            this.rootArchetype = overlay;
        }
        this.setArchetype(overlay);
        this.parseArchetypeHRID(ctx.ARCHETYPE_HRID());
    }

    public void enterOperationalTemplate(AdlParser.OperationalTemplateContext ctx) {
        this.rootArchetype = new OperationalTemplate();
        this.rootArchetype.setDifferential(false);
        this.setArchetype(this.rootArchetype);
        this.parseArchetypeHRID(ctx.ARCHETYPE_HRID());
    }

    private void parseArchetypeHRID(TerminalNode hrId) {
        if (hrId != null) {
            ArchetypeHRID archetypeID = new ArchetypeHRID(hrId.getText());
            this.archetype.setArchetypeId(archetypeID);
            if (this.metaModels != null) {
                this.metaModels.selectModel(this.archetype);
            }
        }
    }

    public void enterMetaDataItem(AdlParser.MetaDataItemContext ctx) {
        if (this.archetype instanceof AuthoredArchetype) {
            AuthoredArchetype authoredArchetype = (AuthoredArchetype)this.archetype;
            String identifier = ctx.identifier().getText();
            String metaDataValue = ctx.metaDataValue() != null ? ctx.metaDataValue().getText() : null;
            this.checkMetaDataIdentifier(identifier, ctx.identifier());
            switch (identifier) {
                case "adl_version": {
                    if (metaDataValue != null && VERSION_ID_REGEX.matcher(metaDataValue).matches()) {
                        authoredArchetype.setAdlVersion(metaDataValue);
                        break;
                    }
                    this.addError("Encountered metadata tag 'adl_version' with an invalid version id: " + metaDataValue, "incorrect header metadata format", (ParserRuleContext)ctx.identifier());
                    break;
                }
                case "rm_release": {
                    if (metaDataValue != null && VERSION_ID_REGEX.matcher(metaDataValue).matches()) {
                        authoredArchetype.setRmRelease(metaDataValue);
                        break;
                    }
                    this.addError("Encountered metadata tag 'rm_release' with an invalid version id: " + metaDataValue, "incorrect header metadata format", (ParserRuleContext)ctx.identifier());
                    break;
                }
                case "build_uid": {
                    if (metaDataValue != null && GUID_REGEX.matcher(metaDataValue).matches()) {
                        authoredArchetype.setBuildUid(metaDataValue);
                        break;
                    }
                    this.addError("Encountered metadata tag 'build_uid' with an invalid guid: " + metaDataValue, "incorrect header metadata format", (ParserRuleContext)ctx.identifier());
                    break;
                }
                case "uid": {
                    if (metaDataValue != null && GUID_REGEX.matcher(metaDataValue).matches()) {
                        authoredArchetype.setUid(metaDataValue);
                        break;
                    }
                    this.addError("Encountered metadata tag 'uid' with an invalid guid: " + metaDataValue, "incorrect header metadata format", (ParserRuleContext)ctx.identifier());
                    break;
                }
                case "controlled": {
                    if (metaDataValue == null) {
                        authoredArchetype.setControlled(true);
                        break;
                    }
                    this.addError("Encountered metadata tag 'controlled' with a value assignment while expecting none", "incorrect header metadata format", (ParserRuleContext)ctx.identifier());
                    break;
                }
                case "generated": {
                    if (metaDataValue == null) {
                        authoredArchetype.setGenerated(true);
                        break;
                    }
                    this.addError("Encountered metadata tag 'generated' with a value assignment while expecting none", "incorrect header metadata format", (ParserRuleContext)ctx.identifier());
                    break;
                }
                default: {
                    authoredArchetype.addOtherMetadata(identifier, metaDataValue);
                }
            }
        }
    }

    public void enterDefinitionSection(AdlParser.DefinitionSectionContext ctx) {
        CComplexObject definition = this.cComplexObjectParser.parseComplexObject(ctx.c_complex_object());
        this.archetype.setDefinition(definition);
    }

    public void enterLanguageSection(AdlParser.LanguageSectionContext ctx) {
        this.archetype.setAuthoredResourceContent((LanguageSection)OdinObjectParser.convert((AdlParser.Odin_textContext)ctx.odin_text(), LanguageSection.class));
    }

    public void enterTerminologySection(AdlParser.TerminologySectionContext ctx) {
        this.archetype.setTerminology(this.terminologyParser.parseTerminology(ctx));
    }

    public void enterDescriptionSection(AdlParser.DescriptionSectionContext ctx) {
        this.archetype.setDescription((ResourceDescription)OdinObjectParser.convert((AdlParser.Odin_textContext)ctx.odin_text(), ResourceDescription.class));
    }

    public void enterSpecializationSection(AdlParser.SpecializationSectionContext ctx) {
        if (ctx != null && ctx.archetype_ref() != null) {
            this.archetype.setParentArchetypeId(ctx.archetype_ref().getText());
        }
    }

    public void enterRulesSection(AdlParser.RulesSectionContext ctx) {
        this.archetype.setRules(this.cComplexObjectParser.parseRules(ctx));
    }

    public void enterAnnotationsSection(AdlParser.AnnotationsSectionContext ctx) {
        this.archetype.setAnnotations((ResourceAnnotations)OdinObjectParser.convert((AdlParser.Odin_textContext)ctx.odin_text(), ResourceAnnotations.class));
    }

    public void enterRmOverlaySection(AdlParser.RmOverlaySectionContext ctx) {
        this.archetype.setRmOverlay((RmOverlay)OdinObjectParser.convert((AdlParser.Odin_textContext)ctx.odin_text(), RmOverlay.class));
    }

    private void checkMetaDataIdentifier(String identifier, AdlParser.IdentifierContext identifierContext) {
        if (this.seenMetaDataIdentifiers.contains(identifier)) {
            this.addError("Encountered another metadata tag for '" + identifier + "' whilst single allowed", "only one header metadata tag allowed", (ParserRuleContext)identifierContext);
        } else {
            this.seenMetaDataIdentifiers.add(identifier);
        }
    }

    private void addError(String message, String shortMessage, ParserRuleContext identifierContext) {
        this.errors.addError(message, shortMessage, identifierContext.getStart().getLine(), identifierContext.getStart().getCharPositionInLine(), Integer.valueOf(identifierContext.getStart().getText().length()), identifierContext.getStart().getText());
    }

    public void enterComponentTerminologiesSection(AdlParser.ComponentTerminologiesSectionContext ctx) {
        if (!(this.archetype instanceof OperationalTemplate)) {
            throw new IllegalArgumentException("cannot add component terminologies to anything but an operational template");
        }
        if (ctx.odin_text().attr_vals() != null) {
            OperationalTemplate template = (OperationalTemplate)this.archetype;
            ComponentTerminologiesHelper helper = (ComponentTerminologiesHelper)OdinObjectParser.convert((AdlParser.Odin_textContext)ctx.odin_text(), ComponentTerminologiesHelper.class);
            template.setComponentTerminologies(helper.getComponentTerminologies());
        } else {
            OperationalTemplate template = (OperationalTemplate)this.archetype;
            TypeFactory typeFactory = AdlOdinToJsonConverter.getObjectMapper().getTypeFactory();
            MapType mapType = typeFactory.constructMapType(ConcurrentHashMap.class, String.class, ArchetypeTerminology.class);
            template.setComponentTerminologies((Map)OdinObjectParser.convert((AdlParser.Odin_textContext)ctx.odin_text(), (JavaType)mapType));
        }
    }

    public Archetype getArchetype() {
        return this.rootArchetype;
    }

    public ANTLRParserErrors getErrors() {
        return this.errors;
    }
}

