/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.adlparser.treewalkers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nedap.archie.adlparser.antlr.AdlParser;
import com.nedap.archie.adlparser.treewalkers.BaseTreeWalker;
import com.nedap.archie.adlparser.treewalkers.PrimitivesConstraintParser;
import com.nedap.archie.adlparser.treewalkers.RulesParser;
import com.nedap.archie.antlr.errors.ANTLRParserErrors;
import com.nedap.archie.aom.ArchetypeSlot;
import com.nedap.archie.aom.CArchetypeRoot;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CAttributeTuple;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CComplexObjectProxy;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.CPrimitiveTuple;
import com.nedap.archie.aom.DefaultValueContainer;
import com.nedap.archie.aom.RulesSection;
import com.nedap.archie.aom.SiblingOrder;
import com.nedap.archie.base.Cardinality;
import com.nedap.archie.base.MultiplicityInterval;
import com.nedap.archie.base.OpenEHRBase;
import com.nedap.archie.rminfo.MetaModels;
import com.nedap.archie.rules.Assertion;
import com.nedap.archie.serializer.odin.AdlOdinToJsonConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.TerminalNode;

public class CComplexObjectParser
extends BaseTreeWalker {
    private final PrimitivesConstraintParser primitivesConstraintParser;
    private final MetaModels metaModels;

    public CComplexObjectParser(ANTLRParserErrors errors, MetaModels metaModels) {
        super(errors);
        this.primitivesConstraintParser = new PrimitivesConstraintParser(errors);
        this.metaModels = metaModels;
    }

    public RulesSection parseRules(AdlParser.RulesSectionContext context) {
        RulesSection result = new RulesSection();
        result.setContent(context.getText());
        RulesParser rulesParser = new RulesParser(this.getErrors());
        for (AdlParser.AssertionContext assertion : context.assertion_list().assertion()) {
            result.addRule(rulesParser.parse(assertion));
        }
        return result;
    }

    public CComplexObject parseComplexObject(AdlParser.C_complex_objectContext context) {
        CComplexObject object = new CComplexObject();
        if (context.type_id() != null) {
            object.setRmTypeName(context.type_id().getText());
        }
        if (context.ID_CODE() != null) {
            object.setNodeId(context.ID_CODE().getText());
        } else if (context.ROOT_ID_CODE() != null) {
            object.setNodeId(context.ROOT_ID_CODE().getText());
        }
        if (context.c_occurrences() != null) {
            object.setOccurrences(this.parseMultiplicityInterval(context.c_occurrences()));
        }
        for (AdlParser.C_attribute_defContext attribute : context.c_attribute_def()) {
            this.parseCAttribute(object, attribute);
        }
        return object;
    }

    private void parseCAttribute(CComplexObject parent, AdlParser.C_attribute_defContext attributeDefContext) {
        if (attributeDefContext.c_attribute() != null) {
            CAttribute attribute = new CAttribute();
            AdlParser.C_attributeContext attributeContext = attributeDefContext.c_attribute();
            if (attributeContext.attribute_id() != null) {
                attribute.setRmAttributeName(attributeContext.attribute_id().getText());
            } else {
                attribute.setDifferentialPath(attributeContext.ADL_PATH().getText());
                attribute.setRmAttributeName(CComplexObjectParser.getLastAttributeFromPath(attribute.getDifferentialPath()));
            }
            if (attributeContext.c_existence() != null) {
                attribute.setExistence(this.parseMultiplicityInterval(attributeContext.c_existence()));
            }
            if (attributeContext.c_cardinality() != null) {
                attribute.setCardinality(this.parseCardinalityInterval(attributeContext.c_cardinality()));
            }
            if (attributeContext.c_objects() != null) {
                attribute.setChildren(this.parseCObjects(attributeContext.c_objects()));
            } else if (attributeContext.CONTAINED_REGEXP() != null) {
                attribute.addChild(this.primitivesConstraintParser.parseRegex(attributeContext.CONTAINED_REGEXP()));
            }
            parent.addAttribute(attribute);
            if (attribute.getCardinality() != null) {
                attribute.setMultiple(true);
            }
        } else if (attributeDefContext.c_attribute_tuple() != null) {
            parent.addAttributeTuple(this.parseAttributeTuple(parent, attributeDefContext.c_attribute_tuple()));
        } else {
            AdlParser.Default_valueContext defaultValueContext = attributeDefContext.default_value();
            if (defaultValueContext != null) {
                if (defaultValueContext.odin_text().included_other_language() != null) {
                    parent.setDefaultValue(this.parseIncludedLanguageDefaultValue(defaultValueContext.odin_text().included_other_language().getText()));
                } else {
                    this.parseOdinDefaultValue(parent, defaultValueContext);
                }
            }
        }
    }

    private OpenEHRBase parseIncludedLanguageDefaultValue(String text) {
        String format = text.substring(1, text.indexOf(41));
        int startIndex = text.indexOf("<#");
        int endIndex = text.lastIndexOf("#>");
        String content = text.substring(startIndex + 2, endIndex);
        if (format.equalsIgnoreCase("json")) {
            ObjectMapper defaultValueJsonObjectMapper = this.getDefaultValueJsonObjectMapper();
            if (defaultValueJsonObjectMapper != null) {
                try {
                    return (OpenEHRBase)defaultValueJsonObjectMapper.readValue(content, OpenEHRBase.class);
                }
                catch (IOException e) {
                    this.addError("error parsing json in default value: " + e.getMessage());
                    return new DefaultValueContainer(content, format);
                }
            }
            return new DefaultValueContainer(format, content);
        }
        return new DefaultValueContainer(format, content);
    }

    private void parseOdinDefaultValue(CComplexObject parent, AdlParser.Default_valueContext defaultValueContext) {
        try {
            ObjectMapper defaultValueObjectMapper = this.getDefaultValueOdinObjectMapper();
            if (defaultValueObjectMapper != null) {
                OpenEHRBase value = (OpenEHRBase)defaultValueObjectMapper.readValue(new AdlOdinToJsonConverter().convert(defaultValueContext.odin_text()), OpenEHRBase.class);
                parent.setDefaultValue(value);
            } else {
                parent.setDefaultValue(new DefaultValueContainer("odin", defaultValueContext.odin_text().getText()));
            }
        }
        catch (IOException e) {
            this.addError("error parsing json in default value: " + e.getMessage());
            parent.setDefaultValue(new DefaultValueContainer("odin", defaultValueContext.odin_text().getText()));
        }
    }

    private ObjectMapper getDefaultValueJsonObjectMapper() {
        if (this.metaModels == null) {
            return null;
        }
        if (this.metaModels.getSelectedModel() == null) {
            return null;
        }
        return this.metaModels.getSelectedModel().getJsonObjectMapper();
    }

    private ObjectMapper getDefaultValueOdinObjectMapper() {
        if (this.metaModels == null) {
            return null;
        }
        if (this.metaModels.getSelectedModel() == null) {
            return null;
        }
        return this.metaModels.getSelectedModel().getOdinInputObjectMapper();
    }

    public static String getFirstAttributeOfPath(String path) {
        return path.substring(0, path.indexOf(47));
    }

    public static String getPathMinusFirstAttribute(String path) {
        return path.substring(path.indexOf(47));
    }

    public static String getLastAttributeFromPath(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    private CAttributeTuple parseAttributeTuple(CComplexObject parent, AdlParser.C_attribute_tupleContext attributeTupleContext) {
        List attributeIdList = attributeTupleContext.attribute_id();
        CAttributeTuple tuple = new CAttributeTuple();
        for (AdlParser.Attribute_idContext idContext : attributeIdList) {
            CAttribute attribute = new CAttribute();
            String id = idContext.getText();
            attribute.setRmAttributeName(id);
            tuple.addMember(attribute);
            parent.addAttribute(attribute);
        }
        List tupleContexts = attributeTupleContext.c_object_tuple();
        for (AdlParser.C_object_tupleContext tupleContext : tupleContexts) {
            CPrimitiveTuple primitiveTuple = new CPrimitiveTuple();
            List primitiveObjectContexts = tupleContext.c_object_tuple_items().c_object_tuple_item();
            int i = 0;
            for (AdlParser.C_object_tuple_itemContext tupleObjectContext : primitiveObjectContexts) {
                CPrimitiveObject<?, ?> primitiveObject = null;
                if (tupleObjectContext.c_primitive_object() != null) {
                    primitiveObject = this.primitivesConstraintParser.parsePrimitiveObject(tupleObjectContext.c_primitive_object());
                } else if (tupleObjectContext.CONTAINED_REGEXP() != null) {
                    primitiveObject = this.primitivesConstraintParser.parseRegex(tupleObjectContext.CONTAINED_REGEXP());
                }
                ((CAttribute)tuple.getMembers().get(i)).addChild(primitiveObject);
                primitiveTuple.addMember(primitiveObject);
                ++i;
            }
            tuple.addTuple(primitiveTuple);
        }
        return tuple;
    }

    private List<CObject> parseCObjects(AdlParser.C_objectsContext objectsContext) {
        ArrayList<CObject> result = new ArrayList<CObject>();
        if (objectsContext.c_primitive_object() != null) {
            result.add(this.primitivesConstraintParser.parsePrimitiveObject(objectsContext.c_primitive_object()));
        } else {
            List nonPrimitiveObjectOrderedContext = objectsContext.c_non_primitive_object_ordered();
            if (nonPrimitiveObjectOrderedContext != null) {
                for (AdlParser.C_non_primitive_object_orderedContext object : nonPrimitiveObjectOrderedContext) {
                    CObject cobject = this.parseNonPrimitiveObject(object.c_non_primitive_object());
                    AdlParser.Sibling_orderContext siblingOrderContext = object.sibling_order();
                    if (siblingOrderContext != null) {
                        SiblingOrder siblingOrder = new SiblingOrder();
                        if (siblingOrderContext.SYM_AFTER() != null) {
                            siblingOrder.setBefore(false);
                        } else if (siblingOrderContext.SYM_BEFORE() != null) {
                            siblingOrder.setBefore(true);
                        }
                        siblingOrder.setSiblingNodeId(siblingOrderContext.ID_CODE().getText());
                        cobject.setSiblingOrder(siblingOrder);
                    }
                    result.add(cobject);
                }
            }
        }
        return result;
    }

    private CObject parseNonPrimitiveObject(AdlParser.C_non_primitive_objectContext objectContext) {
        if (objectContext.c_complex_object() != null) {
            return this.parseComplexObject(objectContext.c_complex_object());
        }
        if (objectContext.c_archetype_root() != null) {
            return this.parseArchetypeRoot(objectContext.c_archetype_root());
        }
        if (objectContext.c_complex_object_proxy() != null) {
            return this.parseCComplexObjectProxy(objectContext.c_complex_object_proxy());
        }
        if (objectContext.archetype_slot() != null) {
            return this.parseArchetypeSlot(objectContext.archetype_slot());
        }
        return null;
    }

    private CComplexObjectProxy parseCComplexObjectProxy(AdlParser.C_complex_object_proxyContext proxyContext) {
        CComplexObjectProxy proxy = new CComplexObjectProxy();
        proxy.setOccurrences(this.parseMultiplicityInterval(proxyContext.c_occurrences()));
        proxy.setTargetPath(proxyContext.adl_path().getText());
        proxy.setRmTypeName(proxyContext.type_id().getText());
        proxy.setNodeId(proxyContext.ID_CODE().getText());
        return proxy;
    }

    private CArchetypeRoot parseArchetypeRoot(AdlParser.C_archetype_rootContext archetypeRootContext) {
        CArchetypeRoot root = new CArchetypeRoot();
        root.setRmTypeName(archetypeRootContext.type_id().getText());
        root.setNodeId(archetypeRootContext.ID_CODE().getText());
        if (archetypeRootContext.archetype_ref() != null) {
            root.setArchetypeRef(archetypeRootContext.archetype_ref().getText());
        }
        root.setOccurrences(this.parseMultiplicityInterval(archetypeRootContext.c_occurrences()));
        for (AdlParser.C_attribute_defContext attributeContext : archetypeRootContext.c_attribute_def()) {
            this.parseCAttribute(root, attributeContext);
        }
        return root;
    }

    private ArchetypeSlot parseArchetypeSlot(AdlParser.Archetype_slotContext slotContext) {
        ArchetypeSlot slot = new ArchetypeSlot();
        slot.setNodeId(slotContext.ID_CODE().getText());
        slot.setRmTypeName(slotContext.type_id().getText());
        if (slotContext.SYM_CLOSED() != null) {
            slot.setClosed(true);
        }
        if (slotContext.c_occurrences() != null) {
            slot.setOccurrences(this.parseMultiplicityInterval(slotContext.c_occurrences()));
        }
        RulesParser assertionParser = new RulesParser(this.getErrors());
        if (slotContext.c_excludes() != null) {
            for (AdlParser.AssertionContext assertionContext : slotContext.c_excludes().assertion()) {
                slot.getExcludes().add((Assertion)assertionParser.parse(assertionContext));
            }
        }
        if (slotContext.c_includes() != null) {
            for (AdlParser.AssertionContext assertionContext : slotContext.c_includes().assertion()) {
                slot.getIncludes().add((Assertion)assertionParser.parse(assertionContext));
            }
        }
        return slot;
    }

    private Cardinality parseCardinalityInterval(AdlParser.C_cardinalityContext context) {
        Cardinality cardinality = new Cardinality();
        MultiplicityInterval interval = this.parseMultiplicity(context.cardinality().multiplicity());
        cardinality.setInterval(interval);
        List modContexts = context.cardinality().multiplicity_mod();
        for (AdlParser.Multiplicity_modContext modContext : modContexts) {
            if (modContext.ordering_mod() != null) {
                cardinality.setOrdered(modContext.ordering_mod().SYM_ORDERED() != null);
            } else {
                cardinality.setOrdered(true);
            }
            if (modContext.unique_mod() == null) continue;
            cardinality.setUnique(true);
        }
        return cardinality;
    }

    private MultiplicityInterval parseMultiplicityInterval(AdlParser.C_existenceContext existenceContext) {
        MultiplicityInterval interval = new MultiplicityInterval();
        List integers = existenceContext.existence().INTEGER();
        if (integers.size() == 1) {
            interval.setLower((Object)Integer.parseInt(((TerminalNode)integers.get(0)).getText()));
            interval.setUpper((Object)((Integer)interval.getLower()));
        } else if (integers.size() == 2) {
            interval.setLower((Object)Integer.parseInt(((TerminalNode)integers.get(0)).getText()));
            interval.setUpper((Object)Integer.parseInt(((TerminalNode)integers.get(1)).getText()));
        }
        return interval;
    }

    private MultiplicityInterval parseMultiplicityInterval(AdlParser.C_occurrencesContext occurrencesContext) {
        if (occurrencesContext == null) {
            return null;
        }
        return this.parseMultiplicity(occurrencesContext.multiplicity());
    }

    private MultiplicityInterval parseMultiplicity(AdlParser.MultiplicityContext multiplicity) {
        if (multiplicity == null) {
            return null;
        }
        MultiplicityInterval interval = new MultiplicityInterval();
        List integers = multiplicity.INTEGER();
        if (multiplicity.SYM_INTERVAL_SEP() != null) {
            if (multiplicity.getText().contains("*")) {
                interval.setLower((Object)Integer.parseInt(((TerminalNode)integers.get(0)).getText()));
                interval.setUpperUnbounded(true);
            } else {
                interval.setLower((Object)Integer.parseInt(((TerminalNode)integers.get(0)).getText()));
                interval.setUpper((Object)Integer.parseInt(((TerminalNode)integers.get(1)).getText()));
            }
        } else if (multiplicity.getText().contains("*")) {
            interval.setLowerUnbounded(false);
            interval.setLower((Object)0);
            interval.setUpperUnbounded(true);
        } else {
            interval.setLower((Object)Integer.parseInt(((TerminalNode)integers.get(0)).getText()));
            interval.setUpper((Object)((Integer)interval.getLower()));
        }
        interval.fixUnboundedIncluded();
        return interval;
    }
}

