/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.adlparser.treewalkers;

import com.nedap.archie.adlparser.antlr.AdlParser;
import com.nedap.archie.adlparser.treewalkers.BaseTreeWalker;
import com.nedap.archie.antlr.errors.ANTLRParserErrors;
import com.nedap.archie.aom.primitives.CDate;
import com.nedap.archie.aom.primitives.CDateTime;
import com.nedap.archie.aom.primitives.CDuration;
import com.nedap.archie.aom.primitives.CTime;
import com.nedap.archie.base.Interval;
import com.nedap.archie.datetime.DateTimeParsers;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;

public class TemporalConstraintParser
extends BaseTreeWalker {
    public TemporalConstraintParser(ANTLRParserErrors errors) {
        super(errors);
    }

    public CDuration parseCDuration(AdlParser.C_durationContext context) {
        AdlParser.Duration_interval_valueContext intervalContext;
        AdlParser.Duration_list_valueContext durationListValueContext;
        AdlParser.Duration_valueContext durationValueContext;
        CDuration result = new CDuration();
        if (context.DURATION_CONSTRAINT_PATTERN() != null) {
            String durationPattern = context.DURATION_CONSTRAINT_PATTERN().getText();
            if (durationPattern.endsWith("/")) {
                durationPattern = durationPattern.substring(0, durationPattern.length() - 1);
            }
            result.setPatternConstraint(durationPattern);
        }
        if (context.assumed_duration_value() != null) {
            result.setAssumedValue(DateTimeParsers.parseDurationValue((String)context.assumed_duration_value().duration_value().getText()));
        }
        if ((durationValueContext = context.duration_value()) != null) {
            this.parseDuration(result, durationValueContext);
        }
        if ((durationListValueContext = context.duration_list_value()) != null) {
            for (AdlParser.Duration_valueContext durationValueContext1 : durationListValueContext.duration_value()) {
                this.parseDuration(result, durationValueContext1);
            }
        }
        if ((intervalContext = context.duration_interval_value()) != null) {
            result.addConstraint(this.parseDurationInterval(intervalContext));
        }
        if (context.duration_interval_list_value() != null) {
            for (AdlParser.Duration_interval_valueContext intervalListContext : context.duration_interval_list_value().duration_interval_value()) {
                result.addConstraint(this.parseDurationInterval(intervalListContext));
            }
        }
        return result;
    }

    private Interval<TemporalAmount> parseDurationInterval(AdlParser.Duration_interval_valueContext context) {
        Interval interval = null;
        if (context.relop() != null) {
            interval = this.parseRelOpDurationInterval(context);
        } else {
            interval = new Interval();
            if (context.duration_value().size() == 1) {
                interval.setLower((Object)DateTimeParsers.parseDurationValue((String)context.duration_value(0).getText()));
                interval.setUpper((Object)((TemporalAmount)interval.getLower()));
            } else {
                interval.setLower((Object)DateTimeParsers.parseDurationValue((String)context.duration_value(0).getText()));
                interval.setUpper((Object)DateTimeParsers.parseDurationValue((String)context.duration_value(1).getText()));
            }
            if (context.SYM_GT() != null) {
                interval.setLowerIncluded(false);
            }
            if (context.SYM_LT() != null) {
                interval.setUpperIncluded(false);
            }
            interval.fixUnboundedIncluded();
        }
        return interval;
    }

    private Interval<TemporalAmount> parseRelOpDurationInterval(AdlParser.Duration_interval_valueContext context) {
        Interval interval = new Interval();
        TemporalAmount duration = DateTimeParsers.parseDurationValue((String)((AdlParser.Duration_valueContext)context.duration_value().get(0)).getText());
        switch (context.relop().getText()) {
            case "<": {
                interval.setUpperIncluded(false);
            }
            case "<=": {
                interval.setLowerUnbounded(true);
                interval.setUpper((Object)duration);
                break;
            }
            case ">": {
                interval.setLowerIncluded(false);
            }
            case ">=": {
                interval.setUpperUnbounded(true);
                interval.setLower((Object)duration);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected operator: " + context.relop().getText());
            }
        }
        interval.fixUnboundedIncluded();
        return interval;
    }

    private void parseDuration(CDuration result, AdlParser.Duration_valueContext durationValueContext) {
        TemporalAmount duration = DateTimeParsers.parseDurationValue((String)durationValueContext.getText());
        Interval constraint = new Interval();
        constraint.setLower((Object)duration);
        constraint.setUpper((Object)duration);
        result.addConstraint((Interval<TemporalAmount>)constraint);
    }

    public CDateTime parseCDateTime(AdlParser.C_date_timeContext context) {
        AdlParser.Date_time_interval_valueContext intervalContext;
        AdlParser.Date_time_list_valueContext datetimeListValueContext;
        AdlParser.Date_time_valueContext datetimeValueContext;
        CDateTime result = new CDateTime();
        if (context.DATE_TIME_CONSTRAINT_PATTERN() != null) {
            result.setPatternConstraint(context.DATE_TIME_CONSTRAINT_PATTERN().getText());
        }
        if (context.assumed_date_time_value() != null) {
            result.setAssumedValue(DateTimeParsers.parseDateTimeValue((String)context.assumed_date_time_value().date_time_value().getText()));
        }
        if ((datetimeValueContext = context.date_time_value()) != null) {
            this.parseDateTime(result, datetimeValueContext);
        }
        if ((datetimeListValueContext = context.date_time_list_value()) != null) {
            for (AdlParser.Date_time_valueContext datetimeValueContext1 : datetimeListValueContext.date_time_value()) {
                this.parseDateTime(result, datetimeValueContext1);
            }
        }
        if ((intervalContext = context.date_time_interval_value()) != null) {
            result.addConstraint(this.parseDateTimeInterval(intervalContext));
        }
        if (context.date_time_interval_list_value() != null) {
            for (AdlParser.Date_time_interval_valueContext intervalListContext : context.date_time_interval_list_value().date_time_interval_value()) {
                result.addConstraint(this.parseDateTimeInterval(intervalListContext));
            }
        }
        return result;
    }

    private Interval<TemporalAccessor> parseDateTimeInterval(AdlParser.Date_time_interval_valueContext context) {
        Interval interval = null;
        if (context.relop() != null) {
            interval = this.parseRelOpDateTimeInterval(context);
        } else {
            interval = new Interval();
            if (context.date_time_value().size() == 1) {
                interval.setLower((Object)DateTimeParsers.parseDateTimeValue((String)context.date_time_value(0).getText()));
                interval.setUpper((Object)((TemporalAccessor)interval.getLower()));
            } else {
                interval.setLower((Object)DateTimeParsers.parseDateTimeValue((String)context.date_time_value(0).getText()));
                interval.setUpper((Object)DateTimeParsers.parseDateTimeValue((String)context.date_time_value(1).getText()));
            }
            if (context.SYM_GT() != null) {
                interval.setLowerIncluded(false);
            }
            if (context.SYM_LT() != null) {
                interval.setUpperIncluded(false);
            }
        }
        return interval;
    }

    private Interval<TemporalAccessor> parseRelOpDateTimeInterval(AdlParser.Date_time_interval_valueContext context) {
        Interval interval = new Interval();
        TemporalAccessor datetime = DateTimeParsers.parseDateTimeValue((String)context.date_time_value(0).getText());
        switch (context.relop().getText()) {
            case "<": {
                interval.setUpperIncluded(false);
            }
            case "<=": {
                interval.setLowerUnbounded(true);
                interval.setUpper((Object)datetime);
                break;
            }
            case ">": {
                interval.setLowerIncluded(false);
            }
            case ">=": {
                interval.setUpperUnbounded(true);
                interval.setLower((Object)datetime);
            }
        }
        interval.fixUnboundedIncluded();
        return interval;
    }

    private void parseDateTime(CDateTime result, AdlParser.Date_time_valueContext datetimeValueContext) {
        TemporalAccessor datetime = DateTimeParsers.parseDateTimeValue((String)datetimeValueContext.getText());
        Interval constraint = new Interval();
        constraint.setLower((Object)datetime);
        constraint.setUpper((Object)datetime);
        result.addConstraint((Interval<TemporalAccessor>)constraint);
    }

    public CTime parseCTime(AdlParser.C_timeContext context) {
        AdlParser.Time_interval_valueContext intervalContext;
        AdlParser.Time_list_valueContext timeListValueContext;
        AdlParser.Time_valueContext timeValueContext;
        CTime result = new CTime();
        if (context.TIME_CONSTRAINT_PATTERN() != null) {
            result.setPatternConstraint(context.TIME_CONSTRAINT_PATTERN().getText());
        }
        if (context.assumed_time_value() != null) {
            result.setAssumedValue(DateTimeParsers.parseTimeValue((String)context.assumed_time_value().time_value().getText()));
        }
        if ((timeValueContext = context.time_value()) != null) {
            this.parseTime(result, timeValueContext);
        }
        if ((timeListValueContext = context.time_list_value()) != null) {
            for (AdlParser.Time_valueContext timeValueContext1 : timeListValueContext.time_value()) {
                this.parseTime(result, timeValueContext1);
            }
        }
        if ((intervalContext = context.time_interval_value()) != null) {
            result.addConstraint(this.parseTimeInterval(intervalContext));
        }
        if (context.time_interval_list_value() != null) {
            for (AdlParser.Time_interval_valueContext intervalListContext : context.time_interval_list_value().time_interval_value()) {
                result.addConstraint(this.parseTimeInterval(intervalListContext));
            }
        }
        return result;
    }

    private Interval<TemporalAccessor> parseTimeInterval(AdlParser.Time_interval_valueContext context) {
        Interval interval = null;
        if (context.relop() != null) {
            interval = this.parseRelOpTimeInterval(context);
        } else {
            interval = new Interval();
            if (context.time_value().size() == 1) {
                interval.setLower((Object)DateTimeParsers.parseTimeValue((String)context.time_value(0).getText()));
                interval.setUpper((Object)((TemporalAccessor)interval.getLower()));
            } else {
                interval.setLower((Object)DateTimeParsers.parseTimeValue((String)context.time_value(0).getText()));
                interval.setUpper((Object)DateTimeParsers.parseTimeValue((String)context.time_value(1).getText()));
            }
            if (context.SYM_GT() != null) {
                interval.setLowerIncluded(false);
            }
            if (context.SYM_LT() != null) {
                interval.setUpperIncluded(false);
            }
        }
        return interval;
    }

    private Interval<TemporalAccessor> parseRelOpTimeInterval(AdlParser.Time_interval_valueContext context) {
        Interval interval = new Interval();
        TemporalAccessor datetime = DateTimeParsers.parseTimeValue((String)context.time_value(0).getText());
        switch (context.relop().getText()) {
            case "<": {
                interval.setUpperIncluded(false);
            }
            case "<=": {
                interval.setLowerUnbounded(true);
                interval.setUpper((Object)datetime);
                break;
            }
            case ">": {
                interval.setLowerIncluded(false);
            }
            case ">=": {
                interval.setUpperUnbounded(true);
                interval.setLower((Object)datetime);
            }
        }
        interval.fixUnboundedIncluded();
        return interval;
    }

    private void parseTime(CTime result, AdlParser.Time_valueContext context) {
        TemporalAccessor datetime = DateTimeParsers.parseTimeValue((String)context.getText());
        Interval constraint = new Interval();
        constraint.setLower((Object)datetime);
        constraint.setUpper((Object)datetime);
        result.addConstraint((Interval<TemporalAccessor>)constraint);
    }

    public CDate parseCDate(AdlParser.C_dateContext context) {
        AdlParser.Date_interval_valueContext intervalContext;
        AdlParser.Date_list_valueContext durationListValueContext;
        AdlParser.Date_valueContext durationValueContext;
        CDate result = new CDate();
        if (context.DATE_CONSTRAINT_PATTERN() != null) {
            result.setPatternConstraint(context.DATE_CONSTRAINT_PATTERN().getText());
        }
        if (context.assumed_date_value() != null) {
            result.setAssumedValue(DateTimeParsers.parseDateValue((String)context.assumed_date_value().date_value().getText()));
        }
        if ((durationValueContext = context.date_value()) != null) {
            this.parseDate(result, durationValueContext);
        }
        if ((durationListValueContext = context.date_list_value()) != null) {
            for (AdlParser.Date_valueContext durationValueContext1 : durationListValueContext.date_value()) {
                this.parseDate(result, durationValueContext1);
            }
        }
        if ((intervalContext = context.date_interval_value()) != null) {
            result.addConstraint(this.parseDateInterval(intervalContext));
        }
        if (context.date_interval_list_value() != null) {
            for (AdlParser.Date_interval_valueContext intervalListContext : context.date_interval_list_value().date_interval_value()) {
                result.addConstraint(this.parseDateInterval(intervalListContext));
            }
        }
        return result;
    }

    private Interval<Temporal> parseDateInterval(AdlParser.Date_interval_valueContext context) {
        Interval interval = null;
        if (context.relop() != null) {
            interval = this.parseRelOpDateInterval(context);
        } else {
            interval = new Interval();
            if (context.date_value().size() == 1) {
                interval.setLower((Object)DateTimeParsers.parseDateValue((String)context.date_value(0).getText()));
                interval.setUpper((Object)((Temporal)interval.getLower()));
            } else {
                interval.setLower((Object)DateTimeParsers.parseDateValue((String)context.date_value(0).getText()));
                interval.setUpper((Object)DateTimeParsers.parseDateValue((String)context.date_value(1).getText()));
            }
            if (context.SYM_GT() != null) {
                interval.setLowerIncluded(false);
            }
            if (context.SYM_LT() != null) {
                interval.setUpperIncluded(false);
            }
        }
        return interval;
    }

    private Interval<Temporal> parseRelOpDateInterval(AdlParser.Date_interval_valueContext context) {
        Interval interval = new Interval();
        Temporal duration = DateTimeParsers.parseDateValue((String)((AdlParser.Date_valueContext)context.date_value().get(0)).getText());
        switch (context.relop().getText()) {
            case "<": {
                interval.setUpperIncluded(false);
            }
            case "<=": {
                interval.setLowerUnbounded(true);
                interval.setUpper((Object)duration);
                break;
            }
            case ">": {
                interval.setLowerIncluded(false);
            }
            case ">=": {
                interval.setUpperUnbounded(true);
                interval.setLower((Object)duration);
            }
        }
        interval.fixUnboundedIncluded();
        return interval;
    }

    private void parseDate(CDate result, AdlParser.Date_valueContext durationValueContext) {
        Temporal duration = DateTimeParsers.parseDateValue((String)durationValueContext.getText());
        Interval constraint = new Interval();
        constraint.setLower((Object)duration);
        constraint.setUpper((Object)duration);
        result.addConstraint((Interval<Temporal>)constraint);
    }
}

