/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.aom;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nedap.archie.aom.ArchetypeHRID;
import com.nedap.archie.aom.ArchetypeModelObject;
import com.nedap.archie.aom.AuthoredResource;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.RulesSection;
import com.nedap.archie.aom.primitives.CTerminologyCode;
import com.nedap.archie.aom.rmoverlay.RmAttributeVisibility;
import com.nedap.archie.aom.rmoverlay.RmOverlay;
import com.nedap.archie.aom.terminology.ArchetypeTerm;
import com.nedap.archie.aom.terminology.ArchetypeTerminology;
import com.nedap.archie.aom.terminology.ValueSet;
import com.nedap.archie.aom.utils.AOMUtils;
import com.nedap.archie.aom.utils.ArchetypeParsePostProcesser;
import com.nedap.archie.query.AOMPathQuery;
import com.nedap.archie.rminfo.RMProperty;
import com.nedap.archie.xml.adapters.ArchetypeTerminologyAdapter;
import com.nedap.archie.xml.adapters.RMOverlayXmlAdapter;
import com.nedap.archie.xml.adapters.StringDictionaryUtil;
import com.nedap.archie.xml.types.StringDictionaryItem;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ARCHETYPE", propOrder={"archetypeId", "parentArchetypeId", "definition", "terminology", "rules", "buildUid", "rmRelease", "generated", "xmlOtherMetaData", "rmOverlay"})
public class Archetype
extends AuthoredResource {
    @XmlElement(name="parent_archetype_id")
    @Nullable
    private String parentArchetypeId;
    @XmlAttribute(name="is_differential")
    @RMProperty(value="is_differential")
    private boolean differential = false;
    @XmlElement(name="archetype_id")
    private ArchetypeHRID archetypeId;
    private CComplexObject definition;
    @XmlJavaTypeAdapter(value=ArchetypeTerminologyAdapter.class)
    private ArchetypeTerminology terminology;
    @Nullable
    private RulesSection rules = null;
    @XmlAttribute(name="adl_version")
    @Nullable
    private String adlVersion;
    @XmlElement(name="build_uid")
    private String buildUid;
    @XmlAttribute(name="rm_release")
    private String rmRelease;
    @XmlAttribute(name="is_generated")
    @RMProperty(value="is_generated")
    private Boolean generated = false;
    @XmlTransient
    private Map<String, String> otherMetaData = new LinkedHashMap<String, String>();
    @XmlElement(name="other_meta_data")
    @JsonIgnore
    private List<StringDictionaryItem> xmlOtherMetaData;
    @XmlElement(name="rm_overlay")
    @XmlJavaTypeAdapter(value=RMOverlayXmlAdapter.class)
    private RmOverlay rmOverlay;

    public void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        if (this.xmlOtherMetaData != null) {
            this.otherMetaData = StringDictionaryUtil.convertStringDictionaryListToStringMap(this.xmlOtherMetaData);
        }
    }

    public boolean beforeMarshal(Marshaller marshaller) {
        this.xmlOtherMetaData = this.otherMetaData == null ? null : StringDictionaryUtil.convertStringMapIntoStringDictionaryList(this.otherMetaData);
        return true;
    }

    public String getParentArchetypeId() {
        return this.parentArchetypeId;
    }

    public void setParentArchetypeId(String parentArchetypeId) {
        this.parentArchetypeId = parentArchetypeId;
    }

    @JsonAlias(value={"is_differential"})
    public boolean isDifferential() {
        return this.differential;
    }

    public void setDifferential(boolean differential) {
        this.differential = differential;
    }

    public ArchetypeHRID getArchetypeId() {
        return this.archetypeId;
    }

    public void setArchetypeId(ArchetypeHRID archetypeId) {
        this.archetypeId = archetypeId;
    }

    public CComplexObject getDefinition() {
        return this.definition;
    }

    public void setDefinition(CComplexObject definition) {
        definition.setArchetype(this);
        this.definition = definition;
    }

    public RulesSection getRules() {
        return this.rules;
    }

    public void setRules(RulesSection rules) {
        this.rules = rules;
    }

    public ArchetypeTerminology getTerminology() {
        return this.terminology;
    }

    public void setTerminology(ArchetypeTerminology terminology) {
        this.terminology = terminology;
        terminology.setOwnerArchetype(this);
    }

    public String getAdlVersion() {
        return this.adlVersion;
    }

    public void setAdlVersion(String adlVersion) {
        this.adlVersion = adlVersion;
    }

    public String getBuildUid() {
        return this.buildUid;
    }

    public void setBuildUid(String buildUid) {
        this.buildUid = buildUid;
    }

    public String getRmRelease() {
        return this.rmRelease;
    }

    public void setRmRelease(String rmRelease) {
        this.rmRelease = rmRelease;
    }

    public Boolean getGenerated() {
        return this.generated;
    }

    public void setGenerated(Boolean generated) {
        this.generated = generated;
    }

    public Map<String, String> getOtherMetaData() {
        return this.otherMetaData;
    }

    public void setOtherMetaData(Map<String, String> otherMetaData) {
        this.otherMetaData = otherMetaData;
    }

    public void addOtherMetadata(String text, String value) {
        if (value != null) {
            this.otherMetaData.put(text, value);
        }
    }

    public ArchetypeTerm getTerm(CObject object, String language) {
        ArchetypeTerminology terminology = this.getTerminology();
        return terminology == null ? null : terminology.getTermDefinition(language, object.getNodeId());
    }

    public ArchetypeTerm getTerm(CObject object, String code, String language) {
        return this.getTerminology().getTermDefinition(language, code);
    }

    public ArchetypeTerminology getTerminology(CObject object) {
        return this.getTerminology();
    }

    @Override
    public Archetype clone() {
        Archetype result = (Archetype)super.clone();
        ArchetypeParsePostProcesser.fixArchetype(result);
        return result;
    }

    public <T extends ArchetypeModelObject> T itemAtPath(String path) {
        return new AOMPathQuery(path).find(this.getDefinition());
    }

    public List<ArchetypeModelObject> itemsAtPath(String path) {
        return new AOMPathQuery(path).findList(this.getDefinition());
    }

    public boolean hasPath(String path) {
        return !this.itemsAtPath(path).isEmpty();
    }

    public String toString() {
        return "archetype: " + this.getArchetypeId();
    }

    public boolean isSpecialized() {
        return this.parentArchetypeId != null;
    }

    @JsonIgnore
    public int specializationDepth() {
        return AOMUtils.getSpecializationDepthFromCode(this.definition.getNodeId());
    }

    @JsonIgnore
    public Set<String> getAllUsedCodes() {
        Stack<CObject> workList = new Stack<CObject>();
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        workList.add(this.definition);
        while (!workList.isEmpty()) {
            CObject cObject = (CObject)workList.pop();
            if (!Objects.equals(cObject.getNodeId(), "id9999") && cObject.getNodeId() != null) {
                result.add(cObject.getNodeId());
            }
            if (cObject instanceof CTerminologyCode) {
                CTerminologyCode terminologyCode = (CTerminologyCode)cObject;
                result.addAll(terminologyCode.getValueSetExpanded());
                if (!terminologyCode.getConstraint().isEmpty()) {
                    result.add(terminologyCode.getConstraint().get(0));
                }
            }
            for (CAttribute attribute : cObject.getAttributes()) {
                workList.addAll(attribute.getChildren());
            }
        }
        if (this.terminology != null && this.terminology.getValueSets() != null) {
            for (ValueSet set : this.terminology.getValueSets().values()) {
                result.add(set.getId());
                for (String code : set.getMembers()) {
                    result.add(code);
                }
            }
        }
        if (this.rmOverlay != null && this.rmOverlay.getRmVisibility() != null) {
            for (RmAttributeVisibility value : this.rmOverlay.getRmVisibility().values()) {
                if (value.getAlias() == null) continue;
                result.add(value.getAlias().getCodeString());
            }
        }
        return result;
    }

    @JsonIgnore
    public Set<String> getUsedIdCodes() {
        return this.getAllUsedCodes().stream().filter(code -> AOMUtils.isIdCode(code)).collect(Collectors.toSet());
    }

    @JsonIgnore
    public Set<String> getUsedValueCodes() {
        return this.getAllUsedCodes().stream().filter(code -> AOMUtils.isValueCode(code)).collect(Collectors.toSet());
    }

    @JsonIgnore
    public Set<String> getUsedValueSetCodes() {
        return this.getAllUsedCodes().stream().filter(code -> AOMUtils.isValidValueSetCode(code)).collect(Collectors.toSet());
    }

    private String generateNextCode(String prefix, Set<String> usedCodes) {
        int specializationDepth = this.specializationDepth();
        int maximumIdCode = AOMUtils.getMaximumIdCode(specializationDepth, usedCodes);
        return prefix + this.generateSpecializationDepthCodePrefix(this.specializationDepth()) + (maximumIdCode + 1);
    }

    public String generateNextIdCode() {
        return this.generateNextCode("id", this.getAllUsedCodes());
    }

    public String generateNextValueCode() {
        return this.generateNextCode("at", this.getAllUsedCodes());
    }

    public String generateNextValueSetCode() {
        return this.generateNextCode("ac", this.getAllUsedCodes());
    }

    private String generateSpecializationDepthCodePrefix(int specializationDepth) {
        String prefix = "";
        for (int i = 0; i < specializationDepth; ++i) {
            prefix = prefix + "0.";
        }
        return prefix;
    }

    public String generateNextSpecializedIdCode(String nodeId) {
        int specializationDepth = this.specializationDepth();
        int nodeIdSpecializationDepth = AOMUtils.getSpecializationDepthFromCode(nodeId);
        if (nodeIdSpecializationDepth >= specializationDepth) {
            throw new IllegalArgumentException("cannot specialize a node id at the same or higher specialization depth as the archetype");
        }
        int maximumIdCode = AOMUtils.getMaximumIdCode(specializationDepth, nodeId, this.getAllUsedCodes());
        return nodeId + '.' + this.generateSpecializationDepthCodePrefix(specializationDepth - nodeIdSpecializationDepth - 1) + (maximumIdCode + 1);
    }

    public RmOverlay getRmOverlay() {
        return this.rmOverlay;
    }

    public void setRmOverlay(RmOverlay rmOverlay) {
        this.rmOverlay = rmOverlay;
    }
}

