/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.aom;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.ArchetypeConstraint;
import com.nedap.archie.aom.ArchetypeModelObject;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CAttributeTuple;
import com.nedap.archie.aom.CDefinedObject;
import com.nedap.archie.base.OpenEHRBase;
import com.nedap.archie.query.AOMPathQuery;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@JsonPropertyOrder(value={"@type", "rm_type_name", "node_id", "path", "logical_path", "term", "required", "allowed", "any_allowed", "occurrences", "root_node", "attributes", "attribute_tuples"})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="C_COMPLEX_OBJECT", propOrder={"attributes", "attributeTuples"})
public class CComplexObject
extends CDefinedObject<OpenEHRBase> {
    @Nullable
    private List<CAttribute> attributes = new ArrayList<CAttribute>();
    @XmlElement(name="attributeTuples")
    @Nullable
    private List<CAttributeTuple> attributeTuples = new ArrayList<CAttributeTuple>();
    @JsonIgnore
    protected transient Archetype archetype;

    public boolean isAnyAllowed() {
        return this.attributes == null || this.attributes.isEmpty();
    }

    @Override
    public void setParent(ArchetypeConstraint parent) {
        super.setParent(parent);
        this.archetype = null;
    }

    @Override
    public boolean isRootNode() {
        return this.getParent() == null && this.archetype != null;
    }

    @Override
    @JsonIgnore
    public Archetype getArchetype() {
        if (this.archetype == null) {
            CAttribute parent = this.getParent();
            return parent == null ? null : parent.getArchetype();
        }
        return this.archetype;
    }

    public void setArchetype(Archetype archetype) {
        this.archetype = archetype;
    }

    @Override
    public String toString() {
        return "CComplexObject: " + this.getRmTypeName() + "[" + this.getNodeId() + "]";
    }

    public <T extends ArchetypeModelObject> T itemAtPath(String path) {
        return new AOMPathQuery(path).find(this);
    }

    @Override
    public CAttribute getAttribute(String nameOrDifferentialpath) {
        for (CAttribute attribute : this.attributes) {
            if (attribute.getRmAttributeName().equals(nameOrDifferentialpath) && attribute.getDifferentialPath() == null) {
                return attribute;
            }
            if (attribute.getDifferentialPath() == null || !attribute.getDifferentialPath().equals(nameOrDifferentialpath)) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public List<CAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<CAttribute> attributes) {
        if (attributes == null) {
            this.attributes = new ArrayList<CAttribute>();
        } else {
            this.attributes = attributes;
            for (CAttribute attribute : attributes) {
                attribute.setParent(this);
            }
        }
    }

    public void addAttribute(CAttribute attribute) {
        attribute.setParent(this);
        this.attributes.add(attribute);
    }

    public void removeAttribute(CAttribute attribute) {
        this.removeAttribute(attribute, false);
    }

    private void removeAttribute(CAttribute attribute, boolean allowRemovingTupleMembers) {
        int indexOfAttribute = -1;
        for (int i = 0; i < this.attributes.size(); ++i) {
            CAttribute existingAttribute = this.attributes.get(i);
            if (existingAttribute.getDifferentialPath() != null) {
                if (!existingAttribute.getDifferentialPath().equals(attribute.getDifferentialPath())) continue;
                indexOfAttribute = i;
                break;
            }
            if (!existingAttribute.getRmAttributeName().equals(attribute.getRmAttributeName())) continue;
            indexOfAttribute = i;
        }
        if (indexOfAttribute >= 0) {
            CAttribute foundAttribute = this.attributes.get(indexOfAttribute);
            if (!allowRemovingTupleMembers && foundAttribute.getSocParent() != null) {
                throw new IllegalArgumentException("cannot remove a tuple attribute with removeAttribute, remove the tuple attribute instead and rebuild tuple attributes.");
            }
            this.attributes.remove(indexOfAttribute);
        }
    }

    public List<CAttributeTuple> getAttributeTuples() {
        return this.attributeTuples;
    }

    public void setAttributeTuples(List<CAttributeTuple> attributeTuples) {
        this.attributeTuples = attributeTuples;
    }

    public void addAttributeTuple(CAttributeTuple tuple) {
        this.attributeTuples.add(tuple);
    }

    public void replaceAttribute(CAttribute newAttribute) {
        CAttribute oldAttribute = this.getAttribute(newAttribute.getRmAttributeName());
        if (oldAttribute != null) {
            int index = this.attributes.indexOf(oldAttribute);
            this.attributes.set(index, newAttribute);
            newAttribute.setParent(this);
        } else {
            this.addAttribute(newAttribute);
        }
    }

    @Override
    public boolean isLeaf() {
        return !(this.attributes != null && !this.attributes.isEmpty() || this.attributeTuples != null && !this.attributeTuples.isEmpty());
    }

    public void removeAttributeTuple(List<String> parameterMemberNames) {
        int index = this.getIndexOfMatchingAttributeTuple(parameterMemberNames);
        if (index >= 0) {
            CAttributeTuple tuple = this.attributeTuples.get(index);
            this.attributeTuples.remove(index);
            for (CAttribute attribute : tuple.getMembers()) {
                this.removeAttribute(attribute, true);
            }
        }
    }

    public int getIndexOfMatchingAttributeTuple(List<String> parameterMemberNames) {
        for (int i = 0; i < this.getAttributeTuples().size(); ++i) {
            CAttributeTuple cAttributeTuple = this.getAttributeTuples().get(i);
            cAttributeTuple.getMemberNames();
            List<String> memberNames = cAttributeTuple.getMemberNames();
            if (!memberNames.equals(parameterMemberNames)) continue;
            return i;
        }
        return -1;
    }
}

