/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.aom;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.nedap.archie.aom.CDefinedObject;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.utils.ConformanceCheckResult;
import com.nedap.archie.archetypevalidator.ErrorType;
import com.nedap.archie.rminfo.ArchieModelNamingStrategy;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rminfo.RMProperty;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.openehr.utils.message.I18n;

@XmlType(name="C_PRIMITIVE_OBJECT")
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class CPrimitiveObject<Constraint, ValueType>
extends CDefinedObject<ValueType> {
    public static final String PRIMITIVE_NODE_ID_VALUE = "id9999";
    @Nullable
    private Boolean enumeratedTypeConstraint;

    public abstract ValueType getAssumedValue();

    public abstract void setAssumedValue(ValueType var1);

    public abstract List<Constraint> getConstraint();

    public abstract void setConstraint(List<Constraint> var1);

    public abstract void addConstraint(Constraint var1);

    @JsonAlias(value={"is_enumerated_type_constraint"})
    @RMProperty(value="is_enumerated_type_constraint")
    public Boolean getEnumeratedTypeConstraint() {
        return this.enumeratedTypeConstraint;
    }

    public void setEnumeratedTypeConstraint(Boolean enumeratedTypeConstraint) {
        this.enumeratedTypeConstraint = enumeratedTypeConstraint;
    }

    @Override
    public String getNodeId() {
        return PRIMITIVE_NODE_ID_VALUE;
    }

    @Override
    public void setNodeId(String nodeId) {
        if (!nodeId.equals(PRIMITIVE_NODE_ID_VALUE)) {
            throw new UnsupportedOperationException("Cannot set node id on a CPrimitiveObject");
        }
    }

    @Deprecated
    public boolean isValidValue(ValueType value) {
        if (this.getConstraint().isEmpty()) {
            return true;
        }
        for (Constraint constraint : this.getConstraint()) {
            if (!Objects.equals(constraint, value)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean isValidValue(ModelInfoLookup lookup, Object value) {
        Object convertedValue = lookup.convertToConstraintObject(value, this);
        return this.isValidValue(convertedValue);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("{");
        boolean first = true;
        for (Constraint constraint : this.getConstraint()) {
            if (!first) {
                result.append(", ");
            }
            first = false;
            if (constraint instanceof String) {
                result.append('\"');
                result.append(((String)constraint).replace("\"", "\\\""));
                result.append('\"');
                continue;
            }
            result.append(constraint.toString());
        }
        result.append("}");
        return result.toString();
    }

    @Override
    public ConformanceCheckResult cConformsTo(CObject other, BiFunction<String, String, Boolean> rmTypesConformant) {
        if (other instanceof CPrimitiveObject && other.getClass().equals(this.getClass())) {
            if (!this.occurrencesConformsTo(other)) {
                return ConformanceCheckResult.fails(ErrorType.VSONCO, I18n.t((String)"Occurrences {0} does not conform to {1}", (Object[])new Object[]{this.getOccurrences(), other.getOccurrences()}));
            }
            if (!this.getRmTypeName().equalsIgnoreCase(other.getRmTypeName())) {
                return ConformanceCheckResult.fails(ErrorType.VSONCT, I18n.t((String)"type name {0} does not conform to {1}", (Object[])new Object[]{this.getRmTypeName(), other.getRmTypeName()}));
            }
        } else {
            if (other == null) {
                return ConformanceCheckResult.fails(ErrorType.VPOV, I18n.t((String)"The primitive object of type {0} does not conform null", (Object[])new Object[]{this.getClass().getSimpleName()}));
            }
            return ConformanceCheckResult.fails(ErrorType.VPOV, I18n.t((String)"The primitive object of type {0} does not conform to non-primitive object with type {1}", (Object[])new Object[]{this.getClass().getSimpleName(), other.getClass().getSimpleName()}));
        }
        return ConformanceCheckResult.conforms();
    }

    public String constrainedTypename() {
        return ArchieModelNamingStrategy.snakeCaseStrategy.translate(this.getClass().getSimpleName().substring(1));
    }

    @Override
    public String getRmTypeName() {
        return this.constrainedTypename();
    }

    public boolean hasAssumedValue() {
        return this.getAssumedValue() != null;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }
}

