/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.aom;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nedap.archie.aom.AuthoredArchetype;
import com.nedap.archie.aom.CArchetypeRoot;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.terminology.ArchetypeTerm;
import com.nedap.archie.aom.terminology.ArchetypeTerminology;
import com.nedap.archie.aom.utils.AOMUtils;
import com.nedap.archie.paths.PathSegment;
import com.nedap.archie.xml.adapters.ArchetypeTerminologyAdapter;
import com.nedap.archie.xml.types.XmlArchetypeTerminology;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="OPERATIONAL_TEMPLATE")
@XmlRootElement(name="operational_template")
public class OperationalTemplate
extends AuthoredArchetype {
    @XmlTransient
    private Map<String, ArchetypeTerminology> terminologyExtracts = new ConcurrentHashMap<String, ArchetypeTerminology>();
    @XmlTransient
    private Map<String, ArchetypeTerminology> componentTerminologies = new ConcurrentHashMap<String, ArchetypeTerminology>();
    @XmlElement(name="terminology_extracts")
    @JsonIgnore
    private List<XmlArchetypeTerminology> xmlTerminologyExtracts;
    @XmlElement(name="component_terminologies")
    @JsonIgnore
    private List<XmlArchetypeTerminology> xmlComponentTerminologies;

    @Override
    public void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        ArchetypeTerminology converted;
        ArchetypeTerminologyAdapter archetypeTerminologyAdapter;
        super.afterUnmarshal(unmarshaller, parent);
        if (this.xmlTerminologyExtracts != null) {
            archetypeTerminologyAdapter = new ArchetypeTerminologyAdapter();
            for (XmlArchetypeTerminology terminology : this.xmlTerminologyExtracts) {
                try {
                    converted = archetypeTerminologyAdapter.unmarshal(terminology);
                    this.terminologyExtracts.put(terminology.getArchetypeId(), converted);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.xmlComponentTerminologies != null) {
            archetypeTerminologyAdapter = new ArchetypeTerminologyAdapter();
            for (XmlArchetypeTerminology terminology : this.xmlComponentTerminologies) {
                try {
                    converted = archetypeTerminologyAdapter.unmarshal(terminology);
                    this.componentTerminologies.put(terminology.getArchetypeId(), converted);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public boolean beforeMarshal(Marshaller marshaller) {
        XmlArchetypeTerminology converted;
        ArchetypeTerminologyAdapter archetypeTerminologyAdapter;
        super.beforeMarshal(marshaller);
        if (this.terminologyExtracts != null && !this.terminologyExtracts.isEmpty()) {
            archetypeTerminologyAdapter = new ArchetypeTerminologyAdapter();
            this.xmlTerminologyExtracts = new ArrayList<XmlArchetypeTerminology>();
            for (Map.Entry<String, ArchetypeTerminology> terminology : this.terminologyExtracts.entrySet()) {
                converted = archetypeTerminologyAdapter.marshal(terminology.getValue());
                converted.setArchetypeId(terminology.getKey());
                this.xmlTerminologyExtracts.add(converted);
            }
        } else {
            this.xmlTerminologyExtracts = null;
        }
        if (this.componentTerminologies != null && !this.componentTerminologies.isEmpty()) {
            archetypeTerminologyAdapter = new ArchetypeTerminologyAdapter();
            this.xmlComponentTerminologies = new ArrayList<XmlArchetypeTerminology>();
            for (Map.Entry<String, ArchetypeTerminology> terminology : this.componentTerminologies.entrySet()) {
                converted = archetypeTerminologyAdapter.marshal(terminology.getValue());
                converted.setArchetypeId(terminology.getKey());
                this.xmlComponentTerminologies.add(converted);
            }
        } else {
            this.xmlComponentTerminologies = null;
        }
        return true;
    }

    public Map<String, ArchetypeTerminology> getTerminologyExtracts() {
        return this.terminologyExtracts;
    }

    public void setTerminologyExtracts(Map<String, ArchetypeTerminology> terminologyExtracts) {
        this.terminologyExtracts = terminologyExtracts;
    }

    public void addTerminologyExtract(String nodeId, ArchetypeTerminology terminology) {
        this.terminologyExtracts.put(nodeId, terminology);
    }

    public Map<String, ArchetypeTerminology> getComponentTerminologies() {
        return this.componentTerminologies;
    }

    public void setComponentTerminologies(Map<String, ArchetypeTerminology> componentTerminologies) {
        this.componentTerminologies = componentTerminologies;
    }

    public void addComponentTerminology(String nodeId, ArchetypeTerminology terminology) {
        this.componentTerminologies.put(nodeId, terminology);
    }

    private String getChildArchetypeId(CObject object, boolean stripLastPartOfPath) {
        List<PathSegment> pathSegments = object.getPathSegments();
        Collections.reverse(pathSegments);
        if (stripLastPartOfPath && pathSegments.size() > 1) {
            pathSegments = pathSegments.subList(1, pathSegments.size());
        } else if (stripLastPartOfPath) {
            return null;
        }
        for (PathSegment segment : pathSegments) {
            if (segment.hasArchetypeRef()) {
                return segment.getNodeId();
            }
            if (segment.getArchetypeRef() == null) continue;
            return segment.getArchetypeRef();
        }
        return null;
    }

    @Override
    public ArchetypeTerm getTerm(CObject object, String language) {
        return this.getTerm(object, object.getNodeId(), language);
    }

    @Override
    public ArchetypeTerm getTerm(CObject object, String code, String language) {
        boolean stripLastPartOfPath = object instanceof CArchetypeRoot && AOMUtils.isIdCode(code);
        ArchetypeTerm term = this.getTermInternal(object, code, language, stripLastPartOfPath);
        if (stripLastPartOfPath && term == null) {
            term = this.getTermInternal(object, code, language, false);
        }
        return term;
    }

    private ArchetypeTerm getTermInternal(CObject object, String code, String language, boolean stripLastPartOfPath) {
        String archetypeId = this.getChildArchetypeId(object, stripLastPartOfPath);
        if (archetypeId == null) {
            return super.getTerm(object, code, language);
        }
        ArchetypeTerminology terminology = this.getComponentTerminologies().get(archetypeId);
        if (terminology != null) {
            ArchetypeTerm term = terminology.getTermDefinition(language, code);
            if (term == null && object instanceof CArchetypeRoot) {
                return terminology.getTermDefinition(language, ((CArchetypeRoot)object).getArchetypeRef());
            }
            return term;
        }
        throw new IllegalStateException("Expected an archetype terminology for archetype id " + archetypeId);
    }

    @Override
    public ArchetypeTerminology getTerminology(CObject object) {
        String archetypeId = this.getChildArchetypeId(object, false);
        if (archetypeId == null) {
            return this.getTerminology();
        }
        return this.getComponentTerminologies().get(archetypeId);
    }
}

