/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.aom.primitives;

import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.utils.ConformanceCheckResult;
import com.nedap.archie.archetypevalidator.ErrorType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.openehr.utils.message.I18n;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="C_BOOLEAN")
public class CBoolean
extends CPrimitiveObject<Boolean, Boolean> {
    @XmlElement(name="assumed_value")
    @Nullable
    private Boolean assumedValue;
    @Nullable
    private List<Boolean> constraint = new ArrayList<Boolean>();

    @Override
    public Boolean getAssumedValue() {
        return this.assumedValue;
    }

    @Override
    public void setAssumedValue(Boolean assumedValue) {
        this.assumedValue = assumedValue;
    }

    @Override
    public List<Boolean> getConstraint() {
        return this.constraint;
    }

    @Override
    public void setConstraint(List<Boolean> constraint) {
        this.constraint = constraint;
    }

    @Override
    public void addConstraint(Boolean constraint) {
        this.constraint.add(constraint);
    }

    @Override
    public ConformanceCheckResult cConformsTo(CObject other, BiFunction<String, String, Boolean> rmTypeNamesConformant) {
        ConformanceCheckResult superResult = super.cConformsTo(other, rmTypeNamesConformant);
        if (!superResult.doesConform()) {
            return superResult;
        }
        CBoolean otherBoolean = (CBoolean)other;
        if (otherBoolean.constraint.isEmpty()) {
            return ConformanceCheckResult.conforms();
        }
        if (this.constraint.size() > otherBoolean.constraint.size()) {
            return ConformanceCheckResult.fails(ErrorType.VPOV, I18n.t((String)"A specialised boolean constraint cannot include the same number of more constraints than its parent", (Object[])new Object[0]));
        }
        for (Boolean constraint : this.constraint) {
            if (otherBoolean.constraint.contains(constraint)) continue;
            return ConformanceCheckResult.fails(ErrorType.VPOV, I18n.t((String)"A specialised boolean constraint cannot add a constraint not in its parent", (Object[])new Object[0]));
        }
        return ConformanceCheckResult.conforms();
    }
}

