/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.aom.primitives;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nedap.archie.aom.primitives.COrdered;
import com.nedap.archie.base.Interval;
import java.beans.Transient;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="C_INTEGER")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CInteger
extends COrdered<Long> {
    @XmlElement(name="assumed_value")
    @Nullable
    private Long assumedValue;
    private List<Interval<Long>> constraint = new ArrayList<Interval<Long>>();

    @Override
    public Long getAssumedValue() {
        return this.assumedValue;
    }

    @Override
    public void setAssumedValue(Long assumedValue) {
        this.assumedValue = assumedValue;
    }

    @Override
    public List<Interval<Long>> getConstraint() {
        return this.constraint;
    }

    @Override
    public void setConstraint(List<Interval<Long>> constraint) {
        this.constraint = constraint;
    }

    @Override
    public void addConstraint(Interval<Long> constraint) {
        this.constraint.add(constraint);
    }

    @JsonIgnore
    @Transient
    public List<Long> getConstraintValues() {
        ArrayList<Long> result = new ArrayList<Long>();
        for (Interval<Long> singleConstraint : this.constraint) {
            if (singleConstraint.isLowerUnbounded() || singleConstraint.isUpperUnbounded()) {
                throw new RuntimeException("cannot get the constraint values of an unbounded Integer64 constraint");
            }
            long constraintLower = (Long)singleConstraint.getLower();
            if (!singleConstraint.isLowerIncluded()) {
                ++constraintLower;
            }
            long constraintUpper = (Long)singleConstraint.getUpper();
            if (singleConstraint.isUpperIncluded()) {
                ++constraintUpper;
            }
            for (long i = constraintLower; i < constraintUpper; ++i) {
                result.add(i);
            }
        }
        return result;
    }
}

