/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.aom.primitives;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nedap.archie.ArchieLanguageConfiguration;
import com.nedap.archie.ValidationConfiguration;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.primitives.ConstraintStatus;
import com.nedap.archie.aom.terminology.ArchetypeTerm;
import com.nedap.archie.aom.terminology.ArchetypeTerminology;
import com.nedap.archie.aom.terminology.TerminologyCodeWithArchetypeTerm;
import com.nedap.archie.aom.terminology.ValueSet;
import com.nedap.archie.aom.utils.AOMUtils;
import com.nedap.archie.aom.utils.ConformanceCheckResult;
import com.nedap.archie.archetypevalidator.ErrorType;
import com.nedap.archie.base.terminology.TerminologyCode;
import com.nedap.archie.terminology.OpenEHRTerminologyAccess;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.openehr.utils.message.I18n;

@XmlType(name="C_TERMINOLOGY_CODE")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CTerminologyCode
extends CPrimitiveObject<String, TerminologyCode> {
    @XmlElement(name="assumed_value")
    @Nullable
    private TerminologyCode assumedValue;
    private List<String> constraint = new ArrayList<String>();
    @Nullable
    private ConstraintStatus constraintStatus;

    @Override
    public TerminologyCode getAssumedValue() {
        return this.assumedValue;
    }

    @Override
    public void setAssumedValue(TerminologyCode assumedValue) {
        this.assumedValue = assumedValue;
    }

    @Override
    public List<String> getConstraint() {
        return this.constraint;
    }

    @Override
    public void setConstraint(List<String> constraint) {
        this.constraint = constraint;
    }

    @Override
    public void addConstraint(String constraint) {
        this.constraint.add(constraint);
    }

    public ConstraintStatus getConstraintStatus() {
        return this.constraintStatus;
    }

    public void setConstraintStatus(ConstraintStatus constraintStatus) {
        this.constraintStatus = constraintStatus;
    }

    @JsonIgnore
    public boolean isConstraintRequired() {
        return this.getEffectiveConstraintStatus() == ConstraintStatus.REQUIRED;
    }

    public ConstraintStatus getEffectiveConstraintStatus() {
        return this.constraintStatus == null ? ConstraintStatus.REQUIRED : this.constraintStatus;
    }

    @Override
    @Deprecated
    public boolean isValidValue(TerminologyCode value) {
        if (this.getConstraint().isEmpty()) {
            return true;
        }
        if (this.isConstraintRequired()) {
            List<String> values;
            if (value == null) {
                return false;
            }
            String terminologyId = value.getTerminologyId();
            if (terminologyId == null || terminologyId.equalsIgnoreCase("local") || AOMUtils.isValueSetCode(value.getTerminologyId())) {
                values = this.getValueSetExpanded();
            } else if (terminologyId.equalsIgnoreCase("openehr")) {
                values = this.getOpenEHRValueSetExpanded();
            } else {
                return !ValidationConfiguration.isFailOnUnknownTerminologyId();
            }
            if (values != null && !values.isEmpty()) {
                return value.getCodeString() != null && values.contains(value.getCodeString());
            }
        } else {
            return true;
        }
        return false;
    }

    public List<TerminologyCodeWithArchetypeTerm> getTerms() {
        ArrayList<TerminologyCodeWithArchetypeTerm> result = new ArrayList<TerminologyCodeWithArchetypeTerm>();
        Archetype archetype = this.getArchetype();
        if (archetype == null) {
            return result;
        }
        ArchetypeTerminology terminology = archetype.getTerminology(this);
        String language = ArchieLanguageConfiguration.getMeaningAndDescriptionLanguage();
        String defaultLanguage = ArchieLanguageConfiguration.getDefaultMeaningAndDescriptionLanguage();
        for (String constraint : this.getConstraint()) {
            ValueSet acValueSet;
            if (constraint.startsWith("at")) {
                ArchetypeTerm termDefinition = terminology.getTermDefinition(language, constraint);
                if (termDefinition == null) {
                    termDefinition = terminology.getTermDefinition(defaultLanguage, constraint);
                }
                if (termDefinition == null) continue;
                result.add(new TerminologyCodeWithArchetypeTerm(constraint, termDefinition));
                continue;
            }
            if (!constraint.startsWith("ac") || (acValueSet = terminology.getValueSets().get(constraint)) == null) continue;
            for (String atCode : acValueSet.getMembers()) {
                ArchetypeTerm termDefinition = terminology.getTermDefinition(language, atCode);
                if (termDefinition == null) {
                    termDefinition = terminology.getTermDefinition(defaultLanguage, atCode);
                }
                if (termDefinition == null) continue;
                result.add(new TerminologyCodeWithArchetypeTerm(atCode, termDefinition));
            }
        }
        return result;
    }

    private void setTerms(List<TerminologyCodeWithArchetypeTerm> terms) {
    }

    private ArchetypeTerminology getTerminology() {
        Archetype archetype = this.getArchetype();
        if (archetype != null) {
            return archetype.getTerminology(this);
        }
        return null;
    }

    @JsonIgnore
    public List<String> getValueSetExpanded() {
        ArrayList<String> result = new ArrayList<String>();
        ArchetypeTerminology terminology = this.getTerminology();
        for (String constraint : this.getConstraint()) {
            ValueSet acValueSet;
            if (constraint.startsWith("at")) {
                result.add(constraint);
                continue;
            }
            if (!constraint.startsWith("ac") || terminology == null || (acValueSet = terminology.getValueSets().get(constraint)) == null) continue;
            result.addAll(AOMUtils.getExpandedValueSetMembers(terminology.getValueSets(), acValueSet));
        }
        return result;
    }

    private List<String> getOpenEHRValueSetExpanded() {
        List<String> atCodes = this.getValueSetExpanded();
        ArchetypeTerminology terminology = this.getTerminology();
        OpenEHRTerminologyAccess terminologyAccess = OpenEHRTerminologyAccess.getInstance();
        ArrayList<String> result = new ArrayList<String>();
        if (terminology == null) {
            return result;
        }
        for (String atCode : atCodes) {
            String code;
            URI termBinding = terminology.getTermBinding("openehr", atCode);
            if (termBinding == null || (code = terminologyAccess.parseTerminologyURI(termBinding.toString())) == null) continue;
            result.add(code);
        }
        return result;
    }

    @Override
    public ConformanceCheckResult cConformsTo(CObject other, BiFunction<String, String, Boolean> rmTypesConformant) {
        ConformanceCheckResult superResult = super.cConformsTo(other, rmTypesConformant);
        if (!superResult.doesConform()) {
            return superResult;
        }
        CTerminologyCode otherCode = (CTerminologyCode)other;
        List<String> valueSet = this.getValueSetExpanded();
        List<String> otherValueSet = otherCode.getValueSetExpanded();
        if (this.constraint.size() != 1) {
            return ConformanceCheckResult.fails(ErrorType.VPOV, I18n.t((String)"child CTerminology code contains more than one constraint, that is not valid. Constraints are: {0}", (Object[])new Object[]{this.constraint}));
        }
        if (otherCode.constraint.size() != 1) {
            return ConformanceCheckResult.fails(ErrorType.VPOV, I18n.t((String)"parent CTerminology code contains more than one constraint, that is not valid. Constraints are: {0}", (Object[])new Object[]{this.constraint}));
        }
        if (!this.getEffectiveConstraintStatus().cConformsTo(otherCode.getEffectiveConstraintStatus())) {
            return ConformanceCheckResult.fails(ErrorType.VPOV, I18n.t((String)"specialized CTerminology code constraint status {0} is wider more than parent contraint status {1}", (Object[])new Object[]{this.getEffectiveConstraintStatus(), otherCode.getEffectiveConstraintStatus()}));
        }
        String thisConstraint = this.constraint.get(0);
        String otherConstraint = otherCode.constraint.get(0);
        Archetype archetype = this.getArchetype();
        if (AOMUtils.isValidValueSetCode(thisConstraint) && AOMUtils.isValidValueSetCode(otherConstraint)) {
            if (otherValueSet.isEmpty()) {
                return ConformanceCheckResult.conforms();
            }
            if (otherCode.isConstraintRequired()) {
                if (!AOMUtils.codesConformant(thisConstraint, otherConstraint)) {
                    return ConformanceCheckResult.fails(ErrorType.VPOV, I18n.t((String)"child terminology constraint value set code {0} does not conform to parent constraint with value set code {1}", (Object[])new Object[]{thisConstraint, otherConstraint}));
                }
                for (String value : valueSet) {
                    if (AOMUtils.valueSetContainsCodeOrParent(otherValueSet, value)) continue;
                    return ConformanceCheckResult.fails(ErrorType.VPOV, I18n.t((String)"child terminology constraint value code {0} is not contained in {1}, or a direct specialization of one of its values", (Object[])new Object[]{value, otherValueSet}));
                }
            } else {
                return ConformanceCheckResult.conforms();
            }
            return ConformanceCheckResult.conforms();
        }
        if (!AOMUtils.codesConformant(thisConstraint, otherConstraint)) {
            return ConformanceCheckResult.fails(ErrorType.VPOV, I18n.t((String)"child terminology constraint value code {0} does not conform to parent constraint with value code {1}", (Object[])new Object[]{thisConstraint, otherConstraint}));
        }
        return ConformanceCheckResult.conforms();
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("{[");
        boolean first = true;
        for (String constraint : this.getConstraint()) {
            if (!first) {
                result.append(", ");
            }
            first = false;
            result.append(constraint.toString());
        }
        result.append("]}");
        return result.toString();
    }
}

