/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.aom.utils;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.ArchetypeHRID;
import com.nedap.archie.aom.ArchetypeModelObject;
import com.nedap.archie.aom.ArchetypeSlot;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CAttributeTuple;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.primitives.CString;
import com.nedap.archie.aom.terminology.ValueSet;
import com.nedap.archie.aom.utils.CodeRedefinitionStatus;
import com.nedap.archie.aom.utils.NodeIdUtil;
import com.nedap.archie.paths.PathSegment;
import com.nedap.archie.paths.PathUtil;
import com.nedap.archie.query.AOMPathQuery;
import com.nedap.archie.query.APathQuery;
import com.nedap.archie.query.PartialMatch;
import com.nedap.archie.rminfo.MetaModel;
import com.nedap.archie.rminfo.MetaModels;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rminfo.RMAttributeInfo;
import com.nedap.archie.rminfo.RMTypeInfo;
import com.nedap.archie.rules.Assertion;
import com.nedap.archie.rules.BinaryOperator;
import com.nedap.archie.rules.Constraint;
import com.nedap.archie.rules.Expression;
import com.nedap.archie.rules.OperatorKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class AOMUtils {
    private static Pattern idCodePattern = Pattern.compile("(id|at|ac)(0|[1-9][0-9]*)(\\.(0|[1-9][0-9]*))*");
    private static Pattern adl14CodePattern = Pattern.compile("(id|at|ac)([0-9]+)(\\.(0|[1-9][0-9]*))*");

    public static int getSpecializationDepthFromCode(String code) {
        if (code == null) {
            return -1;
        }
        if (code.indexOf(46) < 0) {
            return 0;
        }
        return StringUtils.countMatches((CharSequence)code, (CharSequence)String.valueOf('.'));
    }

    public static boolean isIdCode(String code) {
        return code.startsWith("id");
    }

    public static boolean isValueCode(String code) {
        return code.startsWith("at");
    }

    public static boolean isValueSetCode(String code) {
        return code.startsWith("ac");
    }

    public static boolean isValidValueSetCode(String code) {
        return AOMUtils.isValueSetCode(code) && AOMUtils.isValidCode(code);
    }

    public static boolean isValidCode(String code) {
        if (code == null) {
            return false;
        }
        return idCodePattern.matcher(code).matches();
    }

    public static String stripPrefix(String nodeId) {
        if (AOMUtils.isValidCode(nodeId)) {
            return nodeId.substring(2);
        }
        return nodeId;
    }

    public static String pathAtSpecializationLevel(List<PathSegment> pathSegments, int level) {
        for (PathSegment segment : pathSegments) {
            if (segment.getNodeId() == null || !AOMUtils.isValidCode(segment.getNodeId()) || AOMUtils.getSpecializationDepthFromCode(segment.getNodeId()) <= level) continue;
            segment.setNodeId(AOMUtils.codeAtLevel(segment.getNodeId(), level));
        }
        return PathUtil.getPath(pathSegments);
    }

    public static String codeAtLevel(String nodeId, int level) {
        NodeIdUtil nodeIdUtil = new NodeIdUtil(nodeId);
        List<Integer> codes = new ArrayList<Integer>();
        for (int i = 0; i <= level && i < nodeIdUtil.getCodes().size(); ++i) {
            codes.add(nodeIdUtil.getCodes().get(i));
        }
        int numberOfCodesToRemove = 0;
        for (int i = codes.size() - 1; i >= 0 && (Integer)codes.get(i) == 0; --i) {
            ++numberOfCodesToRemove;
        }
        if (numberOfCodesToRemove > 0) {
            codes = codes.subList(0, codes.size() - numberOfCodesToRemove);
        }
        return nodeIdUtil.getPrefix() + Joiner.on((char)'.').join(codes);
    }

    public static boolean isOverridenCObject(CObject specialized, CObject parent) {
        return AOMUtils.isOverriddenIdCode(specialized.getNodeId(), parent.getNodeId());
    }

    public static boolean isOverriddenIdCode(String specializedNodeId, String parentNodeId) {
        if (specializedNodeId.equalsIgnoreCase(parentNodeId)) {
            return true;
        }
        return specializedNodeId.toLowerCase().startsWith(parentNodeId.toLowerCase() + ".");
    }

    public static CodeRedefinitionStatus getSpecialisationStatusFromCode(String nodeId, int specialisationDepth) {
        boolean codeDefinedAtThisLevel;
        if (specialisationDepth > AOMUtils.getSpecializationDepthFromCode(nodeId)) {
            return CodeRedefinitionStatus.INHERITED;
        }
        boolean bl = codeDefinedAtThisLevel = AOMUtils.codeIndexAtLevel(nodeId, specialisationDepth) > 0;
        if (codeDefinedAtThisLevel) {
            if (specialisationDepth > 0 && AOMUtils.codeExistsAtLevel(nodeId, specialisationDepth - 1)) {
                return CodeRedefinitionStatus.REDEFINED;
            }
            return CodeRedefinitionStatus.ADDED;
        }
        if (specialisationDepth > 0 && AOMUtils.codeExistsAtLevel(nodeId, specialisationDepth - 1)) {
            return CodeRedefinitionStatus.INHERITED;
        }
        return CodeRedefinitionStatus.UNDEFINED;
    }

    public static int codeIndexAtLevel(String nodeId, int specialisationDepth) {
        NodeIdUtil nodeIdUtil = new NodeIdUtil(nodeId);
        if (specialisationDepth < 0 || specialisationDepth >= nodeIdUtil.getCodes().size()) {
            throw new IllegalArgumentException("code is not valid at specialization depth " + specialisationDepth);
        }
        return nodeIdUtil.getCodes().get(specialisationDepth);
    }

    public static ArchetypeModelObject getDifferentialPathFromParent(Archetype flatParent, CAttribute attributeWithDifferentialPath) {
        Object parentAOMObject = flatParent.itemAtPath(AOMUtils.pathAtSpecializationLevel(attributeWithDifferentialPath.getParent().getPathSegments(), flatParent.specializationDepth()));
        if (parentAOMObject != null && parentAOMObject instanceof CComplexObject) {
            CComplexObject parentObject = (CComplexObject)parentAOMObject;
            Object attributeInParent = parentObject.itemAtPath(AOMUtils.pathAtSpecializationLevel(new APathQuery(attributeWithDifferentialPath.getDifferentialPath()).getPathSegments(), flatParent.specializationDepth()));
            return attributeInParent;
        }
        return null;
    }

    public static boolean isArchetypePath(String path) {
        APathQuery query = new APathQuery(path);
        for (PathSegment segment : query.getPathSegments()) {
            if (segment.getNodeId() == null && segment.getArchetypeRef() == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isPhantomPathAtLevel(List<PathSegment> pathSegments, int specializationDepth) {
        for (int i = pathSegments.size() - 1; i >= 0; --i) {
            String nodeId = pathSegments.get(i).getNodeId();
            if (nodeId == null || !AOMUtils.isValidCode(nodeId) || specializationDepth <= AOMUtils.getSpecializationDepthFromCode(nodeId)) continue;
            return AOMUtils.codeExistsAtLevel(nodeId, specializationDepth);
        }
        return false;
    }

    public static boolean codeExistsAtLevel(String nodeId, int specializationDepth) {
        NodeIdUtil nodeIdUtil = new NodeIdUtil(nodeId);
        int specializationDepthOfCode = AOMUtils.getSpecializationDepthFromCode(nodeId);
        if (specializationDepth <= specializationDepthOfCode) {
            String code = "";
            for (int i = 0; i <= specializationDepth; ++i) {
                code = code + nodeIdUtil.getCodes().get(i);
            }
            return Integer.parseInt(code) > 0;
        }
        return false;
    }

    public static boolean archetypeRefMatchesSlotExpression(String archetypeRef, ArchetypeSlot slot) {
        if (!AOMUtils.isSlotPresentAndOpen(slot.getIncludes()) && AOMUtils.isSlotPresentAndOpen(slot.getExcludes())) {
            for (Assertion include : slot.getIncludes()) {
                if (!AOMUtils.matchesInclude(include.getExpression(), archetypeRef)) continue;
                return true;
            }
            return false;
        }
        if (!AOMUtils.isSlotPresentAndOpen(slot.getExcludes()) && AOMUtils.isSlotPresentAndOpen(slot.getIncludes())) {
            for (Assertion exclude : slot.getExcludes()) {
                if (!AOMUtils.matchesExclude(exclude.getExpression(), archetypeRef)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isSlotPresentAndOpen(List<Assertion> slotAssertions) {
        if (slotAssertions == null || slotAssertions.isEmpty()) {
            return false;
        }
        return slotAssertions.get(0).matchesAny();
    }

    private static boolean matchesInclude(Expression expression, String archetypeRef) {
        Boolean result = AOMUtils.matchesExpression(expression, archetypeRef);
        return result == null ? true : result;
    }

    private static boolean matchesExclude(Expression expression, String archetypeRef) {
        Boolean result = AOMUtils.matchesExpression(expression, archetypeRef);
        return result == null ? false : result;
    }

    private static Boolean matchesExpression(Expression expression, String archetypeRef) {
        Constraint constraint;
        Expression rightOperand;
        BinaryOperator binary;
        if (expression instanceof BinaryOperator && (binary = (BinaryOperator)expression).getOperator() == OperatorKind.matches && (rightOperand = binary.getRightOperand()) instanceof Constraint && (constraint = (Constraint)rightOperand).getItem() != null && ((CPrimitiveObject)constraint.getItem()).getConstraint() != null && ((CPrimitiveObject)constraint.getItem()).getConstraint().size() > 0 && constraint.getItem() instanceof CString) {
            String pattern = ((CString)constraint.getItem()).getConstraint().get(0);
            if (pattern.startsWith("^") || pattern.startsWith("/")) {
                pattern = pattern.substring(1, pattern.length() - 1);
                return new ArchetypeHRID(archetypeRef).getSemanticId().matches(pattern) || archetypeRef.matches(pattern);
            }
            return archetypeRef.equals(pattern);
        }
        return null;
    }

    public static boolean codesConformant(String childNodeId, String parentNodeId) {
        return AOMUtils.isValidCode(childNodeId) && childNodeId.startsWith(parentNodeId) && (childNodeId.length() == parentNodeId.length() || childNodeId.length() > parentNodeId.length() && childNodeId.charAt(parentNodeId.length()) == '.');
    }

    public static CAttributeTuple findMatchingTuple(List<CAttributeTuple> attributeTuples, CAttributeTuple specializedTuple) {
        return attributeTuples.stream().filter(existingTuple -> existingTuple.getMemberNames().equals(specializedTuple.getMemberNames())).findAny().orElse(null);
    }

    public static RMAttributeInfo getAttributeInfoAtPath(ModelInfoLookup selectedModel, String rmTypeName, String path) {
        if (!path.contains("/")) {
            return selectedModel.getAttributeInfo(rmTypeName, path);
        }
        if (path.equals("/")) {
            throw new IllegalArgumentException("cannot retrieve attribute information for path '/'");
        }
        APathQuery query = new APathQuery(path);
        RMTypeInfo typeInfo = selectedModel.getTypeInfo(rmTypeName);
        RMAttributeInfo attribute = null;
        for (PathSegment segment : query.getPathSegments()) {
            if (typeInfo == null) {
                return null;
            }
            attribute = typeInfo.getAttribute(segment.getNodeName());
            if (attribute == null) {
                return null;
            }
            typeInfo = selectedModel.getTypeInfo(attribute.getTypeInCollection());
        }
        return attribute;
    }

    public static int getMaximumIdCode(int specializationDepth, Collection<String> usedIdCodes) {
        int maximumIdCode = 0;
        for (String code : usedIdCodes) {
            int numberOfDots;
            if (code.length() <= 2 || specializationDepth != (numberOfDots = AOMUtils.getSpecializationDepthFromCode(code))) continue;
            try {
                int numericCode = numberOfDots == 0 ? Integer.parseInt(code.substring(2)) : Integer.parseInt(code.substring(code.lastIndexOf(46) + 1));
                maximumIdCode = Math.max(numericCode, maximumIdCode);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return maximumIdCode;
    }

    public static int getMaximumIdCode(int specializationDepth, String prefix, Collection<String> usedIdCodes) {
        if (specializationDepth == 0) {
            throw new IllegalArgumentException("can only get the maximum code with prefix at a specialization depth > 0");
        }
        int maximumIdCode = 0;
        for (String code : usedIdCodes) {
            int numberOfDots;
            if (!code.startsWith(prefix + ".") || specializationDepth != (numberOfDots = CharMatcher.is((char)'.').countIn((CharSequence)code))) continue;
            int numericCode = Integer.parseInt(code.substring(code.lastIndexOf(46) + 1));
            maximumIdCode = Math.max(numericCode, maximumIdCode);
        }
        return maximumIdCode;
    }

    public static boolean isPathInArchetypeOrRm(MetaModel metaModel, String path, Archetype template) {
        AOMPathQuery aomPathQuery = new AOMPathQuery(path);
        PartialMatch partial = aomPathQuery.findPartial(template.getDefinition());
        if (partial.isFullMatch()) {
            return true;
        }
        if (AOMUtils.isArchetypePath(partial.getRemainingPath())) {
            return false;
        }
        for (ArchetypeModelObject archetypeModelObject : partial.getFoundObjects()) {
            if (archetypeModelObject instanceof CObject) {
                if (!metaModel.hasReferenceModelPath(((CObject)archetypeModelObject).getRmTypeName(), partial.getRemainingPath())) continue;
                return true;
            }
            if (!(archetypeModelObject instanceof CAttribute)) continue;
            CAttribute attribute = (CAttribute)archetypeModelObject;
            for (CObject child : attribute.getChildren()) {
                if (!metaModel.hasReferenceModelPath(child.getRmTypeName(), partial.getRemainingPath())) continue;
                return true;
            }
        }
        return false;
    }

    public static String getCodeInNearestParent(String nodeId) {
        NodeIdUtil nodeIdUtil = new NodeIdUtil(nodeId);
        List<Integer> codes = nodeIdUtil.getCodes();
        int newDepth = 0;
        for (int i = codes.size() - 2; i >= 0; --i) {
            if (codes.get(i) == 0) continue;
            newDepth = i;
            break;
        }
        return nodeIdUtil.getPrefix() + Joiner.on((char)'.').join(codes.subList(0, newDepth + 1));
    }

    public static boolean isValidADL14Code(String code) {
        if (code == null) {
            return false;
        }
        return adl14CodePattern.matcher(code).matches();
    }

    public static Set<String> getExpandedValueSetMembers(Map<String, ValueSet> allValueSets, ValueSet valueSet) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String member : valueSet.getMembers()) {
            if (AOMUtils.isValueSetCode(member)) {
                ValueSet includedValueSet = allValueSets.get(member);
                if (includedValueSet == null) {
                    result.add(member);
                    continue;
                }
                result.addAll(AOMUtils.getExpandedValueSetMembers(allValueSets, includedValueSet));
                continue;
            }
            result.add(member);
        }
        return result;
    }

    public static boolean valueSetContainsCodeOrParent(Collection<String> valueSetMembers, String code) {
        for (String value : valueSetMembers) {
            if (!AOMUtils.codesConformant(code, value)) continue;
            return true;
        }
        return false;
    }

    public static boolean parentIsMultiple(CObject cObject, Archetype flatParentArchetype, MetaModels metaModels) {
        if (cObject.getParent() != null) {
            CAttribute attributeFromParent;
            CAttribute parent = cObject.getParent();
            CObject owningObject = parent.getParent();
            if (parent.getDifferentialPath() != null && flatParentArchetype != null && (attributeFromParent = (CAttribute)AOMUtils.getDifferentialPathFromParent(flatParentArchetype, parent)) != null) {
                owningObject = attributeFromParent.getParent();
            }
            if (owningObject != null) {
                return metaModels.isMultiple(owningObject.getRmTypeName(), parent.getRmAttributeName());
            }
        }
        return false;
    }
}

