/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.aom.utils;

import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CAttributeTuple;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.CPrimitiveTuple;
import com.nedap.archie.aom.terminology.ArchetypeTerm;
import com.nedap.archie.aom.terminology.ArchetypeTerminology;
import java.util.Map;
import java.util.Stack;

public class ArchetypeParsePostProcesser {
    public static void fixArchetype(Archetype archetype) {
        if (archetype.getTerminology() != null) {
            ArchetypeTerminology terminology = archetype.getTerminology();
            ArchetypeParsePostProcesser.fillArchetypeTermCodes(terminology.getTermDefinitions());
            ArchetypeParsePostProcesser.fillArchetypeTermCodes(terminology.getTerminologyExtracts());
            archetype.getTerminology().setConceptCode(archetype.getDefinition().getNodeId());
            String originalLanguage = null;
            if (archetype.getOriginalLanguage() != null) {
                originalLanguage = archetype.getOriginalLanguage().getCodeString();
            }
            archetype.getTerminology().setOriginalLanguage(originalLanguage);
        }
        ArchetypeParsePostProcesser.setParents(archetype);
    }

    private static void setParents(Archetype archetype) {
        Stack<CObject> workList = new Stack<CObject>();
        workList.add(archetype.getDefinition());
        while (!workList.empty()) {
            CObject cObject = (CObject)workList.pop();
            if (cObject instanceof CPrimitiveObject) {
                cObject.setNodeId("id9999");
            }
            for (CAttribute attribute : cObject.getAttributes()) {
                attribute.setParent(cObject);
                for (CObject child : attribute.getChildren()) {
                    child.setParent(attribute);
                }
                workList.addAll(attribute.getChildren());
            }
            if (!(cObject instanceof CComplexObject)) continue;
            CComplexObject cComplexObject = (CComplexObject)cObject;
            for (CAttributeTuple tuple : cComplexObject.getAttributeTuples()) {
                for (CAttribute attribute : tuple.getMembers()) {
                    attribute.setSocParent(tuple);
                    attribute.setParent(cObject);
                    workList.addAll(attribute.getChildren());
                    cComplexObject.replaceAttribute(attribute);
                }
                for (CPrimitiveTuple primitiveTuple : tuple.getTuples()) {
                    int index = 0;
                    for (CPrimitiveObject object : primitiveTuple.getMembers()) {
                        if (index >= tuple.getMembers().size()) continue;
                        CAttribute attribute = (CAttribute)tuple.getMember(index);
                        object.setSocParent(primitiveTuple);
                        object.setParent(attribute);
                        ++index;
                    }
                }
            }
        }
    }

    private static void fillArchetypeTermCodes(Map<String, Map<String, ArchetypeTerm>> termSet) {
        if (termSet != null) {
            for (Map<String, ArchetypeTerm> language : termSet.values()) {
                for (String term : language.keySet()) {
                    language.get(term).setCode(term);
                }
            }
        }
    }
}

