/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.aom.utils;

import com.google.common.base.Joiner;
import com.nedap.archie.aom.utils.AOMUtils;
import java.util.ArrayList;
import java.util.List;

public class NodeIdUtil {
    private String prefix;
    private List<Integer> codes = new ArrayList<Integer>();

    public NodeIdUtil(String nodeId) {
        if (AOMUtils.isValidCode(nodeId) || AOMUtils.isValidADL14Code(nodeId)) {
            String[] split = nodeId.substring(2).split("\\.");
            this.prefix = nodeId.substring(0, 2);
            for (int i = 0; i < split.length; ++i) {
                this.codes.add(Integer.parseInt(split[i]));
            }
        }
    }

    public boolean isRedefined() {
        if (!this.isValid()) {
            return false;
        }
        if (this.codes.size() > 1) {
            for (int i = 0; i < this.codes.size() - 1; ++i) {
                if (this.codes.get(i) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValid() {
        return this.prefix != null;
    }

    public boolean isIdCode() {
        return "id".equals(this.prefix);
    }

    public boolean isValueCode() {
        return "at".equals(this.prefix);
    }

    public boolean isValueSetCode() {
        return "ac".equals(this.prefix);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public List<Integer> getCodes() {
        return this.codes;
    }

    public String toString() {
        return this.prefix + Joiner.on((char)'.').join(this.codes);
    }
}

