/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.query;

import com.google.common.collect.Lists;
import com.nedap.archie.aom.ArchetypeModelObject;
import com.nedap.archie.aom.CAttribute;
import com.nedap.archie.aom.CComplexObject;
import com.nedap.archie.aom.CComplexObjectProxy;
import com.nedap.archie.aom.CObject;
import com.nedap.archie.paths.PathSegment;
import com.nedap.archie.paths.PathUtil;
import com.nedap.archie.query.APathQuery;
import com.nedap.archie.query.ComplexObjectProxyReplacement;
import com.nedap.archie.query.PartialMatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AOMPathQuery {
    private static final Logger logger = LoggerFactory.getLogger(AOMPathQuery.class);
    private final List<PathSegment> pathSegments;
    private final boolean findThroughCComplexObjectProxies;
    private boolean findThroughDifferentialPaths = true;

    public AOMPathQuery(String query) {
        APathQuery apathQuery = new APathQuery(query);
        this.pathSegments = apathQuery.getPathSegments();
        this.findThroughCComplexObjectProxies = true;
    }

    private AOMPathQuery(List<PathSegment> pathSegments, boolean findThroughCComplexObjectProxies) {
        this.pathSegments = pathSegments;
        this.findThroughCComplexObjectProxies = findThroughCComplexObjectProxies;
    }

    public <T extends ArchetypeModelObject> T find(CComplexObject root) {
        List<T> list = this.findList(root);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return (T)((ArchetypeModelObject)list.get(0));
        }
        throw new UnsupportedOperationException("cannot find without list with more than 1 element");
    }

    public AOMPathQuery dontFindThroughCComplexObjectProxies() {
        return new AOMPathQuery(this.pathSegments, false);
    }

    public void setFindThroughDifferentialPaths(boolean find) {
        this.findThroughDifferentialPaths = find;
    }

    public <T extends ArchetypeModelObject> List<T> findList(CComplexObject root) {
        return this.findList(root, false);
    }

    public <T extends ArchetypeModelObject> List<T> findList(CComplexObject root, boolean matchSpecializedNodes) {
        ArrayList result = new ArrayList<ArchetypeModelObject>();
        result.add(root);
        for (int i = 0; i < this.pathSegments.size(); ++i) {
            PathSegment segment = this.pathSegments.get(i);
            if (result.size() == 0) {
                return Collections.emptyList();
            }
            CAttribute differentialAttribute = null;
            if (this.findThroughDifferentialPaths) {
                differentialAttribute = this.findMatchingDifferentialPath(this.pathSegments.subList(i, this.pathSegments.size()), result);
            }
            if (differentialAttribute != null) {
                PathSegment lastPathSegment = this.pathSegments.get(i = i + new APathQuery(differentialAttribute.getDifferentialPath()).getPathSegments().size() - 1);
                ArchetypeModelObject oneMatchingObject = this.findOneMatchingObject(differentialAttribute, lastPathSegment, matchSpecializedNodes);
                if (oneMatchingObject != null) {
                    result = Lists.newArrayList((Object[])new ArchetypeModelObject[]{oneMatchingObject});
                    continue;
                }
                result = this.findOneSegment(segment, result, matchSpecializedNodes);
                continue;
            }
            result = this.findOneSegment(segment, result, matchSpecializedNodes);
        }
        return result.stream().filter(object -> object != null).collect(Collectors.toList());
    }

    protected CAttribute findMatchingDifferentialPath(List<PathSegment> pathSegments, List<ArchetypeModelObject> objects) {
        if (pathSegments.size() < 2) {
            return null;
        }
        ArrayList result = new ArrayList();
        for (ArchetypeModelObject object : objects) {
            if (!(object instanceof CObject)) continue;
            for (CAttribute attribute : ((CObject)object).getAttributes()) {
                List differentialPathSegments;
                if (attribute.getDifferentialPath() == null || !this.checkDifferentialMatch(pathSegments, differentialPathSegments = new APathQuery(attribute.getDifferentialPath()).getPathSegments())) continue;
                return attribute;
            }
        }
        return null;
    }

    private boolean checkDifferentialMatch(List<PathSegment> pathSegments, List<PathSegment> differentialPathSegments) {
        if (differentialPathSegments.size() <= pathSegments.size()) {
            for (int i = 0; i < differentialPathSegments.size(); ++i) {
                PathSegment differentialPathSegment;
                PathSegment segment = pathSegments.get(i);
                if (this.matches(segment, differentialPathSegment = differentialPathSegments.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean matches(PathSegment segment, PathSegment differentialPathSegment) {
        if (differentialPathSegment.getNodeId() == null) {
            return segment.getNodeName().equalsIgnoreCase(differentialPathSegment.getNodeName());
        }
        return segment.getNodeName().equalsIgnoreCase(differentialPathSegment.getNodeName()) && segment.getNodeId().equals(differentialPathSegment.getNodeId());
    }

    protected List<ArchetypeModelObject> findOneSegment(PathSegment pathSegment, List<ArchetypeModelObject> objects, boolean matchSpecializedNodes) {
        ArrayList<ArchetypeModelObject> result = new ArrayList<ArchetypeModelObject>();
        ArrayList<ArchetypeModelObject> preProcessedObjects = new ArrayList<ArchetypeModelObject>();
        for (ArchetypeModelObject object : objects) {
            if (object instanceof CAttribute) {
                CAttribute cAttribute = (CAttribute)object;
                preProcessedObjects.addAll(cAttribute.getChildren());
                continue;
            }
            preProcessedObjects.add(object);
        }
        Iterator<ArchetypeModelObject> iterator = preProcessedObjects.iterator();
        while (iterator.hasNext()) {
            ArchetypeModelObject r;
            CObject cobject;
            CAttribute attribute;
            ComplexObjectProxyReplacement complexObjectProxyReplacement;
            ArchetypeModelObject objectToCheck;
            ArchetypeModelObject object = objectToCheck = iterator.next();
            if (this.findThroughCComplexObjectProxies && object instanceof CComplexObjectProxy && (complexObjectProxyReplacement = ComplexObjectProxyReplacement.getComplexObjectProxyReplacement((CComplexObjectProxy)object)) != null && complexObjectProxyReplacement.getReplacement() != null) {
                object = complexObjectProxyReplacement.getReplacement();
            }
            if (!(object instanceof CObject) || (attribute = (cobject = (CObject)object).getAttribute(pathSegment.getNodeName())) == null || (r = this.findOneMatchingObject(attribute, pathSegment, matchSpecializedNodes)) == null) continue;
            result.add(r);
        }
        return result;
    }

    protected ArchetypeModelObject findOneMatchingObject(CAttribute attribute, PathSegment pathSegment, boolean matchSpecializedNodes) {
        if (pathSegment.hasIdCode() || pathSegment.hasArchetypeRef()) {
            if (matchSpecializedNodes) {
                return attribute.getPossiblySpecializedChild(pathSegment.getNodeId());
            }
            return attribute.getChild(pathSegment.getNodeId());
        }
        if (pathSegment.hasNumberIndex()) {
            int index = pathSegment.getIndex() - 1;
            return index < attribute.getChildren().size() ? (ArchetypeModelObject)attribute.getChildren().get(index) : null;
        }
        if (pathSegment.getNodeId() != null) {
            CObject match = attribute.getChildByMeaning(pathSegment.getNodeId());
            if (match != null) {
                logger.warn("Deprecation: Matching on object name is deprecated and will be removed. Use node id instead.");
            }
            return match;
        }
        return attribute;
    }

    public List<PathSegment> getPathSegments() {
        return this.pathSegments;
    }

    public CComplexObjectProxy findAnyInternalReference(CComplexObject root) {
        return (CComplexObjectProxy)this.findMatchingPredicate(root, o -> o instanceof CComplexObjectProxy);
    }

    public ArchetypeModelObject findMatchingPredicate(CComplexObject root, Predicate<? super ArchetypeModelObject> predicate) {
        List<ArchetypeModelObject> result = new ArrayList<ArchetypeModelObject>();
        result.add(root);
        for (PathSegment segment : this.pathSegments) {
            if (result.size() == 0) {
                return null;
            }
            if ((result = this.findOneSegment(segment, result, false)).size() != 1 || !predicate.test(result.get(0))) continue;
            return result.get(0);
        }
        return null;
    }

    public List<ArchetypeModelObject> findAllMatchingPredicate(CComplexObject root, Predicate<? super ArchetypeModelObject> predicate) {
        List<ArchetypeModelObject> currentObjects = new ArrayList<ArchetypeModelObject>();
        currentObjects.add(root);
        ArrayList<ArchetypeModelObject> results = new ArrayList<ArchetypeModelObject>();
        for (PathSegment segment : this.pathSegments) {
            if (currentObjects.size() == 0) {
                return results;
            }
            if ((currentObjects = this.findOneSegment(segment, currentObjects, false)).size() != 1 || !predicate.test(currentObjects.get(0))) continue;
            results.addAll(currentObjects);
        }
        return results;
    }

    public PartialMatch findPartial(CComplexObject root) {
        ArrayList<PathSegment> pathsMatched = new ArrayList<PathSegment>();
        ArrayList<PathSegment> remainingSegments = new ArrayList<PathSegment>(this.pathSegments);
        List<Object> result = Lists.newArrayList((Object[])new ArchetypeModelObject[]{root});
        while (!remainingSegments.isEmpty()) {
            ArrayList lastResult = result;
            PathSegment segment = (PathSegment)remainingSegments.remove(0);
            result = this.findOneSegment(segment, (List<ArchetypeModelObject>)result, false);
            if (result.size() == 0) {
                remainingSegments.add(0, segment);
                return new PartialMatch(lastResult, PathUtil.getPath(pathsMatched), PathUtil.getPath(remainingSegments));
            }
            pathsMatched.add(segment);
        }
        return new PartialMatch((List<ArchetypeModelObject>)result, PathUtil.getPath(pathsMatched), PathUtil.getPath(remainingSegments));
    }
}

