/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rminfo;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.google.common.collect.Lists;
import com.nedap.archie.rminfo.ModelNamingStrategy;
import com.nedap.archie.rminfo.RMProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class ArchieModelNamingStrategy
implements ModelNamingStrategy {
    public static final PropertyNamingStrategies.SnakeCaseStrategy snakeCaseStrategy = new PropertyNamingStrategies.SnakeCaseStrategy();
    private final boolean standardsCompliantExpressionNames;
    private static final HashMap<String, String> rulesArchieToStandardTypeNamesMap = new HashMap();

    public ArchieModelNamingStrategy() {
        this.standardsCompliantExpressionNames = true;
    }

    public ArchieModelNamingStrategy(boolean standardCompliantExpressionNames) {
        this.standardsCompliantExpressionNames = standardCompliantExpressionNames;
    }

    public String getTypeName(Class<?> clazz) {
        String name;
        switch (name = clazz.getSimpleName()) {
            case "DvEHRURI": {
                return "DV_EHR_URI";
            }
            case "UIDBasedId": {
                return "UID_BASED_ID";
            }
        }
        if (this.standardsCompliantExpressionNames && rulesArchieToStandardTypeNamesMap.containsKey(name)) {
            return rulesArchieToStandardTypeNamesMap.get(name);
        }
        return this.convertToUpperSnakeCase(clazz);
    }

    private String convertToUpperSnakeCase(Class<?> clazz) {
        String name = clazz.getSimpleName();
        String result = snakeCaseStrategy.translate(name).toUpperCase();
        if (name.length() > 1 && name.startsWith("C") && Character.isUpperCase(name.charAt(1))) {
            result = result.replaceFirst("C", "C_");
        }
        return result;
    }

    public List<String> getAlternativeTypeNames(Class<?> clazz) {
        String name = clazz.getSimpleName();
        if (rulesArchieToStandardTypeNamesMap.containsKey(name)) {
            if (this.standardsCompliantExpressionNames) {
                return Lists.newArrayList((Object[])new String[]{this.convertToUpperSnakeCase(clazz)});
            }
            if (rulesArchieToStandardTypeNamesMap.containsKey(name)) {
                return Lists.newArrayList((Object[])new String[]{rulesArchieToStandardTypeNamesMap.get(name)});
            }
        }
        return Collections.emptyList();
    }

    public String getAttributeName(Field field, Method method) {
        RMProperty annotation;
        if (field != null && (annotation = field.getDeclaredAnnotation(RMProperty.class)) != null) {
            return annotation.value();
        }
        if (method != null && (annotation = method.getDeclaredAnnotation(RMProperty.class)) != null) {
            return annotation.value();
        }
        if (field != null) {
            return snakeCaseStrategy.translate(field.getName());
        }
        if (method.getName().startsWith("get") || method.getName().startsWith("set") || method.getName().startsWith("add")) {
            return snakeCaseStrategy.translate(method.getName().substring(3)).toLowerCase();
        }
        if (method.getName().startsWith("is")) {
            if (method.getName().equalsIgnoreCase("isIntegral")) {
                return "is_integral";
            }
            return snakeCaseStrategy.translate(method.getName().substring(2)).toLowerCase();
        }
        return method.getName();
    }

    static {
        rulesArchieToStandardTypeNamesMap.put("Operator", "EXPR_OPERATOR");
        rulesArchieToStandardTypeNamesMap.put("UnaryOperator", "EXPR_UNARY_OPERATOR");
        rulesArchieToStandardTypeNamesMap.put("BinaryOperator", "EXPR_BINARY_OPERATOR");
        rulesArchieToStandardTypeNamesMap.put("Leaf", "EXPR_LEAF");
        rulesArchieToStandardTypeNamesMap.put("Function", "EXPR_FUNCTION");
        rulesArchieToStandardTypeNamesMap.put("VariableReference", "EXPR_VARIABLE_REF");
        rulesArchieToStandardTypeNamesMap.put("Constant", "EXPR_LITERAL");
        rulesArchieToStandardTypeNamesMap.put("Constraint", "EXPR_CONSTRAINT");
        rulesArchieToStandardTypeNamesMap.put("ArchetypeIdConstraint", "EXPR_ARCHETYPE_ID_CONSTRAINT");
        rulesArchieToStandardTypeNamesMap.put("ModelReference", "EXPR_ARCHETYPE_REF");
        rulesArchieToStandardTypeNamesMap.put("RuleStatement", "STATEMENT");
    }
}

