/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rminfo;

import com.nedap.archie.aom.Archetype;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.aom.profile.AomProfile;
import com.nedap.archie.aom.profile.AomProfiles;
import com.nedap.archie.base.MultiplicityInterval;
import com.nedap.archie.rminfo.MetaModel;
import com.nedap.archie.rminfo.MetaModelInterface;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rminfo.ModelNotFoundException;
import com.nedap.archie.rminfo.NoModelSelectedException;
import com.nedap.archie.rminfo.RMObjectMapperProvider;
import com.nedap.archie.rminfo.ReferenceModels;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openehr.bmm.core.BmmModel;
import org.openehr.bmm.persistence.validation.BmmDefinitions;
import org.openehr.bmm.v2.validation.BmmRepository;
import org.openehr.bmm.v2.validation.BmmValidationResult;

public class MetaModels
implements MetaModelInterface {
    private final ReferenceModels models;
    private final BmmRepository bmmRepository;
    private AomProfiles aomProfiles;
    private MetaModel selectedModel;
    private AomProfile selectedAomProfile;
    private Map<String, String> overriddenMetaModelVersions = new ConcurrentHashMap<String, String>();

    public MetaModels(ReferenceModels models, BmmRepository repository) {
        this.models = models;
        this.bmmRepository = repository;
        this.aomProfiles = new AomProfiles();
    }

    public MetaModels(ReferenceModels models, BmmRepository repository, AomProfiles profiles) {
        this.models = models;
        this.bmmRepository = repository;
        this.aomProfiles = profiles;
    }

    public void overrideModelVersion(String rmPublisher, String rmPackage, String version) {
        this.overriddenMetaModelVersions.put(BmmDefinitions.publisherQualifiedRmClosureName((String)rmPublisher, (String)rmPackage), version);
    }

    public void removeOverridenModelVersion(String rmPublisher, String rmPackage) {
        this.overriddenMetaModelVersions.remove(BmmDefinitions.publisherQualifiedRmClosureName((String)rmPublisher, (String)rmPackage));
    }

    public String getOverriddenModelVersion(String rmPublisher, String rmPackage) {
        return this.overriddenMetaModelVersions.get(BmmDefinitions.publisherQualifiedRmClosureName((String)rmPublisher, (String)rmPackage));
    }

    public void selectModel(Archetype archetype) throws ModelNotFoundException {
        String overriddenVersion = this.getOverriddenModelVersion(archetype.getArchetypeId().getRmPublisher(), archetype.getArchetypeId().getRmPackage());
        this.selectModel(archetype, overriddenVersion == null ? archetype.getRmRelease() : overriddenVersion);
    }

    public void selectModel(Archetype archetype, String rmVersion) throws ModelNotFoundException {
        this.selectModel(archetype.getArchetypeId().getRmPublisher(), archetype.getArchetypeId().getRmPackage(), rmVersion);
    }

    public void selectModel(String rmPublisher, String rmPackage, String rmRelease) throws ModelNotFoundException {
        ModelInfoLookup selectedModel = null;
        BmmModel selectedBmmModel = null;
        RMObjectMapperProvider objectMapperProvider = null;
        if (this.models != null) {
            selectedModel = this.models.getModel(rmPublisher, rmPackage);
            objectMapperProvider = this.models.getRmObjectMapperProvider(rmPublisher, rmPackage);
        }
        if (this.bmmRepository != null) {
            BmmValidationResult validationResult = this.bmmRepository.getModelByClosure(BmmDefinitions.publisherQualifiedRmClosureName((String)rmPublisher, (String)rmPackage) + "_" + rmRelease);
            selectedBmmModel = validationResult == null ? null : validationResult.getModel();
        }
        this.selectedAomProfile = this.getAomProfileWithSchemaId(selectedBmmModel);
        if (this.selectedAomProfile == null) {
            this.selectedAomProfile = this.getAomProfileOnPublisher(rmPublisher);
        }
        if (selectedModel == null && selectedBmmModel == null) {
            throw new ModelNotFoundException(String.format("model for %s.%s version %s not found", rmPublisher, rmPackage, rmRelease));
        }
        this.selectedModel = new MetaModel(selectedModel, selectedBmmModel, this.selectedAomProfile, objectMapperProvider);
    }

    private AomProfile getAomProfileWithSchemaId(BmmModel selectedBmmModel) {
        if (selectedBmmModel != null) {
            for (AomProfile profile : this.aomProfiles.getProfiles()) {
                if (!profile.getRmSchemaPattern().stream().anyMatch(pat -> selectedBmmModel.getSchemaId().matches((String)pat))) continue;
                return profile;
            }
        }
        return null;
    }

    private AomProfile getAomProfileOnPublisher(String rmPublisher) {
        for (AomProfile profile : this.aomProfiles.getProfiles()) {
            if (!profile.getProfileName().equalsIgnoreCase(rmPublisher)) continue;
            return profile;
        }
        return null;
    }

    public ModelInfoLookup getSelectedModelInfoLookup() {
        return this.selectedModel == null ? null : this.selectedModel.getSelectedModel();
    }

    public BmmModel getSelectedBmmModel() {
        return this.selectedModel == null ? null : this.selectedModel.getSelectedBmmModel();
    }

    public MetaModel getSelectedModel() {
        return this.selectedModel;
    }

    public ReferenceModels getReferenceModels() {
        return this.models;
    }

    public BmmRepository getBmmRepository() {
        return this.bmmRepository;
    }

    @Override
    public boolean isMultiple(String typeName, String attributeName) {
        this.checkThatModelHasBeenSelected();
        return this.selectedModel.isMultiple(typeName, attributeName);
    }

    @Override
    public boolean rmTypesConformant(String childTypeName, String parentTypeName) {
        this.checkThatModelHasBeenSelected();
        return this.selectedModel.rmTypesConformant(childTypeName, parentTypeName);
    }

    @Override
    public boolean typeNameExists(String typeName) {
        this.checkThatModelHasBeenSelected();
        return this.selectedModel.typeNameExists(typeName);
    }

    @Override
    public boolean attributeExists(String rmTypeName, String propertyName) {
        this.checkThatModelHasBeenSelected();
        return this.selectedModel.attributeExists(rmTypeName, propertyName);
    }

    @Override
    public boolean isNullable(String typeId, String attributeName) {
        this.checkThatModelHasBeenSelected();
        return this.selectedModel.isNullable(typeId, attributeName);
    }

    @Override
    public boolean typeConformant(String rmTypeName, String rmAttributeName, String childConstraintTypeName) {
        this.checkThatModelHasBeenSelected();
        return this.selectedModel.typeConformant(rmTypeName, rmAttributeName, childConstraintTypeName);
    }

    @Override
    public boolean hasReferenceModelPath(String rmTypeName, String path) {
        this.checkThatModelHasBeenSelected();
        return this.selectedModel.hasReferenceModelPath(rmTypeName, path);
    }

    @Override
    public MultiplicityInterval referenceModelPropMultiplicity(String rmTypeName, String rmAttributeName) {
        this.checkThatModelHasBeenSelected();
        return this.selectedModel.referenceModelPropMultiplicity(rmTypeName, rmAttributeName);
    }

    @Override
    public boolean validatePrimitiveType(String rmTypeName, String rmAttributeName, CPrimitiveObject<?, ?> cObject) {
        this.checkThatModelHasBeenSelected();
        return this.selectedModel.validatePrimitiveType(rmTypeName, rmAttributeName, cObject);
    }

    private void checkThatModelHasBeenSelected() throws NoModelSelectedException {
        if (this.selectedModel == null) {
            throw new NoModelSelectedException("Please call the selectModel() method before trying to use MetaModels");
        }
    }

    @Override
    public boolean isOrdered(String rmTypeName, String rmAttributeName) {
        this.checkThatModelHasBeenSelected();
        return this.selectedModel.isOrdered(rmTypeName, rmAttributeName);
    }

    public AomProfiles getAomProfiles() {
        return this.aomProfiles;
    }

    public AomProfile getSelectedAomProfile() {
        return this.selectedAomProfile;
    }
}

