/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rminfo;

import com.google.common.reflect.TypeToken;
import com.nedap.archie.aom.CPrimitiveObject;
import com.nedap.archie.rminfo.Invariant;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rminfo.ModelNamingStrategy;
import com.nedap.archie.rminfo.PropertyType;
import com.nedap.archie.rminfo.RMAttributeInfo;
import com.nedap.archie.rminfo.RMProperty;
import com.nedap.archie.rminfo.RMPropertyIgnore;
import com.nedap.archie.rminfo.RMTypeInfo;
import com.nedap.archie.rminfo.SpecificMethodSelector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ClasspathHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReflectionModelInfoLookup
implements ModelInfoLookup {
    private static final Logger logger = LoggerFactory.getLogger(ReflectionModelInfoLookup.class);
    private ModelNamingStrategy namingStrategy;
    private String packageName;
    private ClassLoader classLoader;
    private Map<String, RMTypeInfo> rmTypeNamesToRmTypeInfo = new HashMap<String, RMTypeInfo>();
    private Map<Class<?>, RMTypeInfo> classesToRmTypeInfo = new HashMap();
    private boolean inConstructor = true;
    private boolean addAttributesWithoutField = true;
    private Set<String> forbiddenMethods = new HashSet<String>(Arrays.asList("getClass", "wait", "notify", "notifyAll", "clone", "finalize"));

    public ReflectionModelInfoLookup(ModelNamingStrategy namingStrategy, Class<?> baseClass) {
        this(namingStrategy, baseClass, ReflectionModelInfoLookup.class.getClassLoader(), true);
    }

    public ReflectionModelInfoLookup(ModelNamingStrategy namingStrategy, String packageName, ClassLoader classLoader) {
        this.packageName = packageName;
        this.namingStrategy = namingStrategy;
        this.classLoader = classLoader;
        Reflections reflections = new Reflections(packageName, new Scanner[]{Scanners.SubTypes.filterResultsBy(s -> true)});
        Set typeNames = reflections.getAllTypes();
        typeNames.forEach(typeName -> {
            try {
                this.addClass(classLoader.loadClass((String)typeName));
            }
            catch (ClassNotFoundException e) {
                logger.error("error loading model info lookup", (Throwable)e);
            }
        });
        this.addSuperAndSubclassInfo();
        this.addAlternativeTypeNames();
        this.inConstructor = false;
    }

    public ReflectionModelInfoLookup(ModelNamingStrategy namingStrategy, Class<?> baseClass, ClassLoader classLoader, boolean addAttributesWithoutField) {
        this.namingStrategy = namingStrategy;
        this.addAttributesWithoutField = addAttributesWithoutField;
        this.classLoader = classLoader;
        this.addTypes(baseClass);
        this.addSuperAndSubclassInfo();
        this.addAlternativeTypeNames();
        this.inConstructor = false;
    }

    private void addAlternativeTypeNames() {
        for (Class<?> clazz : this.classesToRmTypeInfo.keySet()) {
            for (String alternativeName : this.namingStrategy.getAlternativeTypeNames(clazz)) {
                String originalName = this.namingStrategy.getTypeName(clazz);
                this.rmTypeNamesToRmTypeInfo.put(alternativeName, this.rmTypeNamesToRmTypeInfo.get(originalName));
            }
        }
    }

    protected void addTypes(Class<?> baseClass) {
        this.addSubtypesOf(baseClass);
    }

    private void addSuperAndSubclassInfo() {
        for (RMTypeInfo typeInfo : this.rmTypeNamesToRmTypeInfo.values()) {
            Class superclass = typeInfo.getJavaClass().getSuperclass();
            if (!superclass.equals(Object.class)) {
                this.addDescendantClass(typeInfo, superclass);
            }
            for (Class<?> interfaceClass : typeInfo.getJavaClass().getInterfaces()) {
                this.addDescendantClass(typeInfo, interfaceClass);
            }
        }
    }

    private void addDescendantClass(RMTypeInfo typeInfo, Class<?> interfaceClass) {
        RMTypeInfo superClassTypeInfo = this.getTypeInfo(interfaceClass);
        if (superClassTypeInfo != null) {
            typeInfo.addDirectParentClass(superClassTypeInfo);
            superClassTypeInfo.addDirectDescendantClass(typeInfo);
        }
    }

    protected <T> void addSubtypesOf(Class<T> baseClass) {
        Reflections reflections = new Reflections(new Object[]{ClasspathHelper.forClass(baseClass, (ClassLoader[])new ClassLoader[0]), Scanners.SubTypes.filterResultsBy(s -> true)});
        Set classes = reflections.getSubTypesOf(baseClass);
        classes.forEach(this::addClass);
        this.addClass(baseClass);
    }

    protected void addClass(Class<?> clazz) {
        String rmTypeName = this.namingStrategy.getTypeName(clazz);
        RMTypeInfo typeInfo = new RMTypeInfo(clazz, rmTypeName);
        this.addAttributeInfo(clazz, typeInfo);
        this.addInvariantChecks(clazz, typeInfo);
        this.rmTypeNamesToRmTypeInfo.put(rmTypeName, typeInfo);
        this.classesToRmTypeInfo.put(clazz, typeInfo);
        if (!this.inConstructor) {
            this.addSuperAndSubclassInfo();
            this.addAlternativeTypeNames();
        }
    }

    private void addAttributeInfo(Class<?> clazz, RMTypeInfo typeInfo) {
        TypeToken typeToken = TypeToken.of(clazz);
        Set allFields = ReflectionUtils.getAllFields(clazz, (Predicate[])new Predicate[0]);
        Map<String, Field> fieldsByName = allFields.stream().filter(field -> !field.getName().startsWith("$")).collect(Collectors.toMap(field -> field.getName(), field -> field, (duplicate1, duplicate2) -> duplicate1));
        for (Field field2 : fieldsByName.values()) {
            this.addRMAttributeInfo(clazz, typeInfo, typeToken, field2);
        }
        if (this.addAttributesWithoutField) {
            Set getters = ReflectionUtils.getAllMethods(clazz, (Predicate[])new Predicate[]{method -> method.getName().startsWith("get") || method.getName().startsWith("is")});
            Map<String, Method> gettersByName = getters.stream().filter(this::shouldAdd).collect(Collectors.toMap(Method::getName, method -> method, new SpecificMethodSelector()));
            for (Method getMethod : gettersByName.values()) {
                this.addRMAttributeInfo(clazz, typeInfo, typeToken, getMethod, fieldsByName);
            }
        }
    }

    private void addInvariantChecks(Class clazz, RMTypeInfo typeInfo) {
        Set allInvariants = ReflectionUtils.getAllMethods((Class)clazz, (Predicate[])new Predicate[]{method -> method.getAnnotation(Invariant.class) != null});
        for (Method method2 : allInvariants) {
            if (method2.getParameterCount() != 0) {
                throw new RuntimeException("An invariant check must not have any parameters, in method " + clazz.getSimpleName() + "::" + method2.getName());
            }
            Class<?> returnType = method2.getReturnType();
            if (!returnType.equals(Boolean.class) && !returnType.equals(Boolean.TYPE)) {
                throw new RuntimeException("An invariant check must return a boolean parameter, was " + returnType.getSimpleName() + " in method " + clazz.getSimpleName() + "::" + method2.getName());
            }
            Invariant annotation = method2.getAnnotation(Invariant.class);
            typeInfo.addInvariantMethod(method2, annotation);
        }
    }

    protected boolean shouldAdd(Method method) {
        if (method == null) {
            return true;
        }
        if (method.getAnnotation(Invariant.class) != null) {
            return false;
        }
        return Modifier.isPublic(method.getModifiers()) && method.getAnnotation(RMPropertyIgnore.class) == null;
    }

    protected void addRMAttributeInfo(Class<?> clazz, RMTypeInfo typeInfo, TypeToken<?> typeToken, Method getMethod, Map<String, Field> fieldsByName) {
        String javaFieldName = null;
        javaFieldName = getMethod.getName().startsWith("is") ? this.lowerCaseFirstChar(getMethod.getName().substring(2)) : this.lowerCaseFirstChar(getMethod.getName().substring(3));
        Field field = fieldsByName.get(javaFieldName);
        if (field == null) {
            field = fieldsByName.get(getMethod.getName());
        }
        String javaFieldNameUpperCased = this.upperCaseFirstChar(javaFieldName);
        Method setMethod = null;
        Method addMethod = null;
        if (getMethod == null) {
            getMethod = this.getMethod(clazz, "is" + javaFieldNameUpperCased, new Class[0]);
        }
        if (getMethod != null) {
            setMethod = this.getMethod(clazz, "set" + javaFieldNameUpperCased, getMethod.getReturnType());
            addMethod = this.getAddMethod(clazz, typeToken, javaFieldNameUpperCased, getMethod);
        } else {
            logger.debug("No get method found for attribute {} on class {}", (Object)javaFieldName, (Object)clazz.getSimpleName());
        }
        String attributeName = this.namingStrategy.getAttributeName(field, getMethod);
        TypeToken fieldType = typeToken.resolveType(getMethod.getGenericReturnType());
        Class rawFieldType = fieldType.getRawType();
        Class<?> typeInCollection = this.getTypeInCollection(fieldType);
        RMAttributeInfo attributeInfo = new RMAttributeInfo(attributeName, field, rawFieldType, typeInCollection, this.namingStrategy.getTypeName(typeInCollection), this.isNullable(clazz, getMethod, field), getMethod, setMethod, addMethod, this.determineIfComputed(clazz, getMethod, field, setMethod, addMethod));
        if (typeInfo.getAttribute(attributeName) == null) {
            typeInfo.addAttribute(attributeInfo);
        }
    }

    private boolean determineIfComputed(Class<?> clazz, Method getMethod, Field field, Method setMethod, Method addMethod) {
        boolean computed = setMethod == null && addMethod == null && field == null;
        RMProperty annotation = this.getAnnotation(clazz, getMethod, field, RMProperty.class);
        if (annotation != null && annotation.computed() != PropertyType.AUTO_DETECT) {
            computed = annotation.computed() == PropertyType.COMPUTED;
        }
        return computed;
    }

    protected boolean isNullable(Class<?> clazz, Method getMethod, Field field) {
        return this.getAnnotation(clazz, getMethod, field, Nullable.class) != null;
    }

    private <T extends Annotation> T getAnnotation(Class<?> clazz, Method getMethod, Field field, Class<T> annotationClass) {
        T annotation;
        if (field != null && (annotation = field.getAnnotation(annotationClass)) != null) {
            return annotation;
        }
        if (getMethod != null && (annotation = getMethod.getAnnotation(annotationClass)) != null) {
            return annotation;
        }
        return null;
    }

    private void addRMAttributeInfo(Class<?> clazz, RMTypeInfo typeInfo, TypeToken<?> typeToken, Field field) {
        String javaFieldName = field.getName();
        String javaFieldNameUpperCased = this.upperCaseFirstChar(javaFieldName);
        Method getMethod = this.getMethod(clazz, "get" + javaFieldNameUpperCased, new Class[0]);
        Method setMethod = null;
        Method addMethod = null;
        if (getMethod == null) {
            getMethod = this.getMethod(clazz, "is" + javaFieldNameUpperCased, new Class[0]);
        }
        if (getMethod != null) {
            setMethod = this.getMethod(clazz, "set" + javaFieldNameUpperCased, getMethod.getReturnType());
            addMethod = this.getAddMethod(clazz, typeToken, javaFieldNameUpperCased, getMethod);
        } else {
            logger.debug("No get method found for field {} on class {}", (Object)field.getName(), (Object)clazz.getSimpleName());
        }
        if (javaFieldName.startsWith("is")) {
            String fieldNameWithoutPrefix = javaFieldName.substring(2);
            String withoutPrefixUpperCased = this.upperCaseFirstChar(fieldNameWithoutPrefix);
            if (getMethod == null) {
                getMethod = this.getMethod(clazz, "is" + withoutPrefixUpperCased, new Class[0]);
            }
            if (getMethod != null) {
                if (setMethod == null) {
                    setMethod = this.getMethod(clazz, "set" + withoutPrefixUpperCased, getMethod.getReturnType());
                }
                if (addMethod == null) {
                    addMethod = this.getAddMethod(clazz, typeToken, withoutPrefixUpperCased, getMethod);
                }
            } else {
                logger.debug("No get method found for attribute {} on class {}", (Object)javaFieldName, (Object)clazz.getSimpleName());
            }
        }
        String attributeName = this.namingStrategy.getAttributeName(field, getMethod);
        TypeToken fieldType = null;
        fieldType = getMethod != null ? typeToken.resolveType(getMethod.getGenericReturnType()) : typeToken.resolveType(field.getGenericType());
        Class rawFieldType = fieldType.getRawType();
        Class<?> typeInCollection = this.getTypeInCollection(fieldType);
        if (setMethod != null && this.shouldAdd(setMethod) && this.shouldAdd(getMethod)) {
            RMAttributeInfo attributeInfo = new RMAttributeInfo(attributeName, field, rawFieldType, typeInCollection, this.namingStrategy.getTypeName(typeInCollection), this.isNullable(clazz, getMethod, field), getMethod, setMethod, addMethod, this.determineIfComputed(clazz, getMethod, field, setMethod, addMethod));
            typeInfo.addAttribute(attributeInfo);
        } else {
            logger.debug("property without a set method ignored for field {} on class {}", (Object)field.getName(), (Object)clazz.getSimpleName());
        }
    }

    private Class<?> getTypeInCollection(TypeToken<?> fieldType) {
        Class rawFieldType = fieldType.getRawType();
        if (Collection.class.isAssignableFrom(rawFieldType)) {
            Type[] actualTypeArguments = ((ParameterizedType)fieldType.getType()).getActualTypeArguments();
            if (actualTypeArguments.length == 1) {
                if (actualTypeArguments[0] instanceof Class) {
                    return (Class)actualTypeArguments[0];
                }
                if (actualTypeArguments[0] instanceof ParameterizedType) {
                    ParameterizedType parameterizedTypeInCollection = (ParameterizedType)actualTypeArguments[0];
                    return (Class)parameterizedTypeInCollection.getRawType();
                }
                if (actualTypeArguments[0] instanceof TypeVariable) {
                    return (Class)((TypeVariable)actualTypeArguments[0]).getBounds()[0];
                }
            }
        } else if (rawFieldType.isArray()) {
            return rawFieldType.getComponentType();
        }
        return rawFieldType;
    }

    private Method getAddMethod(Class<?> clazz, TypeToken<?> typeToken, String javaFieldNameUpperCased, Method getMethod) {
        Type[] typeArguments;
        Method addMethod = null;
        if (Collection.class.isAssignableFrom(getMethod.getReturnType()) && (typeArguments = ((ParameterizedType)getMethod.getGenericReturnType()).getActualTypeArguments()).length == 1) {
            TypeToken singularParameter = typeToken.resolveType(typeArguments[0]);
            String addMethodName = "add" + this.toSingular(javaFieldNameUpperCased);
            addMethod = this.getMethod(clazz, addMethodName, singularParameter.getRawType());
            if (addMethod == null) {
                Set allAddMethods = ReflectionUtils.getAllMethods(clazz, (Predicate[])new Predicate[]{ReflectionUtils.withName((String)addMethodName)});
                if (allAddMethods.size() == 1) {
                    addMethod = (Method)allAddMethods.iterator().next();
                } else {
                    logger.debug("strange number of add methods for field {} on class {}", (Object)javaFieldNameUpperCased, (Object)clazz.getSimpleName());
                }
            }
        }
        return addMethod;
    }

    private String toSingular(String javaFieldNameUpperCased) {
        if (javaFieldNameUpperCased.endsWith("s")) {
            return javaFieldNameUpperCased.substring(0, javaFieldNameUpperCased.length() - 1);
        }
        return javaFieldNameUpperCased;
    }

    private Method getMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    private String upperCaseFirstChar(String name) {
        return new StringBuilder(name).replace(0, 1, Character.toString(Character.toUpperCase(name.charAt(0)))).toString();
    }

    private String lowerCaseFirstChar(String name) {
        return new StringBuilder(name).replace(0, 1, Character.toString(Character.toLowerCase(name.charAt(0)))).toString();
    }

    @Override
    public Class<?> getClass(String rmTypeName) {
        String strippedRmTypeName = this.getTypeWithoutGenericType(rmTypeName);
        RMTypeInfo rmTypeInfo = this.rmTypeNamesToRmTypeInfo.get(strippedRmTypeName);
        return rmTypeInfo == null ? null : rmTypeInfo.getJavaClass();
    }

    @Override
    public Class<?> getClassToBeCreated(String rmTypename) {
        return this.getClass(rmTypename);
    }

    @Override
    public Map<String, Class<?>> getRmTypeNameToClassMap() {
        HashMap result = new HashMap();
        for (String rmTypeName : this.rmTypeNamesToRmTypeInfo.keySet()) {
            result.put(rmTypeName, this.rmTypeNamesToRmTypeInfo.get(rmTypeName).getJavaClass());
        }
        return result;
    }

    @Override
    public RMTypeInfo getTypeInfo(Class<?> clazz) {
        return this.classesToRmTypeInfo.get(clazz);
    }

    @Override
    public Field getField(Class<?> clazz, String attributeName) {
        RMTypeInfo typeInfo = this.classesToRmTypeInfo.get(clazz);
        RMAttributeInfo attributeInfo = typeInfo == null ? null : typeInfo.getAttribute(attributeName);
        return attributeInfo == null ? null : attributeInfo.getField();
    }

    @Override
    public RMTypeInfo getTypeInfo(String rmTypeName) {
        String strippedRmTypeName = this.getTypeWithoutGenericType(rmTypeName);
        return this.rmTypeNamesToRmTypeInfo.get(strippedRmTypeName);
    }

    private String getTypeWithoutGenericType(String rmTypeName) {
        if (rmTypeName.indexOf(60) > 0) {
            rmTypeName = rmTypeName.substring(0, rmTypeName.indexOf(60));
        }
        return rmTypeName;
    }

    @Override
    public RMAttributeInfo getAttributeInfo(Class<?> clazz, String attributeName) {
        RMTypeInfo typeInfo = this.classesToRmTypeInfo.get(clazz);
        return typeInfo == null ? null : typeInfo.getAttribute(attributeName);
    }

    @Override
    public RMAttributeInfo getAttributeInfo(String rmTypeName, String attributeName) {
        String strippedRmTypeName = this.getTypeWithoutGenericType(rmTypeName);
        RMTypeInfo typeInfo = this.rmTypeNamesToRmTypeInfo.get(strippedRmTypeName);
        return typeInfo == null ? null : typeInfo.getAttribute(attributeName);
    }

    @Override
    public List<RMTypeInfo> getAllTypes() {
        return new ArrayList<RMTypeInfo>(this.classesToRmTypeInfo.values());
    }

    @Override
    public ModelNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    @Override
    public Object convertToConstraintObject(Object object, CPrimitiveObject<?, ?> cPrimitiveObject) {
        return object;
    }

    @Override
    public Object convertConstrainedPrimitiveToRMObject(Object object) {
        return object;
    }
}

