/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rules;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nedap.archie.rules.Expression;
import com.nedap.archie.rules.OperatorDef;
import com.nedap.archie.rules.OperatorDefBuiltin;
import com.nedap.archie.rules.OperatorKind;
import java.util.ArrayList;
import java.util.List;

public class Operator
extends Expression {
    private OperatorKind operator;
    private List<Expression> operands = new ArrayList<Expression>();
    private String symbol;

    @JsonIgnore
    public OperatorKind getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorKind operator) {
        this.operator = operator;
    }

    @JsonIgnore
    public List<Expression> getOperands() {
        return this.operands;
    }

    public void setOperands(List<Expression> operands) {
        this.operands = operands;
    }

    @JsonIgnore
    protected Expression getFirstOperand() {
        return this.operands.size() > 0 ? this.operands.get(0) : null;
    }

    protected void setFirstOperand(Expression firstOperand) {
        this.setLeftOperand(firstOperand);
    }

    @JsonIgnore
    protected Expression getSecondOperand() {
        return this.operands.size() > 1 ? this.operands.get(1) : null;
    }

    protected void setSecondOperand(Expression secondOperand) {
        this.setRightOperand(secondOperand);
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public OperatorDef getOperatorDef() {
        return this.operator == null ? null : new OperatorDefBuiltin(this.operator.getIdentifier());
    }

    public void setOperatorDef(OperatorDef operatorDef) {
        if (operatorDef != null && operatorDef.getIdentifier() != null) {
            this.operator = OperatorKind.parseFromIdentifier(operatorDef.getIdentifier());
        }
    }

    public void setLeftOperand(Expression operand) {
        if (this.operands.isEmpty()) {
            this.operands.add(operand);
        } else {
            this.operands.set(0, operand);
        }
    }

    public void setRightOperand(Expression operand) {
        if (this.operands.isEmpty()) {
            this.operands.add(null);
            this.operands.add(operand);
        } else if (this.operands.size() == 1) {
            this.operands.add(operand);
        } else {
            this.operands.set(1, operand);
        }
    }

    @JsonIgnore
    public boolean isUnary() {
        return this.operands.size() == 1;
    }

    public void addOperand(Expression expression) {
        this.operands.add(expression);
    }
}

