/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.rules;

import com.google.common.collect.ImmutableSet;

public enum OperatorKind {
    eq("op_eq", "="),
    ne("op_ne", "!=", "\u2260"),
    le("op_le", "<=", "\u2264"),
    lt("op_lt", "<"),
    ge("op_ge", ">=", "\u2265"),
    gt("op_gt", ">"),
    matches("op_matches", "matches", "\u2208", "is_in"),
    not("op_not", "not", "!", "\u223c", "\u00ac"),
    and("op_and", "and", "\u2227"),
    or("op_or", "or", "\u2228"),
    xor("op_xor", "xor", "\u22bb"),
    implies("op_implies", "implies", "\u21d2"),
    for_all("op_for_all", "for_all", "\u2200", "every"),
    exists("op_exists", "exists", "\u2203"),
    plus("op_plus", "+"),
    minus("op_minus", "-"),
    multiply("op_multiply", "*"),
    divide("op_divide", "/"),
    modulo("op_modulo", "%"),
    exponent("op_exponent", "^");

    private final String identifier;
    private final ImmutableSet<String> codes;

    private OperatorKind(String identifier, String ... items) {
        this.identifier = identifier;
        this.codes = ImmutableSet.copyOf((Object[])items);
    }

    public String getDefaultCode() {
        return (String)this.codes.iterator().next();
    }

    public static OperatorKind parseFromIdentifier(String identifier) {
        for (OperatorKind operator : OperatorKind.values()) {
            if (operator.name().equals(identifier)) {
                return operator;
            }
            if (!operator.getIdentifier().equals(identifier)) continue;
            return operator;
        }
        return null;
    }

    public static OperatorKind parse(String operatorString) {
        operatorString = operatorString.toLowerCase();
        for (OperatorKind operator : OperatorKind.values()) {
            if (!operator.codes.contains((Object)operatorString)) continue;
            return operator;
        }
        return null;
    }

    public String getIdentifier() {
        return this.identifier;
    }
}

