/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.serializer.adl;

import com.nedap.archie.aom.RulesSection;
import com.nedap.archie.rules.Assertion;
import com.nedap.archie.rules.BinaryOperator;
import com.nedap.archie.rules.Constant;
import com.nedap.archie.rules.Constraint;
import com.nedap.archie.rules.Expression;
import com.nedap.archie.rules.ExpressionVariable;
import com.nedap.archie.rules.ForAllStatement;
import com.nedap.archie.rules.Function;
import com.nedap.archie.rules.ModelReference;
import com.nedap.archie.rules.RuleElement;
import com.nedap.archie.rules.RuleStatement;
import com.nedap.archie.rules.UnaryOperator;
import com.nedap.archie.rules.VariableReference;
import com.nedap.archie.serializer.adl.ADLDefinitionSerializer;
import com.nedap.archie.serializer.adl.ADLStringBuilder;
import com.nedap.archie.serializer.adl.rules.AssertionSerializer;
import com.nedap.archie.serializer.adl.rules.BinaryOperatorSerializer;
import com.nedap.archie.serializer.adl.rules.ConstantSerializer;
import com.nedap.archie.serializer.adl.rules.ConstraintSerializer;
import com.nedap.archie.serializer.adl.rules.ExpressionVariableDeclarationSerializer;
import com.nedap.archie.serializer.adl.rules.ForAllStatementSerializer;
import com.nedap.archie.serializer.adl.rules.FunctionSerializer;
import com.nedap.archie.serializer.adl.rules.ModelReferenceSerializer;
import com.nedap.archie.serializer.adl.rules.RuleElementSerializer;
import com.nedap.archie.serializer.adl.rules.UnaryOperatorSerializer;
import com.nedap.archie.serializer.adl.rules.VariableReferenceSerializer;
import java.util.HashMap;
import java.util.Map;

public class ADLRulesSerializer {
    public static int NEW_LINE_LIMIT = 120;
    private ADLStringBuilder builder;
    private ADLDefinitionSerializer definitionSerializer;
    private final Map<Class<?>, RuleElementSerializer<?>> ruleElementSerializers;

    public ADLRulesSerializer(ADLStringBuilder builder, ADLDefinitionSerializer definitionSerializer) {
        this.builder = builder;
        this.definitionSerializer = definitionSerializer;
        this.ruleElementSerializers = new HashMap();
        this.ruleElementSerializers.put(UnaryOperator.class, new UnaryOperatorSerializer(this));
        this.ruleElementSerializers.put(BinaryOperator.class, new BinaryOperatorSerializer(this));
        this.ruleElementSerializers.put(Assertion.class, new AssertionSerializer(this));
        this.ruleElementSerializers.put(ExpressionVariable.class, new ExpressionVariableDeclarationSerializer(this));
        this.ruleElementSerializers.put(ModelReference.class, new ModelReferenceSerializer(this));
        this.ruleElementSerializers.put(Constraint.class, new ConstraintSerializer(this));
        this.ruleElementSerializers.put(VariableReference.class, new VariableReferenceSerializer(this));
        this.ruleElementSerializers.put(Constant.class, new ConstantSerializer(this));
        this.ruleElementSerializers.put(ForAllStatement.class, new ForAllStatementSerializer(this));
        this.ruleElementSerializers.put(Function.class, new FunctionSerializer(this));
    }

    public ADLStringBuilder getBuilder() {
        return this.builder;
    }

    public void serializeRuleElement(RuleElement element) {
        RuleElementSerializer serializer = this.getSerializer(element);
        if (serializer != null) {
            boolean shouldSerializeParentheses = this.isPrecedenceOverride(element);
            boolean addedNewLine = false;
            if (shouldSerializeParentheses) {
                if (this.builder.getCurrentLineLength() > NEW_LINE_LIMIT) {
                    this.builder.newline();
                }
                this.builder.append(" (");
            }
            serializer.serialize(element);
            if (shouldSerializeParentheses) {
                this.builder.append(") ");
                if (addedNewLine) {
                    this.builder.newline();
                }
            }
        } else {
            throw new AssertionError((Object)("Unsupported rule element: " + element.getClass().getName()));
        }
    }

    private boolean isPrecedenceOverride(RuleElement element) {
        return element instanceof Expression && ((Expression)element).isPrecedenceOverridden();
    }

    private RuleElementSerializer getSerializer(RuleElement element) {
        return this.ruleElementSerializers.get(element.getClass());
    }

    public ADLDefinitionSerializer getDefinitionSerializer() {
        return this.definitionSerializer;
    }

    public void appendRules(RulesSection rules) {
        for (RuleStatement rule : rules.getRules()) {
            this.serializeRuleElement(rule);
        }
    }
}

