/*
 * Decompiled with CFR 0.152.
 */
package com.nedap.archie.serializer.adl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.nedap.archie.serializer.adl.jackson.ArchetypeODINMapperFactory;
import com.nedap.archie.serializer.odin.OdinStringBuilder;
import com.nedap.archie.serializer.odin.StructureStringBuilder;
import com.nedap.archie.serializer.odin.StructuredStringAppendable;
import org.openehr.odin.jackson.ODINMapper;

public class ADLStringBuilder
implements StructuredStringAppendable {
    private final StructureStringBuilder builder = new StructureStringBuilder();
    private final ODINMapper odinMapper = new ArchetypeODINMapperFactory().createMapper();

    public ADLStringBuilder append(Object str) {
        String toAppend = str.toString();
        this.builder.append((Object)toAppend);
        return this;
    }

    public ADLStringBuilder text(String str) {
        String text = OdinStringBuilder.quoteText((String)str);
        return this.append(text);
    }

    public ADLStringBuilder tryNewLine() {
        this.builder.tryNewLine();
        return this;
    }

    public ADLStringBuilder newline() {
        this.builder.newline();
        return this;
    }

    public ADLStringBuilder indent() {
        this.builder.indent();
        return this;
    }

    public ADLStringBuilder odin(Object structure) {
        try {
            String odin = this.odinMapper.writeValueAsString(structure);
            this.appendMultipleLines(odin);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public ADLStringBuilder newIndentedLine() {
        return this.indent().newline();
    }

    public ADLStringBuilder unindent() {
        this.builder.unindent();
        return this;
    }

    public ADLStringBuilder newUnindentedLine() {
        return this.unindent().newline();
    }

    public ADLStringBuilder lineComment(String comment) {
        if (comment != null) {
            this.append(StructureStringBuilder.padRight((String)"", (int)4)).append("-- ").append(comment);
        }
        return this;
    }

    public int mark() {
        return this.builder.mark();
    }

    public void revert(int previousMark) {
        this.builder.revert(previousMark);
    }

    public void clearMark() {
        this.builder.clearMark();
    }

    public String toString() {
        return this.builder.toString();
    }

    public ADLStringBuilder ensureSpace() {
        this.builder.ensureSpace();
        return this;
    }

    public void appendMultipleLines(String lines) {
        for (String line : lines.split("\n")) {
            this.builder.append((Object)line);
            this.builder.newline();
        }
    }

    public int getCurrentLineLength() {
        return this.builder.getCurrentLineLength();
    }

    public ODINMapper getOdinMapper() {
        return this.odinMapper;
    }
}

